/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.disassembly.views;

import com.atmel.avr32.debug.ui.disassembly.DisassemblyImageRegistry;
import com.atmel.avr32.debug.ui.disassembly.DisassemblyPlugin;
import com.atmel.avr32.debug.ui.disassembly.actions.TextOperationAction;
import com.atmel.avr32.debug.ui.disassembly.model.Addr2Line;
import com.atmel.avr32.debug.ui.disassembly.model.AddressRangePosition;
import com.atmel.avr32.debug.ui.disassembly.model.DisassemblyDocument;
import com.atmel.avr32.debug.ui.disassembly.model.DisassemblyIPAnnotation;
import com.atmel.avr32.debug.ui.disassembly.model.DisassemblyPosition;
import com.atmel.avr32.debug.ui.disassembly.model.ErrorPosition;
import com.atmel.avr32.debug.ui.disassembly.model.IDisassemblyRetrieval;
import com.atmel.avr32.debug.ui.disassembly.model.LabelPosition;
import com.atmel.avr32.debug.ui.disassembly.model.SourceFileInfo;
import com.atmel.avr32.debug.ui.disassembly.model.SourcePosition;
import com.atmel.avr32.debug.ui.disassembly.util.HSL;
import com.atmel.avr32.debug.ui.disassembly.views.AddressRulerColumn;
import com.atmel.avr32.debug.ui.disassembly.views.CDIDisassemblyRetrieval;
import com.atmel.avr32.debug.ui.disassembly.views.DisassemblyDropAdapter;
import com.atmel.avr32.debug.ui.disassembly.views.DisassemblyRulerColumn;
import com.atmel.avr32.debug.ui.disassembly.views.DisassemblyViewer;
import com.atmel.avr32.debug.ui.disassembly.views.DisassemblyViewerConfiguration;
import com.atmel.avr32.debug.ui.disassembly.views.OpcodeRulerColumn;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.internal.ui.dnd.TextViewerDragAdapter;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public abstract class DisassemblyPart
extends WorkbenchPart
implements IViewportListener,
ITextPresentationListener {
    private static final boolean DEBUG = DisassemblyPlugin.getDefault().isDebugging();
    private static final BigInteger PC_UNKNOWN = BigInteger.valueOf(-1L);
    private static final BigInteger PC_RUNNING = BigInteger.valueOf(-2L);
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    protected static final int VERTICAL_RULER_WIDTH = 12;
    private static final int fgHighWaterMark = 500;
    private static final int fgLowWaterMark = 100;
    private static final String COMMAND_ID_GOTO_ADDRESS = "com.atmel.avr32.debug.ui.disassembly.commands.gotoAddress";
    private static final String COMMAND_ID_GOTO_PC = "com.atmel.avr32.debug.ui.disassembly.commands.gotoPC";
    private static final String COMMAND_ID_GOTO_SYMBOL = "com.atmel.avr32.debug.ui.disassembly.commands.gotoSymbol";
    private static final String KEY_BINDING_CONTEXT_DISASSEMBLY = "com.atmel.avr32.debug.ui.disassembly.context";
    protected DisassemblyViewer fViewer;
    protected DisassemblyAction fActionGotoPC;
    protected DisassemblyAction fActionGotoAddress;
    private DisassemblyAction fActionGotoSymbol;
    private DisassemblyAction fActionToggleBreakpoint;
    protected DisassemblyAction fActionToggleSource;
    private DisassemblyAction fActionToggleOpcodeColumn;
    private DisassemblyAction fActionToggleSymbols;
    private DisassemblyAction fActionRefreshView;
    private Action fActionOpenPreferences;
    private DisassemblyAction fActionToggleAddressColumn;
    private DisassemblyAction fActionToggleBreakpointEnablement;
    protected DisassemblyDocument fDocument;
    private IAnnotationAccess fAnnotationAccess;
    private AnnotationRulerColumn fAnnotationRulerColumn;
    private MarkerAnnotationPreferences fAnnotationPreferences;
    private IPreferenceStore fPreferenceStore;
    private IOverviewRuler fOverviewRuler;
    private BigInteger fStartAddress;
    private BigInteger fEndAddress;
    private volatile boolean fUpdatePending;
    private BigInteger fPCAddress;
    private BigInteger fGotoAddressPending = PC_UNKNOWN;
    private BigInteger fFocusAddress = PC_UNKNOWN;
    private int fBufferZone;
    private SourceViewerDecorationSupport fDecorationSupport;
    private DisassemblyIPAnnotation fPCAnnotation;
    private DisassemblyIPAnnotation fSecondaryPCAnnotation;
    private boolean fPCAnnotationUpdatePending;
    private ArrayList fPendingPCUpdates = new ArrayList(5);
    private Font fFont;
    private IVerticalRuler fVerticalRuler;
    private IFindReplaceTarget fFindReplaceTarget;
    private IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private IThread fTargetContext;
    private IDebugTarget fDebugTarget;
    private int fTargetFrame;
    private Color fInstructionColor;
    private Color fErrorColor;
    private Color fSourceColor;
    private Position fScrollPos;
    private int fScrollLine;
    private Control fRedrawControl;
    private Color fLabelColor;
    private Position fFocusPos;
    private AddressRulerColumn fAddressRulerColumn;
    private Map fBp2Addr = new HashMap();
    private boolean fBPAnnotationUpdatePending;
    private boolean fBPAnnotationsInInvalidAddressRange;
    private BigInteger fFrameAddress;
    protected Map fGlobalActions = new HashMap();
    private List fSelectionActions = new ArrayList();
    private boolean fSourceOnlyMode;
    private boolean fShowSource;
    private boolean fShowOpcodes;
    private boolean fShowSymbols;
    private Point fContextClickLocation;
    private Map fFile2Storage = new HashMap();
    private boolean fShowDisassembly;
    private LinkedList fPCHistory = new LinkedList();
    private int fPCHistorySizeMax = 4;
    private boolean fGotoFramePending;
    private RGB fPCAnnotationRGB;
    private List fStateDependentActions = new ArrayList();
    private Composite fColorFrame;
    private OpcodeRulerColumn fOpcodeRulerColumn;
    private DropTarget fDropTarget;
    private DragSource fDragSource;
    private TextViewerDragAdapter fDragSourceAdapter;
    private DisassemblyDropAdapter fDropTargetAdapter;
    protected Color fMultiXColor;
    private String fPCAnnotationColorKey;
    private ArrayList fRunnableQueue = new ArrayList();
    protected IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == DisassemblyPart.this) {
                DisassemblyPart.this.setActive(false);
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == DisassemblyPart.this) {
                DisassemblyPart.this.setActive(true);
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };
    private boolean fActive = true;
    private boolean fDoPendingPosted;
    private boolean fUpdateBeforeFocus;
    private boolean fRefreshAll;
    private IMarker fGotoMarkerPending;
    private boolean fUpdateTitlePending;
    private boolean fRefreshViewPending;
    private ArrayList fHandlerActivations;
    private IContextActivation fContextActivation;
    private IDisassemblyRetrieval fDisassemblyRetrieval;
    private IDebugEventSetListener fDebugEventListener = new DisassemblyDebugEventListener();
    private boolean fUpdateSourcePending;

    public DisassemblyPart() {
        this.fAnnotationPreferences = new MarkerAnnotationPreferences();
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{DisassemblyPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()}));
        this.fPCAddress = this.fFrameAddress = PC_UNKNOWN;
        this.fTargetFrame = -1;
        this.fBufferZone = 32;
        this.fPCAnnotation = new DisassemblyIPAnnotation(true, 0);
        this.fSecondaryPCAnnotation = new DisassemblyIPAnnotation(false, 0);
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fStartAddress = new BigInteger(prefs.getString("startAddress"));
        String endAddressString = prefs.getString("endAddress");
        this.fEndAddress = endAddressString.startsWith("0x") ? new BigInteger(endAddressString.substring(2), 16) : new BigInteger(endAddressString, 16);
        this.fSourceOnlyMode = prefs.getBoolean("useSourceOnlyMode");
        this.fShowSource = this.fSourceOnlyMode || prefs.getBoolean("showSource");
        this.fShowDisassembly = !this.fSourceOnlyMode || !this.fShowSource;
        this.fShowOpcodes = prefs.getBoolean("showOpcodeRuler");
        this.fShowSymbols = prefs.getBoolean("showSymbols");
        this.fUpdateBeforeFocus = !prefs.getBoolean("avoidReadBeforePC");
        this.fPCHistorySizeMax = prefs.getInt("pcHistorySize");
    }

    protected void handleSuspend() {
        this.updatePC(PC_UNKNOWN);
    }

    protected void handleResumed() {
        this.updatePC(PC_RUNNING);
    }

    public Object getAdapter(Class required) {
        if (IVerticalRulerInfo.class.equals((Object)required)) {
            if (this.fVerticalRuler != null) {
                return this.fVerticalRuler;
            }
        } else {
            if (IFindReplaceTarget.class.equals((Object)required)) {
                if (this.fFindReplaceTarget == null) {
                    this.fFindReplaceTarget = this.fViewer == null ? null : this.fViewer.getFindReplaceTarget();
                }
                return this.fFindReplaceTarget;
            }
            if (ITextOperationTarget.class.equals((Object)required)) {
                return this.fViewer == null ? null : this.fViewer.getTextOperationTarget();
            }
            if (Control.class.equals((Object)required)) {
                return this.fViewer != null ? this.fViewer.getTextWidget() : null;
            }
            if (IGotoMarker.class.equals((Object)required)) {
                return new IGotoMarker(){

                    public void gotoMarker(IMarker marker) {
                        DisassemblyPart.this.gotoMarker(marker);
                    }
                };
            }
            if (IToggleBreakpointsTarget.class.equals((Object)required)) {
                return new IToggleBreakpointsTarget(){

                    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
                        ITextSelection textSelection = (ITextSelection)selection;
                        int line = textSelection.getStartLine();
                        IBreakpoint[] bp = DisassemblyPart.this.getBreakpointsAtLine(line);
                        if (bp == null || bp.length == 0) {
                            DisassemblyPart.this.insertBreakpoint(line, false, false, false);
                        } else {
                            int i = 0;
                            while (i < bp.length) {
                                bp[i].delete();
                                ++i;
                            }
                        }
                    }

                    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
                        return DisassemblyPart.this.fDebugTarget != null;
                    }

                    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
                    }

                    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
                        return false;
                    }

                    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
                    }

                    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
                        return false;
                    }
                };
            }
            if (IRunToLineTarget.class.equals((Object)required)) {
                return new IRunToLineTarget(){

                    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
                    }

                    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
                        return DisassemblyPart.this.fTargetContext != null && DisassemblyPart.this.fTargetContext.isSuspended();
                    }
                };
            }
        }
        return super.getAdapter(required);
    }

    private void setPreferenceStore(IPreferenceStore store) {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        this.fPreferenceStore = store;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (this.fViewer == null) {
            return;
        }
        String property = event.getProperty();
        IPreferenceStore store = this.getPreferenceStore();
        if (this.getFontPropertyPreferenceKey().equals(property)) {
            this.initializeViewerFont((ISourceViewer)this.fViewer);
        } else if (property.equals("showAddressRuler")) {
            this.fActionToggleAddressColumn.update();
            if (this.isAddressRulerVisible()) {
                this.showAddressRuler();
            } else {
                this.hideAddressRuler();
            }
        } else if (property.equals("addressRadix")) {
            if (this.fAddressRulerColumn != null) {
                this.hideAddressRuler();
                this.showAddressRuler();
            }
        } else if (property.equals("showAddressRadix")) {
            if (this.fAddressRulerColumn != null) {
                this.hideAddressRuler();
                this.showAddressRuler();
            }
        } else if (property.equals("showSource")) {
            this.sourceModeChanged(store.getBoolean(property));
        } else if (property.equals("instructionRadix")) {
            Runnable doit = new Runnable(){

                @Override
                public void run() {
                    DisassemblyPart.this.fDocument.invalidateAddressRange(DisassemblyPart.this.fStartAddress, DisassemblyPart.this.fEndAddress, true);
                    if (!DisassemblyPart.this.fShowDisassembly) {
                        DisassemblyPart.this.fDocument.invalidateDisassemblyWithSource(true);
                    }
                    DisassemblyPart.this.fDocument.setMaxOpcodeLength(0);
                    DisassemblyPart.this.fGotoFramePending = true;
                    DisassemblyPart.this.fBPAnnotationUpdatePending = true;
                }
            };
            this.doScrollLocked(doit);
        } else if (property.equals("showSymbols")) {
            boolean showSymbols = store.getBoolean(property);
            if (this.fShowSymbols == showSymbols) {
                return;
            }
            this.fShowSymbols = showSymbols;
            Runnable doit = new Runnable(){

                @Override
                public void run() {
                    DisassemblyPart.this.fDocument.invalidateAddressRange(DisassemblyPart.this.fStartAddress, DisassemblyPart.this.fEndAddress, true);
                    if (!DisassemblyPart.this.fShowDisassembly) {
                        DisassemblyPart.this.fDocument.invalidateDisassemblyWithSource(true);
                    }
                    DisassemblyPart.this.fGotoFramePending = true;
                    DisassemblyPart.this.fBPAnnotationUpdatePending = true;
                }
            };
            this.doScrollLocked(doit);
        } else if (property.equals("useSourceOnlyMode")) {
            this.fSourceOnlyMode = store.getBoolean(property);
            if (this.fDebugTarget != null) {
                this.disassemblyModeChanged(this.isDissemblyMixedModeOn(this.fDebugTarget));
            }
        } else if (property.equals("showOpcodeRuler")) {
            this.fShowOpcodes = store.getBoolean(property);
            this.fActionToggleOpcodeColumn.update();
            if (this.isOpcodeRulerVisible()) {
                this.showOpcodeRuler();
            } else {
                this.hideOpcodeRuler();
            }
        } else if (property.equals("avoidReadBeforePC")) {
            this.fUpdateBeforeFocus = !store.getBoolean(property);
            this.updateVisibleArea();
        } else if (property.equals(this.fPCAnnotationColorKey)) {
            this.fPCAnnotationRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)this.fPCAnnotationColorKey);
            for (AddressRangePosition pos : this.fPCHistory) {
                this.fViewer.invalidateTextPresentation(pos.offset, pos.length);
            }
        } else if (property.equals("pcHistorySize")) {
            this.fPCHistorySizeMax = store.getInt(property);
        }
    }

    public void createPartControl(Composite parent) {
        this.fColorFrame = parent;
        FillLayout layout = new FillLayout();
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.fVerticalRuler = this.createVerticalRuler();
        int styles = 68354;
        this.fViewer = new DisassemblyViewer(parent, this.fVerticalRuler, this.getOverviewRuler(), true, styles);
        DisassemblyViewerConfiguration sourceViewerConfig = new DisassemblyViewerConfiguration(this);
        this.fViewer.addTextPresentationListener(this);
        this.fViewer.configure((SourceViewerConfiguration)sourceViewerConfig);
        this.fDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this.fViewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
        this.configureSourceViewerDecorationSupport(this.fDecorationSupport);
        this.fDecorationSupport.install(this.getPreferenceStore());
        this.fPCAnnotationRGB = this.fPCAnnotationColorKey != null ? PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.fPCAnnotationColorKey) : parent.getDisplay().getSystemColor(26).getRGB();
        this.initializeViewerFont((ISourceViewer)this.fViewer);
        this.createActions();
        this.hookRulerContextMenu();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DisassemblyPart.this.updateSelectionDependentActions();
            }
        });
        this.fDocument = this.createDocument();
        this.fViewer.setDocument((IDocument)this.fDocument, (IAnnotationModel)new AnnotationModel());
        JFaceResources.getFontRegistry().addListener(this.fPropertyChangeListener);
        this.fErrorColor = this.getSharedColors().getColor(new RGB(96, 0, 0));
        this.fInstructionColor = this.getSharedColors().getColor(new RGB(0, 0, 96));
        this.fSourceColor = this.getSharedColors().getColor(new RGB(64, 0, 80));
        this.fLabelColor = this.getSharedColors().getColor(new RGB(0, 0, 96));
        if (this.isAddressRulerVisible()) {
            this.showAddressRuler();
        }
        if (this.isOpcodeRulerVisible()) {
            this.showOpcodeRuler();
        }
        this.initDragAndDrop();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fViewer.getControl(), "com.atmel.avr32.debug.ui.disassembly.disassembly_view");
        this.updateTitle();
        this.updateStateDependentActions();
        if (this.fDebugTarget != null) {
            this.debugContextChanged();
        } else {
            this.updateDebugContext();
        }
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        site.getPage().addPartListener(this.fPartListener);
    }

    private DisassemblyDocument createDocument() {
        DisassemblyDocument doc = new DisassemblyDocument();
        return doc;
    }

    public void dispose() {
        IWorkbenchPartSite site = this.getSite();
        site.setSelectionProvider(null);
        site.getPage().removePartListener(this.fPartListener);
        if (this.fHandlerActivations != null) {
            IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
            handlerService.deactivateHandlers((Collection)this.fHandlerActivations);
            this.fHandlerActivations = null;
        }
        if (this.fContextActivation != null) {
            IContextService ctxService = (IContextService)site.getService(IContextService.class);
            ctxService.deactivateContext(this.fContextActivation);
        }
        DebugPlugin.getDefault().removeDebugEventListener(this.fDebugEventListener);
        this.fViewer = null;
        this.fDebugTarget = null;
        this.fTargetContext = null;
        this.fAnnotationAccess = null;
        this.fAnnotationPreferences = null;
        this.fAnnotationRulerColumn = null;
        this.fColorFrame = null;
        if (this.fDecorationSupport != null) {
            this.fDecorationSupport.uninstall();
            this.fDecorationSupport = null;
        }
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        if (this.fDropTarget != null) {
            this.fDropTarget.dispose();
            this.fDropTarget = null;
            this.fDragSource.dispose();
            this.fDragSource = null;
        }
        if (this.fPropertyChangeListener != null) {
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
                this.fPreferenceStore = null;
            }
            this.fPropertyChangeListener = null;
        }
        this.fDocument.dispose();
        this.fDocument = null;
        super.dispose();
    }

    private void initDragAndDrop() {
        if (this.fDropTarget == null) {
            StyledText dropControl;
            Transfer[] dropTypes = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
            Transfer[] dragTypes = new Transfer[]{TextTransfer.getInstance()};
            StyledText dragControl = dropControl = this.getSourceViewer().getTextWidget();
            int dropOps = 17;
            int dragOps = 17;
            this.fDropTarget = new DropTarget((Control)dropControl, dropOps);
            this.fDropTarget.setTransfer(dropTypes);
            this.fDropTargetAdapter = new DisassemblyDropAdapter(this);
            this.fDropTarget.addDropListener((DropTargetListener)this.fDropTargetAdapter);
            this.fDragSource = new DragSource((Control)dragControl, dragOps);
            this.fDragSource.setTransfer(dragTypes);
            this.fDragSourceAdapter = new TextViewerDragAdapter((ITextViewer)this.getSourceViewer());
            this.fDragSource.addDragListener((DragSourceListener)this.fDragSourceAdapter);
        }
    }

    private ISourceViewer getSourceViewer() {
        return this.fViewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        for (AnnotationPreference pref : this.fAnnotationPreferences.getAnnotationPreferences()) {
            support.setAnnotationPreference(pref);
            if (!pref.getAnnotationType().equals(this.fPCAnnotation.getType())) continue;
            this.fPCAnnotationColorKey = pref.getColorPreferenceKey();
        }
        support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        support.setSymbolicFontName(this.getFontPropertyPreferenceKey());
    }

    private String getSymbolicFontName() {
        if (this.getConfigurationElement() != null) {
            return this.getConfigurationElement().getAttribute("symbolicFontName");
        }
        return null;
    }

    protected final String getFontPropertyPreferenceKey() {
        String symbolicFontName = this.getSymbolicFontName();
        if (symbolicFontName != null) {
            return symbolicFontName;
        }
        return "org.eclipse.jface.textfont";
    }

    private void initializeViewerFont(ISourceViewer viewer) {
        FontData data;
        boolean isSharedFont = true;
        Font font = null;
        String symbolicFontName = this.getSymbolicFontName();
        if (symbolicFontName != null) {
            font = JFaceResources.getFont((String)symbolicFontName);
        } else if (this.fPreferenceStore != null && this.fPreferenceStore.contains("org.eclipse.jface.textfont") && !this.fPreferenceStore.isDefault("org.eclipse.jface.textfont") && (data = PreferenceConverter.getFontData((IPreferenceStore)this.fPreferenceStore, (String)"org.eclipse.jface.textfont")) != null) {
            isSharedFont = false;
            font = new Font((Device)viewer.getTextWidget().getDisplay(), data);
        }
        if (font == null) {
            font = JFaceResources.getTextFont();
        }
        this.setFont(viewer, font);
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        if (!isSharedFont) {
            this.fFont = font;
        }
    }

    private void setFont(ISourceViewer sourceViewer, Font font) {
        if (sourceViewer.getDocument() != null) {
            StyledText styledText;
            Point selection = sourceViewer.getSelectedRange();
            int topIndex = sourceViewer.getTopIndex();
            StyledText parent = styledText = sourceViewer.getTextWidget();
            if (sourceViewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)sourceViewer;
                parent = extension.getControl();
            }
            parent.setRedraw(false);
            styledText.setFont(font);
            if (this.fVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)this.fVerticalRuler;
                e.setFont(font);
            }
            sourceViewer.setSelectedRange(selection.x, selection.y);
            sourceViewer.setTopIndex(topIndex);
            if (parent instanceof Composite) {
                Composite composite = (Composite)parent;
                composite.layout(true);
            }
            parent.setRedraw(true);
        } else {
            StyledText styledText = sourceViewer.getTextWidget();
            styledText.setFont(font);
            if (this.fVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)this.fVerticalRuler;
                e.setFont(font);
            }
        }
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = this.createCompositeRuler();
        IPreferenceStore store = this.getPreferenceStore();
        if (ruler != null && store != null) {
            Iterator iter = ruler.getDecoratorIterator();
            while (iter.hasNext()) {
                IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
                if (!(column instanceof AnnotationRulerColumn)) continue;
                this.fAnnotationRulerColumn = (AnnotationRulerColumn)column;
                for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
                    String key = preference.getVerticalRulerPreferenceKey();
                    boolean showAnnotation = true;
                    if (key != null && store.contains(key)) {
                        showAnnotation = store.getBoolean(key);
                    }
                    if (!showAnnotation) continue;
                    this.fAnnotationRulerColumn.addAnnotationType(preference.getAnnotationType());
                }
                this.fAnnotationRulerColumn.addAnnotationType((Object)"org.eclipse.text.annotation.unknown");
                break;
            }
        }
        return ruler;
    }

    protected IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }

    protected IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    protected ISharedTextColors getSharedColors() {
        ISharedTextColors sharedColors = CUIPlugin.getDefault().getSharedTextColors();
        return sharedColors;
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        OverviewRuler ruler = new OverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    protected IVerticalRulerColumn createAddressRulerColumn() {
        this.fAddressRulerColumn = new AddressRulerColumn();
        this.initializeRulerColumn(this.fAddressRulerColumn, "addressColor");
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fAddressRulerColumn.setRadix(prefs.getInt("addressRadix"));
        this.fAddressRulerColumn.setShowRadixPrefix(prefs.getBoolean("showAddressRadix"));
        return this.fAddressRulerColumn;
    }

    protected IVerticalRulerColumn createOpcodeRulerColumn() {
        this.fOpcodeRulerColumn = new OpcodeRulerColumn();
        this.initializeRulerColumn(this.fOpcodeRulerColumn, "opcodeColor");
        return this.fOpcodeRulerColumn;
    }

    protected void initializeRulerColumn(DisassemblyRulerColumn rulerColumn, String colorPrefKey) {
        ISharedTextColors sharedColors = this.getSharedColors();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            RGB rgb = null;
            if (store.contains(colorPrefKey)) {
                rgb = store.isDefault(colorPrefKey) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)colorPrefKey) : PreferenceConverter.getColor((IPreferenceStore)store, (String)colorPrefKey);
            }
            if (rgb == null) {
                rgb = new RGB(0, 0, 0);
            }
            rulerColumn.setForeground(sharedColors.getColor(rgb));
            rgb = null;
            rulerColumn.redraw();
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    protected CompositeRuler createCompositeRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12, this.getAnnotationAccess()));
        return ruler;
    }

    private boolean isAddressRulerVisible() {
        return this.getPreferenceStore().getBoolean("showAddressRuler");
    }

    private void showAddressRuler() {
        IVerticalRuler v;
        if (this.fAddressRulerColumn == null && (v = this.getVerticalRuler()) instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.addDecorator(1, this.createAddressRulerColumn());
        }
    }

    private void hideAddressRuler() {
        if (this.fAddressRulerColumn != null) {
            IVerticalRuler v = this.getVerticalRuler();
            if (v instanceof CompositeRuler) {
                CompositeRuler c = (CompositeRuler)v;
                c.removeDecorator((IVerticalRulerColumn)this.fAddressRulerColumn);
            }
            this.fAddressRulerColumn = null;
        }
    }

    private boolean isOpcodeRulerVisible() {
        return this.fShowOpcodes;
    }

    private void showOpcodeRuler() {
        IVerticalRuler v;
        if (this.fOpcodeRulerColumn == null && (v = this.getVerticalRuler()) instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.addDecorator(2, this.createOpcodeRulerColumn());
        }
    }

    private void hideOpcodeRuler() {
        if (this.fOpcodeRulerColumn != null) {
            IVerticalRuler v = this.getVerticalRuler();
            if (v instanceof CompositeRuler) {
                CompositeRuler c = (CompositeRuler)v;
                c.removeDecorator((IVerticalRulerColumn)this.fOpcodeRulerColumn);
            }
            this.fOpcodeRulerColumn = null;
        }
    }

    protected IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    private void hookContextMenu() {
        String id = ((Object)((Object)this)).getClass().getName();
        MenuManager menuMgr = new MenuManager(id, id);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DisassemblyPart.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.fViewer.getTextWidget());
        this.fViewer.getTextWidget().setMenu(menu);
        this.getSite().registerContextMenu(id, menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void hookRulerContextMenu() {
        String id = String.valueOf(((Object)((Object)this)).getClass().getName()) + "Ruler";
        MenuManager menuMgr = new MenuManager(id, id);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DisassemblyPart.this.fillRulerContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fVerticalRuler.getControl());
        this.fVerticalRuler.getControl().setMenu(menu);
        this.getSite().registerContextMenu(id, menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void contributeToActionBars() {
        IWorkbenchPartSite site = this.getSite();
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
        IContextService ctxService = (IContextService)site.getService(IContextService.class);
        this.fContextActivation = ctxService.activateContext(KEY_BINDING_CONTEXT_DISASSEMBLY);
        this.contributeToActionBars(this.getActionBars());
    }

    protected abstract IActionBars getActionBars();

    protected void contributeToActionBars(IActionBars bars) {
        for (String key : this.fGlobalActions.keySet()) {
            IAction action = (IAction)this.fGlobalActions.get(key);
            bars.setGlobalActionHandler(key, action);
        }
        IMenuManager menu = bars.getMenuManager();
        IMenuManager navigateMenu = menu.findMenuUsingPath("navigate");
        if (navigateMenu != null) {
            navigateMenu.appendToGroup("additions", (IAction)this.fActionGotoPC);
            navigateMenu.appendToGroup("additions", (IAction)this.fActionGotoAddress);
            navigateMenu.appendToGroup("additions", (IAction)this.fActionGotoSymbol);
        }
        bars.updateActionBars();
    }

    protected void fillContextMenu(IMenuManager manager) {
        Point cursorLoc = this.getSite().getShell().getDisplay().getCursorLocation();
        this.fContextClickLocation = this.fViewer.getTextWidget().toControl(cursorLoc);
        this.fActionToggleSource.update();
        this.fActionToggleSymbols.update();
        manager.add((IContributionItem)new GroupMarker("group.top"));
        manager.add((IContributionItem)new Separator("group.breakpoints"));
        manager.add((IContributionItem)new Separator("goTo"));
        manager.add((IAction)this.fActionGotoPC);
        manager.add((IAction)this.fActionGotoAddress);
        manager.add((IAction)this.fActionGotoSymbol);
        manager.add((IContributionItem)new Separator("group.debug"));
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        manager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        manager.add((IContributionItem)new Separator("settings"));
        manager.add((IAction)this.fActionToggleSource);
        manager.add((IAction)this.fActionToggleSymbols);
        manager.add((IAction)this.fActionOpenPreferences);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fActionRefreshView);
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillRulerContextMenu(IMenuManager manager) {
        this.fActionToggleBreakpoint.update();
        this.fActionToggleBreakpointEnablement.update();
        this.fActionToggleAddressColumn.update();
        this.fActionToggleOpcodeColumn.update();
        manager.add((IContributionItem)new Separator("debug"));
        manager.add((IAction)this.fActionToggleBreakpoint);
        manager.add((IAction)this.fActionToggleBreakpointEnablement);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new GroupMarker("restore"));
        manager.add((IContributionItem)new Separator("add"));
        manager.add((IContributionItem)new Separator("rulers"));
        manager.add((IAction)this.fActionToggleAddressColumn);
        manager.add((IAction)this.fActionToggleOpcodeColumn);
        manager.add((IContributionItem)new Separator("group.rest"));
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fActionGotoPC);
        manager.add((IAction)this.fActionGotoAddress);
    }

    protected void updateSelectionDependentActions() {
        for (IUpdate action : this.fSelectionActions) {
            action.update();
        }
    }

    protected void updateStateDependentActions() {
        for (IUpdate action : this.fStateDependentActions) {
            action.update();
        }
    }

    protected void createActions() {
        TextOperationAction action = new TextOperationAction((ITextViewer)this.fViewer, 4);
        action.setText(DisassemblyPlugin.getResourceString("Disassembly.action.Copy.label"));
        action.setImageDescriptor(DisassemblyPlugin.getImageDescriptor(DisassemblyImageRegistry.ICON_Copy_enabled));
        action.setDisabledImageDescriptor(DisassemblyPlugin.getImageDescriptor(DisassemblyImageRegistry.ICON_Copy_disabled));
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, action);
        this.fSelectionActions.add(action);
        action = new TextOperationAction((ITextViewer)this.fViewer, 7);
        action.setText(DisassemblyPlugin.getResourceString("Disassembly.action.SelectAll.label"));
        action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new TextOperationAction((ITextViewer)this.fViewer, 10);
        action.setActionDefinitionId("org.eclipse.ui.file.print");
        this.fGlobalActions.put(ITextEditorActionConstants.PRINT, action);
        this.fActionGotoPC = new ActionGotoPC();
        this.fActionGotoPC.setActionDefinitionId(COMMAND_ID_GOTO_PC);
        this.fStateDependentActions.add(this.fActionGotoPC);
        this.registerWithHandlerService((IAction)this.fActionGotoPC);
        this.fActionGotoAddress = new ActionGotoAddress();
        this.fActionGotoAddress.setActionDefinitionId(COMMAND_ID_GOTO_ADDRESS);
        this.fStateDependentActions.add(this.fActionGotoAddress);
        this.registerWithHandlerService((IAction)this.fActionGotoAddress);
        this.fActionGotoSymbol = new ActionGotoSymbol();
        this.fActionGotoSymbol.setActionDefinitionId(COMMAND_ID_GOTO_SYMBOL);
        this.fStateDependentActions.add(this.fActionGotoSymbol);
        this.registerWithHandlerService((IAction)this.fActionGotoSymbol);
        this.fActionToggleSource = new ActionToggleSource();
        this.fStateDependentActions.add(this.fActionToggleSource);
        this.fActionToggleBreakpoint = new ActionToggleBreakpoint();
        this.fVerticalRuler.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DisassemblyPart.this.fActionToggleBreakpoint.update();
                if (DisassemblyPart.this.fActionToggleBreakpoint.isEnabled()) {
                    DisassemblyPart.this.fActionToggleBreakpoint.run();
                }
            }
        });
        this.fActionToggleBreakpointEnablement = new ActionToggleBreakpointEnablement();
        this.fActionToggleAddressColumn = new ActionToggleAddressColumn();
        this.fActionToggleOpcodeColumn = new ActionToggleOpcodeColumn();
        this.fActionToggleSymbols = new ActionToggleSymbols();
        this.fActionRefreshView = new ActionRefreshView();
        this.fStateDependentActions.add(this.fActionRefreshView);
        this.fGlobalActions.put(ActionFactory.REFRESH.getId(), this.fActionRefreshView);
        this.fActionOpenPreferences = new ActionOpenPreferences();
    }

    private void registerWithHandlerService(IAction action) {
        if (this.fHandlerActivations == null) {
            this.fHandlerActivations = new ArrayList(5);
        }
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.fHandlerActivations.add(handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action)));
    }

    public void gotoFrame(int frame) {
        if (this.fActive) {
            this.gotoFrame(frame, PC_UNKNOWN);
        }
    }

    public void gotoAddress(BigInteger address) {
        this.fFocusAddress = address;
        if (this.fDebugTarget == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("gotoAddress " + DisassemblyPart.getAddressText(address));
        }
        if (this.fGotoAddressPending.compareTo(PC_UNKNOWN) == 0) {
            this.fGotoAddressPending = address;
        }
        if (this.fUpdatePending) {
            return;
        }
        AddressRangePosition pos = this.getPositionOfAddress(address);
        if (pos != null) {
            if (pos.fValid) {
                Object previousPos = null;
                if (previousPos == null || previousPos.fValid) {
                    if (this.fGotoAddressPending == address) {
                        this.fGotoAddressPending = PC_UNKNOWN;
                    }
                    this.gotoPosition(pos, false);
                } else {
                    int lines = this.fBufferZone + 3;
                    BigInteger endAddress = pos.fAddressOffset;
                    BigInteger startAddress = previousPos.fAddressOffset.max(endAddress.subtract(BigInteger.valueOf(lines * this.fDocument.getMeanSizeOfInstructions())));
                    this.retrieveDisassembly(startAddress, endAddress, lines);
                }
            } else {
                int lines = this.fBufferZone + 3;
                BigInteger endAddress = pos.fAddressOffset.add(pos.fAddressLength).min(address.add(BigInteger.valueOf(lines * this.fDocument.getMeanSizeOfInstructions())));
                this.retrieveDisassembly(address, endAddress, lines);
            }
        }
    }

    public void gotoSymbol(String symbol) {
    }

    private void gotoPosition(Position pos, boolean select) {
        if (this.fViewer == null) {
            return;
        }
        this.setFocusPosition(pos);
        this.fViewer.setSelectedRange(pos.offset, select ? Math.max(pos.length - 1, 0) : 0);
        int revealOffset = pos.offset;
        boolean onTop = false;
        if (pos.offset > 0) {
            try {
                AddressRangePosition previousPos = this.fDocument.getModelPosition(pos.offset - 1);
                if (previousPos instanceof LabelPosition) {
                    revealOffset = previousPos.offset;
                    onTop = true;
                } else if (!previousPos.fValid) {
                    onTop = true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        this.fViewer.revealOffset(revealOffset, onTop);
    }

    private void gotoMarker(IMarker marker) {
        if (marker == null) {
            return;
        }
        if (this.fDebugTarget == null || this.fUpdatePending) {
            this.fGotoMarkerPending = marker;
            return;
        }
        this.fGotoMarkerPending = null;
    }

    public void viewportChanged(int verticalOffset) {
        if (this.fDebugTarget != null && this.fGotoAddressPending == PC_UNKNOWN && this.fScrollPos == null && !this.fUpdatePending && !this.fRefreshViewPending) {
            this.fUpdatePending = true;
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!$assertionsDisabled && !DisassemblyPart.this.fUpdatePending) {
                        throw new AssertionError();
                    }
                    if (DisassemblyPart.this.fUpdatePending) {
                        DisassemblyPart.this.fUpdatePending = false;
                        DisassemblyPart.this.updateVisibleArea();
                    }
                }
            });
        }
    }

    private void updateVisibleArea() {
        boolean isScrollingUp;
        if (!this.fActive || this.fUpdatePending || this.fViewer == null || this.fDebugTarget == null) {
            return;
        }
        if (!this.fTargetContext.isSuspended()) {
            return;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        Rectangle clientArea = styledText.getClientArea();
        this.fBufferZone = Math.max(8, clientArea.height / styledText.getLineHeight());
        int topIndex = this.fViewer.getTopIndex();
        int bottomIndex = this.fViewer.getBottomIndex();
        int focusIndex = -1;
        boolean focusVisible = false;
        boolean bl = isScrollingUp = this.fViewer.isUserTriggeredScrolling() && this.fViewer.getLastTopPixel() >= styledText.getTopPixel();
        if (this.fFocusPos != null) {
            try {
                int focusOffset = this.fFocusPos.offset;
                focusIndex = this.fDocument.getLineOfOffset(focusOffset);
                boolean bl2 = focusVisible = focusIndex >= topIndex && focusIndex <= bottomIndex;
                if (!focusVisible) {
                    Point selection = this.fViewer.getSelectedRange();
                    if (selection.x == focusOffset && selection.y > 0) {
                        this.fViewer.setSelectedRange(selection.x, 0);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                this.setFocusPosition(null);
            }
        }
        if (!focusVisible) {
            focusIndex = topIndex + this.fScrollLine;
        }
        BigInteger focusAddress = this.getAddressOfLine(focusIndex);
        bottomIndex += 2;
        AddressRangePosition bestPosition = null;
        int bestLine = -1;
        BigInteger bestDistance = null;
        for (AddressRangePosition p : this.fDocument.getInvalidAddressRanges()) {
            try {
                int line = this.fDocument.getLineOfOffset(p.offset);
                if (line < topIndex || line > bottomIndex || !(p instanceof DisassemblyPosition) && p.fAddressLength.compareTo(BigInteger.valueOf(this.fBufferZone * 2)) > 0 && !isScrollingUp && !this.fUpdateBeforeFocus && p.fAddressOffset.compareTo(focusAddress) < 0) continue;
                BigInteger distance = p.fAddressOffset.subtract(focusAddress).abs();
                if (bestDistance != null && distance.compareTo(bestDistance) >= 0) continue;
                bestPosition = p;
                bestLine = line;
                bestDistance = distance;
                if (bestDistance.compareTo(BigInteger.valueOf(this.fBufferZone * 2)) > 0) continue;
                break;
            }
            catch (BadLocationException badLocationException) {}
        }
        if (bestPosition != null) {
            int lines = this.fBufferZone + 3;
            BigInteger startAddress = bestPosition.fAddressOffset;
            BigInteger endAddress = bestPosition.fAddressOffset.add(bestPosition.fAddressLength);
            BigInteger addressRange = BigInteger.valueOf(lines * this.fDocument.getMeanSizeOfInstructions());
            if (bestLine > focusIndex || bestLine == focusIndex && startAddress.compareTo(focusAddress) >= 0) {
                if (endAddress.subtract(startAddress).compareTo(addressRange) < 0) {
                    Iterator iter = this.fDocument.getModelPositionIterator(endAddress);
                    while (iter.hasNext()) {
                        AddressRangePosition p = (AddressRangePosition)((Object)iter.next());
                        if (p.fValid && (endAddress = endAddress.add(p.fAddressLength)).subtract(startAddress).compareTo(addressRange) < 0) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                startAddress = startAddress.max(endAddress.subtract(addressRange));
                lines = endAddress.subtract(startAddress).intValue();
            }
            this.retrieveDisassembly(startAddress, endAddress, lines);
        }
        this.scheduleDoPending();
    }

    private void asyncExec(Runnable runnable) {
        if (this.fViewer != null) {
            this.fViewer.getControl().getDisplay().asyncExec(runnable);
        }
    }

    private void invokeLater(Runnable runnable) {
        this.invokeLater(10, runnable);
    }

    private void invokeLater(int delay, Runnable runnable) {
        if (this.fViewer != null) {
            this.fViewer.getControl().getDisplay().timerExec(delay, runnable);
        }
    }

    private void updateInvalidSource() {
        if (this.fViewer == null) {
            return;
        }
        boolean unlock = false;
        try {
            if (this.fScrollPos == null) {
                if (this.fUpdatePending) {
                    this.fUpdateSourcePending = true;
                    return;
                }
                this.fUpdateSourcePending = false;
                unlock = true;
                this.fUpdatePending = true;
                this.lockScroller();
            }
            ArrayList copy = new ArrayList(this.fDocument.getInvalidSource());
            for (SourcePosition p : copy) {
                if (!p.fValid) {
                    this.insertSource(p);
                    continue;
                }
                if (!DEBUG || !this.fDocument.getInvalidSource().remove((Object)p)) continue;
                System.err.println("!!! valid source position in invalid source list at " + DisassemblyPart.getAddressText(p.fAddressOffset));
            }
        }
        finally {
            if (unlock) {
                this.fUpdatePending = false;
                this.unlockScroller();
                this.doPending();
            }
        }
    }

    private void retrieveDisassembly(BigInteger startAddress, BigInteger endAddress, int lines) {
        if (this.fDebugTarget == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("retrieveDisassembly " + DisassemblyPart.getAddressText(startAddress) + " " + lines + " lines");
        }
        this.retrieveDisassemblyFrom(startAddress, endAddress, null, lines);
    }

    void retrieveDisassembly(final String file, final int lines) {
        Path debuggerPath;
        if (this.fDebugTarget == null) {
            return;
        }
        if (this.fUpdatePending) {
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DisassemblyPart.this.retrieveDisassembly(file, lines);
                }
            });
            return;
        }
        if (DEBUG) {
            System.out.println("retrieveDisassembly " + file);
        }
        if ((debuggerPath = null) == null) {
            debuggerPath = new Path(file);
        }
        this.retrieveDisassemblyFrom(null, null, debuggerPath.toString(), lines);
    }

    private void retrieveDisassemblyFrom(final BigInteger startAddress, BigInteger endAddress, String file, int lines) {
        assert (!this.fUpdatePending);
        this.fUpdatePending = true;
        BigInteger addressLength = BigInteger.valueOf(lines * 4);
        if (endAddress.subtract(startAddress).compareTo(addressLength) > 0) {
            endAddress = startAddress.add(addressLength);
        }
        BigInteger finalEndAddress = endAddress;
        IDisassemblyRetrieval.DisassemblyRequest disassemblyRequest = new IDisassemblyRetrieval.DisassemblyRequest(){

            @Override
            public void done() {
                if (!this.isCanceled() && this.getDisassemblyBlock() != null) {
                    DisassemblyPart.this.insertDisassembly(startAddress, this.getDisassemblyBlock());
                } else {
                    final IStatus status = this.getStatus();
                    if (status != null && !status.isOK() && startAddress != null) {
                        DisassemblyPart.this.doScrollLocked(new Runnable(){

                            @Override
                            public void run() {
                                DisassemblyPart.this.insertError(startAddress, status.getMessage());
                            }
                        });
                    }
                    DisassemblyPart.this.fUpdatePending = false;
                }
            }
        };
        this.fDisassemblyRetrieval.asyncGetDisassembly(startAddress, finalEndAddress, file, lines, disassemblyRequest);
    }

    private void insertError(BigInteger address, String message) {
        AddressRangePosition p = null;
        p = this.getPositionOfAddress(address);
        if (p.fValid) {
            return;
        }
        try {
            this.fDocument.insertErrorLine(p, address, BigInteger.ONE, message);
        }
        catch (BadLocationException exc) {
            DisassemblyPart.internalError(exc);
        }
    }

    /*
     * Exception decompiling
     */
    private void insertDisassembly(BigInteger startAddress, IDisassemblyBlock disassemblyBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void retrieveFrameAddress(IThread targetContext, final int frame) {
        if (targetContext != null && targetContext.isSuspended()) {
            if (this.fUpdatePending) {
                this.gotoFrame(frame);
                return;
            }
            if (DEBUG) {
                System.out.println("retrieveFrameAddress " + frame);
            }
            this.fUpdatePending = true;
            try {
                IStackFrame stackFrame = targetContext.getStackFrames()[frame];
                this.fDisassemblyRetrieval.asyncGetFrameAddress(stackFrame, new IDisassemblyRetrieval.AddressRequest(){

                    @Override
                    public void done() {
                        DisassemblyPart.this.fUpdatePending = false;
                        if (!this.isCanceled()) {
                            BigInteger address = this.getAddress();
                            if (DEBUG) {
                                System.out.println("retrieveFrameAddress done " + DisassemblyPart.getAddressText(address));
                            }
                            if (frame == 0) {
                                DisassemblyPart.this.updatePC(address);
                            } else {
                                DisassemblyPart.this.gotoFrame(frame, address);
                            }
                        }
                    }
                });
            }
            catch (DebugException exc) {
                DisassemblyPart.internalError(exc);
            }
        }
    }

    private AddressRangePosition getPositionOfAddress(BigInteger address) {
        if (address == null || address.compareTo(BigInteger.ZERO) < 0) {
            return null;
        }
        AddressRangePosition pos = this.fDocument.getPositionOfAddress(address);
        assert (!(pos instanceof SourcePosition));
        assert (pos != null || address.compareTo(this.fStartAddress) < 0 || address.compareTo(this.fEndAddress) >= 0);
        return pos;
    }

    private BigInteger getAddressOfLine(int line) {
        return this.fDocument.getAddressOfLine(line);
    }

    private BigInteger getAddressOfOffset(int offset) {
        return this.fDocument.getAddressOfOffset(offset);
    }

    private BigInteger getAddressOfPoint(Point location) {
        int offset = this.getOffsetOfPoint(location);
        if (offset < 0) {
            return PC_UNKNOWN;
        }
        return this.getAddressOfOffset(offset);
    }

    private int getOffsetOfPoint(Point location) {
        if (location == null) {
            return -1;
        }
        StyledText text = this.fViewer.getTextWidget();
        int line = (location.y + text.getTopPixel()) / text.getLineHeight();
        try {
            return this.fDocument.getLineOffset(line);
        }
        catch (BadLocationException e) {
            DisassemblyPart.internalError(e);
            return -1;
        }
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    protected void setActive(boolean active) {
        if (DEBUG) {
            System.out.println("setActive(" + active + ")");
        }
        this.fActive = active;
        if (this.fActive) {
            if (this.fRefreshAll) {
                this.fRefreshAll = false;
                this.refreshView(0);
            } else {
                this.doPendingPCUpdates();
                if (this.fTargetContext != null) {
                    int frame = this.getActiveStackFrame();
                    if (frame < 0 && this.fTargetContext.isSuspended()) {
                        frame = 0;
                    }
                    if (frame != this.fTargetFrame) {
                        this.gotoFrame(frame);
                    }
                }
            }
        } else {
            this.fGotoAddressPending = this.fFocusAddress = PC_UNKNOWN;
        }
    }

    private int getActiveStackFrame() {
        return -1;
    }

    protected void updateDebugContext() {
        IAdaptable debugContext = DebugUITools.getDebugContext();
        if (debugContext instanceof IDebugElement) {
            this.setDebugContext((IDebugElement)debugContext);
        }
    }

    protected void setDebugContext(IDebugElement debugElement) {
        if (debugElement != null) {
            IDebugTarget debugTarget = debugElement.getDebugTarget();
            if (this.fDebugTarget != debugTarget) {
                if (DEBUG) {
                    System.out.println("DisassemblyPart.setDebugContext() " + debugTarget);
                }
                this.fTargetContext = null;
                if (debugElement instanceof IStackFrame) {
                    IStackFrame frame = (IStackFrame)debugElement;
                    this.fTargetContext = frame.getThread();
                }
                if (this.fTargetContext != null) {
                    this.fDebugTarget = debugTarget;
                    if (this.fViewer != null) {
                        this.debugContextChanged();
                    }
                }
            } else if (debugElement instanceof IStackFrame) {
                IStackFrame frame = (IStackFrame)debugElement;
                this.fTargetContext = frame.getThread();
                try {
                    int idx = Arrays.asList(this.fTargetContext.getStackFrames()).indexOf(frame);
                    this.gotoFrame(idx);
                }
                catch (DebugException exc) {
                    DisassemblyPart.internalError(exc);
                }
            }
        } else if (this.fDebugTarget != null) {
            this.fDebugTarget = null;
            this.fTargetContext = null;
            if (this.fViewer != null) {
                this.debugContextChanged();
            }
        }
    }

    private void debugContextChanged() {
        if (DEBUG) {
            System.out.println("DisassemblyPart.debugContextChanged()");
        }
        this.fRunnableQueue.clear();
        this.fUpdatePending = false;
        this.resetViewer();
        if (this.fDebugTarget != null) {
            if (this.fDebugTarget instanceof ICDebugTarget) {
                this.fDisassemblyRetrieval = new CDIDisassemblyRetrieval((ICDebugTarget)this.fDebugTarget);
            }
            DebugPlugin.getDefault().addDebugEventListener(this.fDebugEventListener);
            if (this.fAddressRulerColumn != null && this.fColorFrame != null) {
                this.fColorFrame.layout(true);
            }
            this.updatePC(PC_UNKNOWN);
            if (this.fGotoAddressPending != PC_UNKNOWN) {
                this.gotoAddress(this.fGotoAddressPending);
            }
            if (this.fGotoMarkerPending != null) {
                this.gotoMarker(this.fGotoMarkerPending);
            }
            this.updateBPAnnotations();
            this.fViewer.addViewportListener(this);
        } else {
            DebugPlugin.getDefault().removeDebugEventListener(this.fDebugEventListener);
            this.fViewer.removeViewportListener(this);
            this.fGotoMarkerPending = null;
        }
        this.updateTitle();
        this.updateStateDependentActions();
    }

    private void refreshView(int delay) {
        if (this.fViewer == null || this.fRefreshViewPending || this.fRefreshAll) {
            return;
        }
        this.fRunnableQueue.clear();
        this.fRefreshViewPending = true;
        final long refreshViewScheduled = System.currentTimeMillis() + (long)delay;
        final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                DisassemblyPart.this.fRefreshViewPending = false;
                long now = System.currentTimeMillis();
                if (now >= refreshViewScheduled) {
                    if (DEBUG) {
                        System.err.println("*** refreshing view ***");
                    }
                    DisassemblyPart.this.fFocusAddress = PC_UNKNOWN;
                    int targetFrame = DisassemblyPart.this.fTargetFrame;
                    DisassemblyPart.this.resetViewer();
                    if (DisassemblyPart.this.fScrollPos != null) {
                        ((DisassemblyPart)DisassemblyPart.this).fScrollPos.isDeleted = true;
                    }
                    DisassemblyPart.this.fBPAnnotationUpdatePending = true;
                    DisassemblyPart.this.gotoFrame(targetFrame);
                } else {
                    DisassemblyPart.this.refreshView((int)(refreshViewScheduled - now));
                }
            }
        };
        if (delay > 0) {
            this.invokeLater(delay, new Runnable(){

                @Override
                public void run() {
                    DisassemblyPart.this.doScrollLocked(refresh);
                }
            });
        } else {
            this.doScrollLocked(refresh);
        }
    }

    private void resetViewer() {
        this.fPCAnnotationUpdatePending = false;
        this.fBPAnnotationUpdatePending = false;
        this.fGotoFramePending = false;
        this.fPCAddress = this.fFrameAddress = PC_RUNNING;
        this.fTargetFrame = -1;
        this.fGotoAddressPending = this.fFocusAddress;
        this.fFocusAddress = PC_UNKNOWN;
        this.setFocusPosition(null);
        this.fPCHistory.clear();
        this.fPendingPCUpdates.clear();
        this.fBp2Addr.clear();
        this.fFile2Storage.clear();
        DisassemblyDocument doc = this.fDocument;
        this.fDocument = this.createDocument();
        this.fViewer.setDocument((IDocument)this.fDocument, (IAnnotationModel)new AnnotationModel());
        doc.dispose();
        if (this.fDebugTarget != null) {
            this.fDocument.insertInvalidAddressRange(0, 0, this.fStartAddress, this.fEndAddress);
        }
    }

    private AddressRangePosition getPCPosition(BigInteger address) {
        SourcePosition srcPos;
        int stmtLine;
        SourceFileInfo fi;
        AddressRangePosition pos;
        block16: {
            if (address.compareTo(BigInteger.ZERO) < 0) {
                return null;
            }
            pos = this.getPositionOfAddress(address);
            if (pos == null || !pos.fValid) {
                return null;
            }
            if (pos.length > 0) {
                return pos;
            }
            if (!(pos instanceof DisassemblyPosition)) {
                return pos;
            }
            String srcFile = ((DisassemblyPosition)pos).getFile();
            if (srcFile == null) {
                return pos;
            }
            fi = this.fDocument.getSourceInfo(srcFile);
            if (fi == null) {
                return pos;
            }
            if (fi.fSource == null) {
                if (fi.fError != null) {
                    return pos;
                }
                return null;
            }
            stmtLine = ((DisassemblyPosition)pos).getLine();
            if (stmtLine < 0) {
                return pos;
            }
            BigInteger stmtAddress = fi.fLine2Addr[stmtLine];
            if (stmtAddress.compareTo(BigInteger.ZERO) < 0) {
                return pos;
            }
            srcPos = this.fDocument.getSourcePosition(stmtAddress);
            if (srcPos == null) {
                return pos;
            }
            if (srcPos.fValid) break block16;
            return null;
        }
        try {
            assert (stmtLine >= srcPos.fLine);
            int baseOffset = fi.fSource.getLineOffset(srcPos.fLine);
            IRegion stmtLineRegion = fi.fSource.getLineInformation(stmtLine);
            int lineOffset = stmtLineRegion.getOffset();
            int offset = srcPos.offset + lineOffset - baseOffset;
            int length = stmtLineRegion.getLength() + 1;
            if (offset >= srcPos.offset && offset < srcPos.offset + srcPos.length) {
                return new AddressRangePosition(offset, length, address, BigInteger.ZERO);
            }
        }
        catch (BadLocationException e) {
            DisassemblyPart.internalError(e);
        }
        return pos;
    }

    private AddressRangePosition updateAddressAnnotation(Annotation annotation, BigInteger address) {
        IAnnotationModel annotationModel = this.fViewer.getAnnotationModel();
        annotationModel.removeAnnotation(annotation);
        AddressRangePosition pos = this.getPCPosition(address);
        if (pos != null) {
            annotationModel.addAnnotation(annotation, new Position(pos.offset, Math.max(0, pos.length - 1)));
        }
        return pos;
    }

    public IBreakpoint[] getBreakpointsAtLine(int line) {
        BigInteger startAddress = this.getAddressOfLine(line);
        if (startAddress.compareTo(BigInteger.ZERO) < 0) {
            return null;
        }
        BigInteger endAddress = this.getAddressOfLine(line + 1);
        if (endAddress.compareTo(BigInteger.ZERO) < 0) {
            endAddress = this.fEndAddress;
        } else if (endAddress.compareTo(startAddress) == 0) {
            endAddress = endAddress.add(BigInteger.ONE);
        }
        return this.getBreakpointsInAddressRange(startAddress, endAddress);
    }

    public boolean hasBreakpointInAddressRange(BigInteger startAddress, BigInteger endAddress) {
        return this.getBreakpointsInAddressRange(startAddress, endAddress) != null;
    }

    public IBreakpoint[] getBreakpointsInAddressRange(BigInteger startAddress, BigInteger endAddress) {
        ArrayList bps = new ArrayList();
        if (bps.isEmpty()) {
            return null;
        }
        return bps.toArray(new IBreakpoint[bps.size()]);
    }

    private void updateBPAnnotations() {
        if (this.fUpdatePending) {
            this.fBPAnnotationUpdatePending = true;
            return;
        }
        this.fBPAnnotationUpdatePending = false;
        IAnnotationModel annotationModel = this.fViewer.getAnnotationModel();
        ArrayList<Annotation> toRemove = new ArrayList<Annotation>(10);
        Iterator iter = annotationModel.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof MarkerAnnotation)) continue;
            toRemove.add(annotation);
        }
        IdentityHashMap toAdd = new IdentityHashMap();
        if (annotationModel instanceof IAnnotationModelExtension) {
            Annotation[] toRemoveArray = new Annotation[toRemove.size()];
            toRemove.toArray(toRemoveArray);
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(toRemoveArray, toAdd);
        } else {
            for (Annotation annotation : toRemove) {
                annotationModel.removeAnnotation(annotation);
            }
            for (Map.Entry entry : toAdd.entrySet()) {
                annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
        }
    }

    private void gotoFrame(int frame, BigInteger address) {
        if (DEBUG) {
            System.out.println("gotoFrame " + frame + " " + DisassemblyPart.getAddressText(address));
        }
        this.fTargetFrame = frame;
        this.fFrameAddress = address;
        if (this.fTargetFrame == -1) {
            this.fTargetFrame = this.getActiveStackFrame();
            if (this.fTargetFrame < 0 && this.fTargetContext.isSuspended()) {
                this.fTargetFrame = 0;
            }
            if (this.fTargetFrame == -1) {
                this.fGotoFramePending = false;
                return;
            }
        }
        this.fGotoFramePending = true;
        if (frame == 0) {
            this.fPCAddress = this.fFrameAddress;
        }
        if (this.fFrameAddress.compareTo(PC_UNKNOWN) == 0) {
            if (!this.fUpdatePending) {
                this.fGotoFramePending = false;
                this.retrieveFrameAddress(this.fTargetContext, this.fTargetFrame);
            }
            return;
        }
        AddressRangePosition pcPos = this.updatePCAnnotation();
        if (pcPos == null && this.fFrameAddress.compareTo(BigInteger.ZERO) >= 0 && (pcPos = this.getPCPosition(this.fFrameAddress)) == null) {
            this.gotoAddress(this.fFrameAddress);
            return;
        }
        if (pcPos != null) {
            if (frame == 0) {
                this.addToPCHistory(pcPos);
            }
            this.fGotoFramePending = false;
            if (this.fGotoAddressPending == this.fFrameAddress) {
                this.fGotoAddressPending = PC_UNKNOWN;
            }
            this.gotoPosition(pcPos, false);
            this.updateVisibleArea();
        } else {
            this.fGotoFramePending = false;
            this.fGotoAddressPending = PC_UNKNOWN;
        }
        this.doPendingPCUpdates();
    }

    private void setFocusPosition(Position pcPos) {
        if (this.fFocusPos != null) {
            this.fDocument.removePosition(this.fFocusPos);
            this.fFocusPos = null;
        }
        if (pcPos != null) {
            this.fFocusPos = new Position(pcPos.offset, pcPos.length);
            try {
                this.fDocument.addPosition(this.fFocusPos);
            }
            catch (BadLocationException e) {
                DisassemblyPart.internalError(e);
            }
        } else {
            this.fFocusAddress = PC_UNKNOWN;
        }
    }

    private void doPendingPCUpdates() {
        BigInteger pc;
        if (this.fPendingPCUpdates.isEmpty()) {
            return;
        }
        while ((pc = (BigInteger)this.fPendingPCUpdates.remove(0)).compareTo(BigInteger.ZERO) < 0 && !this.fPendingPCUpdates.isEmpty()) {
        }
        this.gotoFrame(0, pc);
    }

    private void addToPCHistory(AddressRangePosition pcPos) {
        if (DEBUG) {
            System.out.println("addToPCHistory " + DisassemblyPart.getAddressText(pcPos.fAddressOffset));
        }
        if (this.fPCHistorySizeMax <= 1) {
            return;
        }
        AddressRangePosition first = null;
        if (this.fPCHistory.size() > 0) {
            first = (AddressRangePosition)((Object)this.fPCHistory.getFirst());
            if (first.fAddressOffset == pcPos.fAddressOffset) {
                if (first.offset != pcPos.offset || first.length != pcPos.length) {
                    this.fPCHistory.removeFirst();
                    this.fViewer.invalidateTextPresentation(first.offset, first.length);
                } else {
                    return;
                }
            }
        }
        pcPos = new AddressRangePosition(pcPos.offset, pcPos.length, pcPos.fAddressOffset, BigInteger.ZERO);
        this.fPCHistory.addFirst(pcPos);
        try {
            this.fDocument.addPosition(pcPos);
        }
        catch (BadLocationException e) {
            DisassemblyPart.internalError(e);
        }
        if (this.fPCHistory.size() > this.fPCHistorySizeMax) {
            AddressRangePosition last = (AddressRangePosition)((Object)this.fPCHistory.removeLast());
            this.fDocument.removePosition(last);
            this.fViewer.invalidateTextPresentation(last.offset, last.length);
        }
        for (AddressRangePosition pos : this.fPCHistory) {
            this.fViewer.invalidateTextPresentation(pos.offset, pos.length);
        }
    }

    private void updatePC(BigInteger pc) {
        BigInteger last;
        if (!this.fPendingPCUpdates.isEmpty() && (last = (BigInteger)this.fPendingPCUpdates.get(this.fPendingPCUpdates.size() - 1)).compareTo(BigInteger.ZERO) < 0) {
            this.fPendingPCUpdates.remove(this.fPendingPCUpdates.size() - 1);
        }
        this.fPendingPCUpdates.add(pc);
        if (this.fPendingPCUpdates.size() > this.fPCHistorySizeMax) {
            if (!this.fActive) {
                this.fPendingPCUpdates.remove(0);
            }
            this.fGotoFramePending = false;
        }
        if (this.fActive) {
            if (this.fGotoFramePending) {
                if (!this.fUpdatePending) {
                    this.gotoFrame(0, this.fFrameAddress);
                }
            } else {
                this.doPendingPCUpdates();
            }
        }
    }

    private AddressRangePosition updatePCAnnotation() {
        AddressRangePosition pos;
        if (this.fUpdatePending) {
            this.fPCAnnotationUpdatePending = true;
            return null;
        }
        if (this.fTargetFrame == 0) {
            this.updateAddressAnnotation(this.fSecondaryPCAnnotation, PC_UNKNOWN);
            pos = this.updateAddressAnnotation(this.fPCAnnotation, this.fPCAddress);
        } else {
            this.updateAddressAnnotation(this.fPCAnnotation, PC_UNKNOWN);
            pos = this.updateAddressAnnotation(this.fSecondaryPCAnnotation, this.fFrameAddress);
        }
        this.fPCAnnotationUpdatePending = pos == null && this.fFrameAddress.compareTo(BigInteger.ZERO) >= 0;
        return pos;
    }

    private void scheduleDoPending() {
        if (!this.fUpdatePending && !this.fDoPendingPosted) {
            this.fDoPendingPosted = true;
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DisassemblyPart.this.doPending();
                    DisassemblyPart.this.fDoPendingPosted = false;
                }
            });
        }
    }

    private void doPending() {
        boolean sourceValid;
        if (this.fViewer == null || this.fDocument == null) {
            return;
        }
        if (this.fUpdateSourcePending) {
            this.updateInvalidSource();
        }
        if (((sourceValid = this.fDocument.getInvalidSource().isEmpty()) || this.fShowDisassembly) && this.fGotoFramePending) {
            this.gotoFrame(this.fTargetFrame, this.fFrameAddress);
        }
        if (sourceValid) {
            if (this.fGotoAddressPending != PC_UNKNOWN) {
                this.gotoAddress(this.fGotoAddressPending);
            } else if (this.fGotoMarkerPending != null) {
                this.gotoMarker(this.fGotoMarkerPending);
            }
            if (this.fPCAnnotationUpdatePending && !this.fGotoFramePending) {
                this.updatePCAnnotation();
            }
            if (this.fBPAnnotationUpdatePending) {
                this.updateBPAnnotations();
            }
            if (this.fUpdateTitlePending) {
                this.updateTitle();
            }
        }
    }

    private void doScrollLocked(Runnable doit) {
        if (this.fViewer == null || this.fDebugTarget == null) {
            return;
        }
        if (!this.fActive) {
            this.fRefreshViewPending = false;
            this.fRefreshAll = true;
            return;
        }
        if (doit != null) {
            this.fRunnableQueue.add(doit);
        }
        if (this.fUpdatePending) {
            if (this.fRunnableQueue.size() == 1) {
                Runnable doitlater = new Runnable(){

                    @Override
                    public void run() {
                        DisassemblyPart.this.doScrollLocked(null);
                    }
                };
                this.invokeLater(doitlater);
            }
        } else {
            this.fUpdatePending = true;
            this.lockScroller();
            try {
                ArrayList copy = new ArrayList(this.fRunnableQueue);
                this.fRunnableQueue.clear();
                for (Runnable doitnow : copy) {
                    try {
                        doitnow.run();
                    }
                    catch (Exception e) {
                        DisassemblyPart.internalError(e);
                    }
                }
            }
            finally {
                this.fUpdatePending = false;
                this.unlockScroller();
                this.doPending();
                this.updateVisibleArea();
            }
        }
    }

    private void lockScroller() {
        assert (this.fScrollPos == null);
        this.fRedrawControl = this.isOpcodeRulerVisible() ? this.fViewer.getControl() : this.fViewer.getTextWidget();
        this.fRedrawControl.setRedraw(false);
        try {
            int focusLine;
            int focusOffset;
            int topOffset = this.fViewer.getTopIndexStartOffset();
            int topIndex = this.fViewer.getTopIndex();
            int bottomIndex = this.fViewer.getBottomIndex();
            int bottomOffset = this.fViewer.getBottomIndexEndOffset();
            if (this.fFocusPos != null && this.fFocusPos.isDeleted) {
                this.fFocusPos = null;
            }
            if (this.fFocusPos != null && this.fFocusPos.offset >= topOffset && this.fFocusPos.offset <= bottomOffset) {
                focusOffset = this.fFocusPos.offset;
                focusLine = this.fDocument.getLineOfOffset(focusOffset);
            } else {
                focusLine = Math.max(0, (topIndex + bottomIndex) / 2);
                focusOffset = this.fDocument.getLineOffset(focusLine);
                AddressRangePosition pos = this.fDocument.getDisassemblyPosition(focusOffset);
                if (pos != null && !pos.fValid) {
                    focusOffset = pos.offset + pos.length;
                    focusLine = this.fDocument.getLineOfOffset(focusOffset);
                }
            }
            this.fScrollPos = new Position(focusOffset);
            this.fScrollLine = focusLine - topIndex;
            this.fDocument.addPosition(this.fScrollPos);
        }
        catch (BadLocationException e) {
            DisassemblyPart.internalError(e);
        }
    }

    private void unlockScroller() {
        try {
            if (this.fScrollPos == null) {
                return;
            }
            try {
                if (this.fScrollPos.isDeleted) {
                    this.fScrollPos.isDeleted = false;
                    if (this.fScrollPos.offset >= this.fDocument.getLength()) {
                        this.fScrollPos.offset = 0;
                        this.fScrollLine = 0;
                    }
                }
                if (this.fFocusPos != null && (this.fFocusPos.isDeleted || this.fFocusPos.length == 0) && this.fFocusAddress.compareTo(BigInteger.ZERO) >= 0) {
                    this.fGotoAddressPending = this.fFocusAddress;
                    this.setFocusPosition(this.getPositionOfAddress(this.fFocusAddress));
                }
                int topLine = this.fDocument.getLineOfOffset(this.fScrollPos.offset) - this.fScrollLine;
                int lineCount = this.fDocument.getNumberOfLines();
                if (lineCount > 500 * this.fBufferZone) {
                    int startLine = Math.max(0, topLine - 50 * this.fBufferZone);
                    int endLine = Math.min(lineCount - 1, topLine + 50 * this.fBufferZone);
                    this.fDocument.deleteLineRange(endLine, lineCount - 1);
                    this.fDocument.deleteLineRange(0, startLine);
                }
                int lineHeight = this.fViewer.getTextWidget().getLineHeight();
                int topPixel = topLine * lineHeight;
                if (Math.abs(this.fViewer.getTextWidget().getTopPixel() - topPixel) >= lineHeight) {
                    this.fViewer.setTopIndex(topLine);
                }
            }
            catch (BadLocationException e) {
                DisassemblyPart.internalError(e);
            }
        }
        finally {
            if (this.fScrollPos != null && this.fDocument != null) {
                this.fDocument.removePosition(this.fScrollPos);
                this.fScrollPos = null;
            }
            if (this.fViewer != null) {
                this.fRedrawControl.setRedraw(true);
                this.getVerticalRuler().update();
                this.getOverviewRuler().update();
            }
        }
    }

    private void insertSource(SourcePosition pos) {
        if (!this.fShowSource) {
            this.fDocument.insertSource(pos, "", pos.fLine, true);
            return;
        }
        SourceFileInfo fi = pos.fFileInfo;
        BigInteger address = pos.fAddressOffset;
        int lineNr = pos.fLine;
        if (fi.fError == null) {
            if (fi.fValid) {
                Addr2Line a2l = fi.fAddr2Line[Addr2Line.hash(address, fi.fAddr2Line.length)];
                while (a2l != null && !a2l.addr.equals(address)) {
                    a2l = a2l.next;
                }
                if (a2l != null) {
                    String source;
                    int first;
                    int line = first = a2l.first;
                    while (line <= a2l.last) {
                        if (!fi.fLine2Addr[line].equals(address)) {
                            if (line > first) {
                                source = fi.getLines(first, line - 1);
                                pos = this.fDocument.insertSource(pos, source, first, false);
                            }
                            first = line + 1;
                        }
                        ++line;
                    }
                    if (line > first) {
                        source = fi.getLines(first, line - 1);
                        this.fDocument.insertSource(pos, source, first, true);
                        if (source.length() == 0) {
                            this.fDocument.removeSourcePosition(pos);
                        }
                    } else if (first > a2l.first) {
                        this.fDocument.insertSource(pos, "", first, true);
                        this.fDocument.removeSourcePosition(pos);
                    }
                } else {
                    this.fDocument.insertSource(pos, "", lineNr, true);
                    this.fDocument.removeSourcePosition(pos);
                }
            } else if (fi.fLinesNode == null && fi.fSource != null) {
                fi.fError = new Error();
            }
        }
        if (fi.fError != null && !pos.fValid) {
            if (fi.fSource != null) {
                if (fi.fSource != null && lineNr >= 0 && lineNr < fi.fSource.getNumberOfLines()) {
                    String sourceLine;
                    fi.fStartAddress = fi.fStartAddress.min(pos.fAddressOffset);
                    fi.fEndAddress = fi.fEndAddress.max(pos.fAddressOffset.add(pos.fAddressLength));
                    if (fi.fLine2Addr[lineNr] == null || fi.fLine2Addr[lineNr].compareTo(BigInteger.ZERO) < 0) {
                        fi.fLine2Addr[lineNr] = pos.fAddressOffset;
                        sourceLine = fi.getLine(lineNr);
                        this.fDocument.insertSource(pos, sourceLine, lineNr, true);
                    } else if (fi.fLine2Addr[lineNr].compareTo(pos.fAddressOffset) > 0) {
                        SourcePosition oldPos = this.fDocument.getSourcePosition(fi.fLine2Addr[lineNr]);
                        if (oldPos != null) {
                            try {
                                this.fDocument.replace(oldPos, oldPos.length, null);
                            }
                            catch (BadLocationException e) {
                                DisassemblyPart.internalError(e);
                            }
                            this.fDocument.removeSourcePosition(oldPos);
                        }
                        fi.fLine2Addr[lineNr] = pos.fAddressOffset;
                        String sourceLine2 = fi.getLine(lineNr);
                        this.fDocument.insertSource(pos, sourceLine2, lineNr, true);
                    } else if (fi.fLine2Addr[lineNr].equals(pos.fAddressOffset)) {
                        sourceLine = fi.getLine(lineNr);
                        this.fDocument.insertSource(pos, sourceLine, lineNr, true);
                    } else {
                        this.fDocument.insertSource(pos, "", lineNr, true);
                        this.fDocument.removeSourcePosition(pos);
                    }
                }
            } else {
                this.fDocument.insertSource(pos, "", lineNr, true);
                this.fDocument.removeSourcePosition(pos);
            }
        }
    }

    private void updateTitle() {
        if (this.fDebugTarget == null) {
            String descr = DisassemblyPlugin.getResourceString("Disassembly.message.notConnected");
            String title = this.getConfigurationElement().getAttribute("name");
            this.setPartName(title);
            this.setContentDescription(descr);
            this.setTitleToolTip(title);
        } else {
            IDebugTarget target = this.fDebugTarget;
            String descr = null;
            try {
                descr = target.getName();
            }
            catch (DebugException debugException) {}
            if (descr != null) {
                this.setContentDescription(descr);
            } else {
                this.fUpdateTitlePending = true;
            }
            this.setTitleToolTip(descr);
        }
    }

    private boolean isDissemblyMixedModeOn(IDebugTarget target) {
        return true;
    }

    protected abstract void closePart();

    public void applyTextPresentation(TextPresentation textPresentation) {
        Iterator it;
        IRegion coverage = textPresentation.getCoverage();
        int startOffset = coverage.getOffset();
        int length = coverage.getLength();
        int endOffset = startOffset + length;
        try {
            AddressRangePosition pos = this.fDocument.getModelPosition(startOffset);
            assert (pos != null);
            if (pos == null) {
                return;
            }
            it = this.fDocument.getPositionIterator("category_model", pos.offset);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            return;
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        while (it.hasNext()) {
            AddressRangePosition pos = (AddressRangePosition)((Object)it.next());
            if (pos.offset >= endOffset) break;
            if (pos.offset + pos.length <= startOffset || !pos.fValid || pos.length <= 0) continue;
            if (pos instanceof DisassemblyPosition) {
                DisassemblyPosition disPos = (DisassemblyPosition)pos;
                styleRanges.add(new StyleRange(pos.offset, disPos.length, this.fInstructionColor, null, 0));
                continue;
            }
            if (pos instanceof ErrorPosition) {
                styleRanges.add(new StyleRange(pos.offset, pos.length, this.fErrorColor, null, 0));
                continue;
            }
            if (pos instanceof LabelPosition) {
                styleRanges.add(new StyleRange(pos.offset, pos.length, this.fLabelColor, null, 1));
                continue;
            }
            if (!(pos instanceof SourcePosition)) continue;
            SourcePosition srcPos = (SourcePosition)pos;
            TextPresentation presentation = null;
            if (srcPos.fFileInfo.fSource != null) {
                presentation = srcPos.fFileInfo.getPresentation(srcPos.fFileInfo.getRegion(srcPos.fLine, pos.length));
            }
            if (presentation != null) {
                int start = Math.max(startOffset, srcPos.offset);
                int end = Math.min(endOffset, srcPos.offset + srcPos.length);
                int srcOffset = srcPos.fFileInfo.getLineOffset(srcPos.fLine);
                int clipOffset = start - srcPos.offset;
                presentation.setResultWindow((IRegion)new Region(srcOffset + clipOffset, end - start));
                Iterator iter = presentation.getNonDefaultStyleRangeIterator();
                while (iter.hasNext()) {
                    StyleRange styleRange = (StyleRange)iter.next();
                    styleRange.start += srcPos.offset + clipOffset;
                    styleRanges.add(styleRange);
                }
                continue;
            }
            styleRanges.add(new StyleRange(pos.offset, pos.length, this.fSourceColor, null, 0));
        }
        if (styleRanges.size() > 0) {
            Iterator iter = styleRanges.iterator();
            while (iter.hasNext()) {
                textPresentation.addStyleRange((StyleRange)iter.next());
            }
        }
        if (this.fPCHistory.size() > 1) {
            HSL hsv = new HSL(this.fPCAnnotationRGB);
            double luminanceStep = (1.0 - hsv.luminance) / (double)(this.fPCHistorySizeMax + 1);
            hsv.luminance = 1.0 - luminanceStep * (double)(this.fPCHistorySizeMax - this.fPCHistory.size());
            ListIterator listIt = this.fPCHistory.listIterator(this.fPCHistory.size());
            while (listIt.hasPrevious()) {
                AddressRangePosition pcPos = (AddressRangePosition)((Object)listIt.previous());
                hsv.luminance -= luminanceStep;
                if (pcPos.isDeleted) {
                    listIt.remove();
                    continue;
                }
                if (!pcPos.fValid || !pcPos.overlapsWith(startOffset, length)) continue;
                RGB rgb = hsv.toRGB();
                Color pcColor = this.getSharedColors().getColor(rgb);
                Color textColor = null;
                textPresentation.mergeStyleRange(new StyleRange(pcPos.offset, pcPos.length, textColor, pcColor));
            }
        }
    }

    private IBreakpoint insertBreakpoint(int line, boolean hardware, boolean tracepoint, boolean edit) throws CoreException {
        return null;
    }

    private AddressRangePosition insertSource(AddressRangePosition pos, BigInteger address, String file, int lineNr) {
        Object sourceElement = null;
        if (this.fFile2Storage.containsKey(file)) {
            sourceElement = this.fFile2Storage.get(file);
        } else {
            ISourceLocator locator = this.fDebugTarget.getLaunch().getSourceLocator();
            if (locator instanceof ISourceLookupDirector) {
                sourceElement = ((ISourceLookupDirector)locator).getSourceElement((Object)file);
            }
            if (!(sourceElement instanceof IFile) && sourceElement instanceof File) {
                sourceElement = new LocalFileStorage((File)sourceElement);
            }
            if (sourceElement instanceof IStorage) {
                this.fFile2Storage.put(file, sourceElement);
            } else {
                this.fFile2Storage.put(file, null);
                DisassemblyPlugin.logWarning(String.valueOf(DisassemblyPlugin.getResourceString("Disassembly.log.error.locateFile")) + file, null);
            }
        }
        if (sourceElement instanceof IStorage) {
            SourceFileInfo fi = this.fDocument.getSourceInfo((IStorage)sourceElement);
            if (fi == null) {
                IStorage storage = (IStorage)sourceElement;
                Display display = this.getSite().getShell().getDisplay();
                SourceColorerJob done = new SourceColorerJob(display, storage);
                fi = this.fDocument.createSourceInfo(file, storage, done);
                EditionFinderJob editionJob = null;
                if (storage instanceof IFile) {
                    editionJob = new EditionFinderJob((IFile)storage, address);
                    editionJob.setSourceInfo(fi);
                    editionJob.schedule();
                }
                fi.fReadingJob.schedule();
            }
            pos = this.fDocument.insertInvalidSource(pos, address, fi, lineNr);
        }
        return pos;
    }

    private synchronized Object retrieveModuleTimestamp(BigInteger address) {
        return null;
    }

    private void disassemblyModeChanged(boolean isDisassemblyOn) {
        if (this.fShowDisassembly == isDisassemblyOn) {
            return;
        }
        if (this.fShowDisassembly && !this.fSourceOnlyMode) {
            return;
        }
        this.fShowDisassembly = isDisassemblyOn;
        if (!this.fShowDisassembly) {
            this.sourceModeChanged(true);
        }
        this.fActionToggleSource.update();
        Runnable doit = new Runnable(){

            @Override
            public void run() {
                DisassemblyPart.this.fDocument.invalidateDisassemblyWithSource(!DisassemblyPart.this.fShowDisassembly);
                DisassemblyPart.this.fGotoFramePending = true;
                DisassemblyPart.this.fBPAnnotationUpdatePending = true;
            }
        };
        this.doScrollLocked(doit);
    }

    private void sourceModeChanged(boolean isSourceModeOn) {
        if (this.fShowSource == isSourceModeOn) {
            return;
        }
        this.fShowSource = isSourceModeOn;
        this.fActionToggleSource.update();
        this.fDocument.invalidateSource();
        if (!this.fShowSource && !this.fShowDisassembly) {
            this.disassemblyModeChanged(true);
        } else {
            this.fPCAnnotationUpdatePending = true;
            this.fBPAnnotationUpdatePending = true;
            this.updateInvalidSource();
        }
    }

    private static BigInteger decodeAddress(String string) {
        if (string.startsWith("0x")) {
            return new BigInteger(string.substring(2), 16);
        }
        return new BigInteger(string);
    }

    private static String getAddressText(BigInteger address) {
        if (address == null) {
            return "<null>";
        }
        if (address.compareTo(BigInteger.ZERO) < 0) {
            return address.toString();
        }
        String hex = address.toString(16);
        return "0x" + "0000000000000000".substring(hex.length() + (address.bitLength() <= 32 ? 8 : 0)) + hex;
    }

    private static void internalError(Throwable e) {
        if (DEBUG) {
            DisassemblyPlugin.logError("Disassembly: Internal error", e);
        }
    }

    private final class ActionGotoAddress
    extends DisassemblyAction {
        public ActionGotoAddress() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.GotoAddress.label"));
        }

        public void run() {
            IInputValidator validator = new IInputValidator(){

                public String isValid(String input) {
                    if (input == null || input.length() == 0) {
                        return " ";
                    }
                    try {
                        BigInteger address = DisassemblyPart.decodeAddress(input);
                        if (address.compareTo(DisassemblyPart.this.fStartAddress) < 0 || address.compareTo(DisassemblyPart.this.fEndAddress) >= 0) {
                            return DisassemblyPlugin.getResourceString("Disassembly.GotoAddressDialog.error.invalid_address");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        return DisassemblyPlugin.getResourceString("Disassembly.GotoAddressDialog.error.not_a_number");
                    }
                    return null;
                }
            };
            String defaultValue = ((ITextSelection)DisassemblyPart.this.fViewer.getSelection()).getText();
            if (validator.isValid(defaultValue) != null && validator.isValid(defaultValue = DisassemblyPlugin.getDefault().getDialogSettings().get("gotoAddress")) != null) {
                defaultValue = "";
            }
            String dlgTitle = DisassemblyPlugin.getResourceString("Disassembly.GotoAddressDialog.title");
            String dlgLabel = DisassemblyPlugin.getResourceString("Disassembly.GotoAddressDialog.label");
            InputDialog dlg = new InputDialog(DisassemblyPart.this.getSite().getShell(), dlgTitle, dlgLabel, defaultValue, validator);
            if (dlg.open() == 0) {
                String value = dlg.getValue();
                BigInteger address = DisassemblyPart.decodeAddress(value);
                DisassemblyPlugin.getDefault().getDialogSettings().put("gotoAddress", value);
                DisassemblyPart.this.gotoAddress(address);
            }
        }
    }

    private final class ActionGotoPC
    extends DisassemblyAction {
        public ActionGotoPC() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.GotoPC.label"));
            this.setToolTipText(DisassemblyPlugin.getResourceString("Disassembly.action.GotoPC.tooltip"));
        }

        public void run() {
            DisassemblyPart.this.updatePC(DisassemblyPart.this.fPCAddress);
        }
    }

    private final class ActionGotoSymbol
    extends DisassemblyAction {
        public ActionGotoSymbol() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.GotoSymbol.label"));
        }

        public void run() {
            IRegion wordRegion = CWordFinder.findWord((IDocument)DisassemblyPart.this.fDocument, (int)DisassemblyPart.this.fViewer.getSelectedRange().x);
            String defaultValue = null;
            if (wordRegion != null) {
                try {
                    defaultValue = DisassemblyPart.this.fDocument.get(wordRegion.getOffset(), wordRegion.getLength());
                }
                catch (BadLocationException e) {
                    DisassemblyPart.internalError(e);
                }
            }
            if (defaultValue == null && (defaultValue = DisassemblyPlugin.getDefault().getDialogSettings().get("gotoSymbol")) == null) {
                defaultValue = "";
            }
            String dlgTitle = DisassemblyPlugin.getResourceString("Disassembly.GotoSymbolDialog.title");
            String dlgLabel = DisassemblyPlugin.getResourceString("Disassembly.GotoSymbolDialog.label");
            InputDialog dlg = new InputDialog(DisassemblyPart.this.getSite().getShell(), dlgTitle, dlgLabel, defaultValue, null);
            if (dlg.open() == 0) {
                String value = dlg.getValue();
                DisassemblyPlugin.getDefault().getDialogSettings().put("gotoSymbol", value);
                DisassemblyPart.this.gotoSymbol(value);
            }
        }
    }

    private final class ActionOpenPreferences
    extends Action {
        static final String PREF_PAGE_ID = "com.atmel.avr32.debug.ui.disassembly.preferencePage";

        ActionOpenPreferences() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.OpenPreferences.label"));
        }

        public void run() {
            PreferencesUtil.createPreferenceDialogOn((Shell)DisassemblyPart.this.getSite().getShell(), (String)PREF_PAGE_ID, (String[])new String[]{PREF_PAGE_ID}, null).open();
        }
    }

    private final class ActionRefreshView
    extends DisassemblyAction {
        public ActionRefreshView() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.RefreshView.label"));
            this.setImageDescriptor(DisassemblyPlugin.getImageDescriptor(DisassemblyImageRegistry.ICON_Refresh_enabled));
            this.setDisabledImageDescriptor(DisassemblyPlugin.getImageDescriptor(DisassemblyImageRegistry.ICON_Refresh_disabled));
        }

        public void run() {
            DisassemblyPart.this.refreshView(10);
        }
    }

    private final class ActionToggleAddressColumn
    extends DisassemblyAction {
        ActionToggleAddressColumn() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.ShowAddresses.label"));
        }

        public void run() {
            IPreferenceStore store = DisassemblyPlugin.getDefault().getPreferenceStore();
            store.setValue("showAddressRuler", !DisassemblyPart.this.isAddressRulerVisible());
        }

        @Override
        public void update() {
            this.setChecked(DisassemblyPart.this.isAddressRulerVisible());
        }
    }

    private final class ActionToggleBreakpoint
    extends DisassemblyAction {
        private IBreakpoint fBreakpoint;
        private int fLine;

        public ActionToggleBreakpoint() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.AddBreakpoint.label"));
            this.setImageDescriptor(DisassemblyPlugin.getImageDescriptor(DisassemblyImageRegistry.ICON_AddBreakpoint));
        }

        public void run() {
            try {
                if (this.fBreakpoint != null) {
                    this.fBreakpoint.delete();
                } else {
                    DisassemblyPart.this.insertBreakpoint(this.fLine, false, false, false);
                }
            }
            catch (CoreException e) {
                DisassemblyPlugin.getDefault().getLog().log(e.getStatus());
            }
        }

        @Override
        public void update() {
            super.update();
            if (this.isEnabled()) {
                this.fLine = DisassemblyPart.this.fVerticalRuler.getLineOfLastMouseButtonActivity();
                IBreakpoint[] bps = DisassemblyPart.this.getBreakpointsAtLine(this.fLine);
                if (bps == null) {
                    this.fBreakpoint = null;
                    this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.AddBreakpoint.label"));
                } else {
                    this.fBreakpoint = bps[0];
                    this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.RemoveBreakpoint.label"));
                }
            }
        }
    }

    private final class ActionToggleBreakpointEnablement
    extends DisassemblyAction {
        private IBreakpoint fBreakpoint;

        public ActionToggleBreakpointEnablement() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.EnableBreakpoint.label"));
            this.setImageDescriptor(DisassemblyPlugin.getImageDescriptor(DisassemblyImageRegistry.ICON_EnableBreakpoint));
        }

        public void run() {
            try {
                this.fBreakpoint.setEnabled(!this.fBreakpoint.isEnabled());
            }
            catch (CoreException e) {
                DisassemblyPart.internalError(e);
            }
        }

        @Override
        public void update() {
            super.update();
            if (this.isEnabled()) {
                int line = DisassemblyPart.this.fVerticalRuler.getLineOfLastMouseButtonActivity();
                IBreakpoint[] bps = DisassemblyPart.this.getBreakpointsAtLine(line);
                if (bps == null || bps.length == 0) {
                    this.setEnabled(false);
                } else {
                    this.fBreakpoint = bps[0];
                    try {
                        if (this.fBreakpoint.isEnabled()) {
                            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.DisableBreakpoint.label"));
                        } else {
                            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.EnableBreakpoint.label"));
                        }
                    }
                    catch (CoreException coreException) {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    private final class ActionToggleOpcodeColumn
    extends DisassemblyAction {
        ActionToggleOpcodeColumn() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.ShowOpcodes.label"));
        }

        public void run() {
            IPreferenceStore store = DisassemblyPlugin.getDefault().getPreferenceStore();
            store.setValue("showOpcodeRuler", !DisassemblyPart.this.isOpcodeRulerVisible());
        }

        @Override
        public void update() {
            this.setChecked(DisassemblyPart.this.isOpcodeRulerVisible());
        }
    }

    private final class ActionToggleSource
    extends DisassemblyAction {
        public ActionToggleSource() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.ShowSource.label"));
        }

        public void run() {
            IPreferenceStore store = DisassemblyPlugin.getDefault().getPreferenceStore();
            boolean showSourceEnabled = store.getBoolean("showSource");
            if (showSourceEnabled == DisassemblyPart.this.fShowSource) {
                store.setValue("showSource", !DisassemblyPart.this.fShowSource);
            } else {
                DisassemblyPart.this.sourceModeChanged(!DisassemblyPart.this.fShowSource);
            }
        }

        @Override
        public void update() {
            super.update();
            if (this.isEnabled()) {
                this.setEnabled(DisassemblyPart.this.fShowDisassembly);
            }
            this.setChecked(DisassemblyPart.this.fShowSource);
        }
    }

    private final class ActionToggleSymbols
    extends DisassemblyAction {
        public ActionToggleSymbols() {
            this.setText(DisassemblyPlugin.getResourceString("Disassembly.action.ShowSymbols.label"));
        }

        public void run() {
            IPreferenceStore store = DisassemblyPlugin.getDefault().getPreferenceStore();
            store.setValue("showSymbols", !DisassemblyPart.this.fShowSymbols);
        }

        @Override
        public void update() {
            super.update();
            this.setChecked(DisassemblyPart.this.fShowSymbols);
        }
    }

    private abstract class DisassemblyAction
    extends Action
    implements IUpdate {
        private DisassemblyAction() {
        }

        public void update() {
            boolean enabled = DisassemblyPart.this.fDebugTarget != null && DisassemblyPart.this.fTargetContext != null;
            this.setEnabled(enabled);
        }
    }

    public class DisassemblyDebugEventListener
    implements IDebugEventSetListener {
        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                DebugEvent event = events[i];
                Object source = event.getSource();
                if (source == DisassemblyPart.this.fDebugTarget || source == DisassemblyPart.this.fTargetContext) {
                    switch (event.getKind()) {
                        case 1: {
                            DisassemblyPart.this.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DisassemblyPart.this.handleResumed();
                                }
                            });
                            break;
                        }
                        case 2: {
                            DisassemblyPart.this.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DisassemblyPart.this.handleSuspend();
                                }
                            });
                            break;
                        }
                        case 8: {
                            DisassemblyPart.this.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DisassemblyPart.this.setDebugContext(null);
                                }
                            });
                        }
                    }
                }
                ++i;
            }
        }
    }

    private class EditionFinderJob
    extends Job {
        private IFile fFile;
        private BigInteger fAddress;
        private SourceFileInfo fSourceInfo;

        public EditionFinderJob(IFile file, BigInteger address) {
            super(DisassemblyPlugin.getResourceString("EditionFinderJob.name"));
            this.fFile = file;
            this.fAddress = address;
            this.setRule((ISchedulingRule)file);
            this.setSystem(true);
        }

        void setSourceInfo(SourceFileInfo info) {
            this.fSourceInfo = info;
            info.fEditionJob = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            assert (this.fSourceInfo != null);
            monitor.beginTask(DisassemblyPlugin.getResourceString("EditionFinderJob.name"), 2);
            monitor.subTask(DisassemblyPlugin.getResourceString("EditionFinderJob.task.get_timestamp"));
            Object token = DisassemblyPart.this.retrieveModuleTimestamp(this.fAddress);
            if (token != null && !(token instanceof Long) && !monitor.isCanceled()) {
                try {
                    Object object = token;
                    synchronized (object) {
                        token.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    DisassemblyPart.internalError(e);
                }
                token = DisassemblyPart.this.retrieveModuleTimestamp(this.fAddress);
            }
            monitor.worked(1);
            if (token instanceof Long && !monitor.isCanceled()) {
                long moduleTime = (Long)token;
                long buildTime = moduleTime * 1000L;
                if (this.fFile.getLocalTimeStamp() > buildTime) {
                    IFileState[] states;
                    monitor.subTask(DisassemblyPlugin.getResourceString("EditionFinderJob.task.search_history"));
                    try {
                        states = this.fFile.getHistory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException coreException) {
                        states = new IFileState[]{};
                    }
                    int i = 0;
                    while (i < states.length) {
                        IFileState state = states[i];
                        long saveTime = state.getModificationTime();
                        if (saveTime <= buildTime) {
                            this.fSourceInfo.fEdition = state;
                            break;
                        }
                        ++i;
                    }
                }
            }
            this.fSourceInfo.fEditionJob = null;
            monitor.worked(1);
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            DisassemblyPart.this.handlePreferenceStoreChanged(event);
        }
    }

    private class SourceColorerJob
    extends UIJob
    implements Runnable {
        private IStorage fStorage;

        public SourceColorerJob(Display jobDisplay, IStorage storage) {
            super(DisassemblyPlugin.getResourceString("SourceColorerJob.name"));
            this.setDisplay(DisassemblyPart.this.fViewer.getControl().getDisplay());
            this.fStorage = storage;
            this.setSystem(true);
            this.setPriority(10);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (DisassemblyPart.this.fViewer != null && !monitor.isCanceled()) {
                monitor.beginTask(DisassemblyPlugin.getResourceString("SourceColorerJob.name"), -1);
                SourceFileInfo fi = DisassemblyPart.this.fDocument.getSourceInfo(this.fStorage);
                if (fi != null) {
                    fi.initPresentationCreator((ITextViewer)DisassemblyPart.this.fViewer);
                    if (fi.fError != null) {
                        DisassemblyPlugin.logWarning(String.valueOf(DisassemblyPlugin.getResourceString("Disassembly.log.error.readFile")) + fi.fFileKey, fi.fError);
                    }
                }
                DisassemblyPart.this.updateInvalidSource();
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        @Override
        public void run() {
            IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)DisassemblyPart.this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
            if (progressService != null) {
                progressService.schedule((Job)this, 0L, true);
            } else {
                this.schedule();
            }
        }
    }
}

