/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.disassembly.text;

import com.atmel.avr32.debug.ui.disassembly.text.IFileRider;
import java.io.IOException;

public class REDRun
implements CharSequence {
    IFileRider fRider;
    int fOffset;
    int fLength;

    public REDRun(IFileRider rider, int offset, int length) {
        this.fRider = rider;
        this.fOffset = offset;
        this.fLength = length;
    }

    public REDRun(IFileRider rider, String str) throws IOException {
        this.fRider = rider;
        this.fLength = str.length();
        this.fOffset = this.fRider.length();
        this.fRider.seek(this.fOffset);
        this.fRider.writeChars(str, 0, this.fLength);
    }

    public REDRun(IFileRider rider, char[] buf, int off, int n) throws IOException {
        this.fRider = rider;
        this.fLength = n;
        this.fOffset = this.fRider.length();
        this.fRider.seek(this.fOffset);
        this.fRider.writeChars(buf, off, n);
    }

    public String asString() throws IOException {
        char[] buf = new char[this.fLength];
        this.fRider.seek(this.fOffset);
        this.fRider.readChars(buf);
        String retVal = new String(buf);
        return retVal;
    }

    public int copyInto(char[] arr, int from, int arrSize, int myOff) throws IOException {
        this.fRider.seek(this.fOffset + myOff);
        int readAmount = Math.min(arrSize - from, this.fLength - myOff);
        this.fRider.readChars(arr, from, readAmount);
        return readAmount;
    }

    public int appendTo(StringBuffer buffer, int length, int myOff) throws IOException {
        this.fRider.seek(this.fOffset + myOff);
        int readAmount = Math.min(length, this.fLength - myOff);
        this.fRider.readChars(buffer, readAmount);
        return readAmount;
    }

    public boolean isMergeableWith(REDRun r) {
        return r.fRider == this.fRider && r.fOffset == this.fOffset + this.fLength;
    }

    @Override
    public String toString() {
        try {
            return this.asString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public char charAt(int pos) {
        try {
            this.fRider.seek(this.fOffset + pos);
            return this.fRider.readChar();
        }
        catch (IOException iOException) {
            return '\u0000';
        }
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new REDRun(this.fRider, this.fOffset + start, end - start);
    }

    @Override
    public int length() {
        return this.fLength;
    }
}

