/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.disassembly.preferences;

import com.atmel.avr32.debug.ui.disassembly.DisassemblyPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DisassemblyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List fCheckBoxes = new ArrayList();
    private List fComboBoxes = new ArrayList();
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            DisassemblyPreferencePage.this.numberFieldChanged((Text)e.widget);
        }
    };
    private static final String[] fcRadixItems = new String[]{DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.radix.octal"), DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.radix.decimal"), DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.radix.hexadecimal")};
    private static final int[] fcRadixValues = new int[]{8, 10, 16};

    public DisassemblyPreferencePage() {
        this.setPreferenceStore(DisassemblyPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.atmel.avr32.debug.ui.disassembly.disassembly_preference_page");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        String label = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.addressRadix");
        this.addComboBox(composite, label, "addressRadix", fcRadixItems);
        label = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.instructionRadix");
        this.addComboBox(composite, label, "instructionRadix", fcRadixItems);
        label = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.showSource");
        this.addCheckBox(composite, label, "showSource", 0);
        label = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.showSymbols");
        this.addCheckBox(composite, label, "showSymbols", 0);
        label = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.simplifiedMnemonics");
        this.addCheckBox(composite, label, "simplified", 0);
        label = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.showAddressRadix");
        this.addCheckBox(composite, label, "showAddressRadix", 0);
        label = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.showCodeBytes");
        this.addCheckBox(composite, label, "showOpcodeRuler", 0);
        label = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.showAddress");
        this.addCheckBox(composite, label, "showAddressRuler", 0);
        label = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.avoidReadBeforePC");
        this.addCheckBox(composite, label, "avoidReadBeforePC", 0);
        Label separator = new Label(composite, 258);
        GridData data = new GridData(768);
        data.horizontalSpan = layout.numColumns;
        separator.setLayoutData((Object)data);
        label = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.useSourceOnlyMode");
        this.addCheckBox(composite, label, "useSourceOnlyMode", 0);
        String noteTitle = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.useSourceOnlyMode.noteTtitle");
        String noteMessage = DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.useSourceOnlyMode.noteMessage");
        Composite note = this.createNoteComposite(composite.getFont(), composite, noteTitle, noteMessage);
        data = (GridData)note.getLayoutData();
        if (data == null) {
            data = new GridData(256);
            note.setLayoutData((Object)data);
        }
        data.horizontalSpan = layout.numColumns;
        Control msgControl = note.getChildren()[1];
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(65);
        data.heightHint = this.convertHeightInCharsToPixels(3);
        msgControl.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)parent);
        this.initialize();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(768);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.setData((Object)key);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    private Combo addComboBox(Composite parent, String label, String key, String[] items) {
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        labelControl.setLayoutData((Object)gd);
        Combo combo = new Combo(parent, 8);
        gd = new GridData(32);
        combo.setLayoutData((Object)gd);
        combo.setItems(items);
        combo.setData((Object)key);
        this.fComboBoxes.add(combo);
        return combo;
    }

    protected Text addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        return DisassemblyPreferencePage.getTextControl(this.addLabelledTextField(composite, label, key, textLimit, indentation, isNumber));
    }

    private static Text getTextControl(Control[] labelledTextField) {
        return (Text)labelledTextField[1];
    }

    private Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        textControl.setData((Object)key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        for (Button btn : this.fCheckBoxes) {
            store.setValue((String)btn.getData(), btn.getSelection());
        }
        for (Text field : this.fNumberFields) {
            store.setValue((String)field.getData(), Long.decode(field.getText()).longValue());
        }
        for (Combo combo : this.fComboBoxes) {
            store.setValue((String)combo.getData(), fcRadixValues[combo.getSelectionIndex()]);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        for (Button btn : this.fCheckBoxes) {
            btn.setSelection(store.getDefaultBoolean((String)btn.getData()));
        }
        for (Text field : this.fNumberFields) {
            long value = store.getDefaultLong((String)field.getData());
            field.setText("0x" + Long.toHexString(value));
        }
        for (Combo combo : this.fComboBoxes) {
            int value = store.getDefaultInt((String)combo.getData());
            int i = 0;
            while (i < fcRadixValues.length) {
                if (fcRadixValues[i] == value) {
                    combo.select(i);
                }
                ++i;
            }
        }
        super.performDefaults();
    }

    private void initialize() {
        IPreferenceStore store = this.getPreferenceStore();
        for (Button btn : this.fCheckBoxes) {
            btn.setSelection(store.getBoolean((String)btn.getData()));
        }
        for (Text field : this.fNumberFields) {
            long value = store.getLong((String)field.getData());
            field.setText("0x" + Long.toHexString(value));
        }
        block2: for (Combo combo : this.fComboBoxes) {
            int value = store.getInt((String)combo.getData());
            int i = 0;
            while (i < fcRadixValues.length) {
                if (fcRadixValues[i] == value) {
                    combo.select(i);
                    continue block2;
                }
                ++i;
            }
        }
    }

    protected void numberFieldChanged(Text text) {
        try {
            long value = Long.decode(text.getText());
            if (value < 0L) {
                this.setErrorMessage(DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.error.negative_number"));
            } else {
                this.setErrorMessage(null);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(DisassemblyPlugin.getResourceString("DisassemblyPreferencePage.error.not_a_number"));
        }
    }
}

