/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.disassembly.model;

import com.atmel.avr32.debug.ui.disassembly.DisassemblyPlugin;
import com.atmel.avr32.debug.ui.disassembly.model.SourceFileInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class SourceReadingJob
extends Job {
    private static final String NAME = DisassemblyPlugin.getResourceString("SourceReadingJob.name");
    private SourceFileInfo fFileInfo;
    private Runnable fDone;

    public SourceReadingJob(SourceFileInfo fi, Runnable done) {
        super(NAME);
        this.fFileInfo = fi;
        this.fFileInfo.fReadingJob = this;
        this.fDone = done;
        if (fi.fFile instanceof ISchedulingRule) {
            this.setRule((ISchedulingRule)fi.fFile);
        }
        this.setSystem(true);
        this.setPriority(20);
        if (fi.fFile.getFullPath() != null) {
            String fileName = fi.fFile.getFullPath().lastSegment();
            this.setName(String.valueOf(NAME) + " (" + fileName + ')');
        }
    }

    public synchronized void dispose() {
        this.fDone = null;
        Thread thread = this.getThread();
        if (thread != null && thread.isAlive()) {
            thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        block20: {
            if (this.fFileInfo.fEditionJob != null) {
                try {
                    this.fFileInfo.fEditionJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                try {
                    this.fFileInfo.initSource();
                }
                catch (Throwable e) {
                    this.fFileInfo.fError = e;
                    this.fFileInfo.fReadingJob = null;
                    SourceReadingJob sourceReadingJob = this;
                    synchronized (sourceReadingJob) {
                        if (this.fDone != null && !this.getThread().isInterrupted()) {
                            this.fDone.run();
                        }
                        break block20;
                    }
                }
            }
            catch (Throwable throwable) {
                this.fFileInfo.fReadingJob = null;
                SourceReadingJob sourceReadingJob = this;
                synchronized (sourceReadingJob) {
                    if (this.fDone != null && !this.getThread().isInterrupted()) {
                        this.fDone.run();
                    }
                }
                throw throwable;
            }
            this.fFileInfo.fReadingJob = null;
            SourceReadingJob sourceReadingJob = this;
            synchronized (sourceReadingJob) {
                if (this.fDone != null && !this.getThread().isInterrupted()) {
                    this.fDone.run();
                }
            }
        }
        return Status.OK_STATUS;
    }
}

