/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.disassembly.model;

import com.atmel.avr32.debug.ui.disassembly.DisassemblyPlugin;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class DisassemblyIPAnnotation
extends Annotation {
    public static final String ID_TOP = "org.eclipse.cdt.debug.ui.currentDisassemblyIP";
    public static final String ID_SECONDARY = "org.eclipse.cdt.debug.ui.secondaryDisassemblyIP";
    private Image fImage;
    private int fContext = Integer.MIN_VALUE;

    public DisassemblyIPAnnotation(boolean isTopFrame, int context) {
        super(isTopFrame ? ID_TOP : ID_SECONDARY, false, isTopFrame ? DisassemblyPlugin.getResourceString("DisassemblyIPAnnotation.primary") : DisassemblyPlugin.getResourceString("DisassemblyIPAnnotation.secondary"));
        this.setContext(context);
    }

    public boolean isTopFrame() {
        return ID_TOP.equals(this.getType());
    }

    public void setContext(int context) {
        if (context == this.fContext) {
            return;
        }
        this.fContext = context;
    }

    public int getLayer() {
        return 5;
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        Rectangle imageBounds = this.fImage.getBounds();
        gc.drawImage(this.fImage, bounds.x + (bounds.width - imageBounds.width) / 2, bounds.y + (bounds.height - imageBounds.height) / 2);
    }
}

