/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.disassembly;

import com.atmel.avr32.debug.ui.disassembly.DisassemblyPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public abstract class AbstractImageRegistry
extends ImageRegistry {
    private HashMap fPlugins = new HashMap();
    private HashMap fLocations = new HashMap();
    private URL fBaseUrl;

    protected AbstractImageRegistry(Plugin plugin) {
        this.fBaseUrl = plugin.getBundle().getEntry("/");
    }

    protected void localImage(String key, String dir, String name) {
        if (dir == null || dir.equals("")) {
            this.fLocations.put(key, new String[]{"icons/" + name});
        } else {
            this.fLocations.put(key, new String[]{"icons/" + dir + "/" + name});
        }
    }

    protected void externalImage(String key, String plugin, String[] dirs, String name) {
        if (plugin != null) {
            this.fPlugins.put(key, plugin);
        }
        String[] locations = new String[dirs.length];
        int i = 0;
        while (i < dirs.length) {
            String dir = dirs[i];
            locations[i] = dir == null || dir.equals("") ? "icons/" + name : "icons/" + dir + "/" + name;
            ++i;
        }
        this.fLocations.put(key, locations);
    }

    public final Image get(String key) {
        Image i = super.get(key);
        if (i != null) {
            return i;
        }
        ImageDescriptor d = this.createFileImageDescriptor(key);
        if (d != null) {
            this.put(key, d);
            return super.get(key);
        }
        return null;
    }

    public final ImageDescriptor getDescriptor(String key) {
        ImageDescriptor d = super.getDescriptor(key);
        if (d != null) {
            return d;
        }
        d = this.createFileImageDescriptor(key);
        if (d != null) {
            this.put(key, d);
            return d;
        }
        return null;
    }

    private ImageDescriptor createFileImageDescriptor(String key) {
        String[] locations;
        Bundle bundle;
        URL url = this.fBaseUrl;
        String pluginId = (String)this.fPlugins.get(key);
        if (pluginId != null && (bundle = Platform.getBundle((String)pluginId)) != null) {
            url = bundle.getEntry("/");
        }
        if ((locations = (String[])this.fLocations.get(key)) != null) {
            int i = 0;
            while (i < locations.length) {
                String loc = locations[i];
                try {
                    URL full = new URL(url, loc);
                    ImageDescriptor candidate = ImageDescriptor.createFromURL((URL)full);
                    if (candidate != null && candidate.getImageData() != null) {
                        return candidate;
                    }
                }
                catch (MalformedURLException e) {
                    DisassemblyPlugin.logError("Malformed Icon URL", e);
                }
                catch (SWTException sWTException) {}
                ++i;
            }
        }
        return null;
    }
}

