/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.standalone.utils;

import java.io.IOException;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.IGnuToolFactory;
import org.eclipse.cdt.utils.NM;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class AVR32ToolFactory
implements IGnuToolFactory {
    protected ICExtension fExtension;

    public AVR32ToolFactory(ICExtension ext) {
        this.fExtension = ext;
    }

    public Addr2line getAddr2line(IPath path) {
        IPath addr2LinePath = this.getAddr2linePath();
        Addr2line addr2line = null;
        if (addr2LinePath != null && !addr2LinePath.isEmpty()) {
            try {
                addr2line = new Addr2line(addr2LinePath.toOSString(), path.toOSString());
            }
            catch (IOException iOException) {}
        }
        return addr2line;
    }

    public CPPFilt getCPPFilt() {
        IPath cppFiltPath = this.getCPPFiltPath();
        CPPFilt cppfilt = null;
        if (cppFiltPath != null && !cppFiltPath.isEmpty()) {
            try {
                cppfilt = new CPPFilt(cppFiltPath.toOSString());
            }
            catch (IOException iOException) {}
        }
        return cppfilt;
    }

    public Objdump getObjdump(IPath path) {
        IPath objdumpPath = this.getObjdumpPath();
        String objdumpArgs = this.getObjdumpArgs();
        Objdump objdump = null;
        if (objdumpPath != null && !objdumpPath.isEmpty()) {
            try {
                objdump = new Objdump(objdumpPath.toOSString(), objdumpArgs, path.toOSString());
            }
            catch (IOException iOException) {}
        }
        return objdump;
    }

    public NM getNM(IPath path) {
        IPath nmPath = this.getNMPath();
        String nmArgs = this.getNMArgs();
        NM nm = null;
        if (nmPath != null && !nmPath.isEmpty()) {
            try {
                nm = new NM(nmPath.toOSString(), nmArgs, path.toOSString());
            }
            catch (IOException iOException) {}
        }
        return nm;
    }

    protected IPath getAddr2linePath() {
        ICExtensionReference ref = this.fExtension.getExtensionReference();
        String value = ref.getExtensionData("addr2line");
        if (value == null || value.length() == 0) {
            value = "avr32-addr2line";
        }
        return new Path(value);
    }

    protected IPath getObjdumpPath() {
        ICExtensionReference ref = this.fExtension.getExtensionReference();
        String value = ref.getExtensionData("objdump");
        if (value == null || value.length() == 0) {
            value = "avr32-objdump";
        }
        return new Path(value);
    }

    protected String getObjdumpArgs() {
        ICExtensionReference ref = this.fExtension.getExtensionReference();
        String value = ref.getExtensionData("objdumpArgs");
        if (value == null || value.length() == 0) {
            value = "";
        }
        return value;
    }

    protected IPath getCPPFiltPath() {
        ICExtensionReference ref = this.fExtension.getExtensionReference();
        String value = ref.getExtensionData("c++filt");
        if (value == null || value.length() == 0) {
            value = "avr32-c++filt";
        }
        return new Path(value);
    }

    protected IPath getStripPath() {
        ICExtensionReference ref = this.fExtension.getExtensionReference();
        String value = ref.getExtensionData("strip");
        if (value == null || value.length() == 0) {
            value = "avr32-strip";
        }
        return new Path(value);
    }

    protected IPath getNMPath() {
        ICExtensionReference ref = this.fExtension.getExtensionReference();
        String value = ref.getExtensionData("nm");
        if (value == null || value.length() == 0) {
            value = "avr32-nm";
        }
        return new Path(value);
    }

    protected String getNMArgs() {
        ICExtensionReference ref = this.fExtension.getExtensionReference();
        String value = ref.getExtensionData("nmArgs");
        if (value == null || value.length() == 0) {
            value = "";
        }
        return value;
    }
}

