/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.standalone;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;

public class CommandLineGenerator
extends ManagedCommandLineGenerator
implements IManagedCommandLineGenerator {
    private static final String[] MCU_OPTIONS = new String[]{"avr32.c.compiler.option.mcu", "avr32.c.linker.option.mcu", "avr32.cpp.compiler.option.mcu", "avr32.cpp.linker.option.mcu", "avr32.both.asm.option.mcu", "avr32.both.preprocessor.option.mcu"};

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        String[] stringArray = MCU_OPTIONS;
        int n = MCU_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String optionId = stringArray[n2];
            IOption option = tool.getOptionBySuperClassId(optionId);
            if (option != null) {
                try {
                    if (option.getStringValue().equals("")) {
                        option.setValue("-mpart=ap7000");
                    }
                }
                catch (BuildException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        if (inputResources != null && inputResources.length > 0) {
            boolean found = false;
            String[] stringArray2 = inputResources;
            int n3 = inputResources.length;
            n = 0;
            while (n < n3) {
                String string = stringArray2[n];
                if (string.endsWith(".S")) {
                    found = true;
                }
                ++n;
            }
            if (found) {
                commandName = "avr32-gcc";
                String[] newFlags = new String[flags.length + 2];
                System.arraycopy(flags, 0, newFlags, 2, flags.length);
                newFlags[0] = "-x assembler-with-cpp";
                newFlags[1] = "-c";
                flags = newFlags;
            }
        }
        return super.generateCommandLineInfo(tool, commandName, flags, outputFlag, outputPrefix, outputName, inputResources, commandLinePattern);
    }
}

