/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.ui.extras;

import com.atmel.avr32.debug.DebugUtilities;
import com.atmel.avr32.managedbuilder.WindowsBuildPathResolver;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ListingBuilder
extends IncrementalProjectBuilder {
    private String getOutput(IBinary binary) {
        return binary.getResource().getParent().getLocation().addTrailingSeparator().append("output.lss").toOSString();
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            Runtime rt = Runtime.getRuntime();
            ArrayList results = new ArrayList();
            DebugUtilities.findBinaries((IResource)project, results);
            for (IBinary iBinary : results) {
                Process process = null;
                String binaryPath = iBinary.getResource().getLocation().toOSString();
                if (WindowsBuildPathResolver.isWindows()) {
                    String path = WindowsBuildPathResolver.getBinPath();
                    path = "PATH=" + path.replaceAll("/", "\\\\");
                    String cmd = "cmd.exe /C avr32-objdump -h -S \"" + binaryPath + "\" > \"" + this.getOutput(iBinary) + "\"";
                    process = rt.exec(cmd, new String[]{path});
                } else {
                    process = rt.exec("avr32-objdump -h -S \"" + binaryPath + "\" > \"" + this.getOutput(iBinary) + "\"");
                }
                process.waitFor();
                iBinary.getResource().getParent().refreshLocal(2, monitor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new IProject[]{project};
    }
}

