/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.ui.extras;

import java.util.ArrayList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class BuilderExtrasPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.atmel.avr32.managedbuilder.ui.extras";
    private static BuilderExtrasPlugin plugin;
    public static final String BUILDER_ID = "com.atmel.avr32.managedbuilder.ui.extras.ListingBuilder";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void addBuilder(IProject project, String id) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(id)) {
                return;
            }
            ++i;
        }
        ICommand command = desc.newCommand();
        command.setBuilderName(id);
        ICommand[] nc = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, nc, 0, commands.length);
        nc[commands.length] = command;
        desc.setBuildSpec(nc);
        project.setDescription(desc, null);
    }

    public boolean hasBuilder(IProject project, String id) throws CoreException {
        ICommand[] commands;
        IProjectDescription desc = project.getDescription();
        ICommand[] iCommandArray = commands = desc.getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand iCommand = iCommandArray[n2];
            if (iCommand.getBuilderName().equals(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void removeBuilder(IProject project, String id) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        ArrayList<ICommand> newCommands = new ArrayList<ICommand>();
        int i = 0;
        while (i < commands.length) {
            if (!commands[i].getBuilderName().equals(id)) {
                newCommands.add(commands[i]);
            }
            ++i;
        }
        desc.setBuildSpec(newCommands.toArray(new ICommand[newCommands.size()]));
        project.setDescription(desc, null);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static BuilderExtrasPlugin getDefault() {
        return plugin;
    }
}

