/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder.ui.extras;

import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IStartup;

public class AddListingBuilder
implements IStartup {
    public static final String BUILDER_ID = "com.atmel.avr32.managedbuilder.ui.extras.ListingBuilder";

    public void earlyStartup() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (ManagedbuildPlugin.isAVR32Project((IProject)iProject) && !ManagedbuildPlugin.isLinuxProject((IProject)iProject)) {
                try {
                    this.addBuilder(iProject, BUILDER_ID);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void addBuilder(IProject project, String id) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(id)) {
                return;
            }
            ++i;
        }
        ICommand command = desc.newCommand();
        command.setBuilderName(id);
        ICommand[] nc = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, nc, 0, commands.length);
        nc[commands.length] = command;
        desc.setBuildSpec(nc);
        project.setDescription(desc, null);
    }
}

