/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MIProcess;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class MIProcessAdapter
implements MIProcess {
    Process fGDBProcess;
    private static final int ONE_SECOND = 1000;
    private long commandTimeout;

    public MIProcessAdapter(String[] args, IProgressMonitor monitor) throws IOException {
        this(args, 0, monitor);
    }

    public MIProcessAdapter(String[] args, int launchTimeout, IProgressMonitor monitor) throws IOException {
        this.fGDBProcess = this.getGDBProcess(args, launchTimeout, monitor);
        this.commandTimeout = MIPlugin.getCommandTimeout();
    }

    protected Process getGDBProcess(String[] args, int launchTimeout, IProgressMonitor monitor) throws IOException {
        Process pgdb = ProcessFactory.getFactory().exec(args);
        int timepass = 0;
        if (launchTimeout <= 0) {
            launchTimeout = Integer.MAX_VALUE;
        }
        InputStream stream = pgdb.getInputStream();
        timepass = 0;
        while (timepass < launchTimeout) {
            if (stream.available() > 0 || monitor.isCanceled()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            timepass += 1000;
        }
        if (monitor.isCanceled()) {
            pgdb.destroy();
            throw new OperationCanceledException();
        }
        if (timepass > launchTimeout) {
            pgdb.destroy();
            String message = MIPlugin.getResourceString("src.GDBDebugger.Error_launch_timeout");
            throw new IOException(message);
        }
        return pgdb;
    }

    public boolean canInterrupt(MIInferior inferior) {
        return this.fGDBProcess instanceof Spawner;
    }

    public void interrupt(MIInferior inferior) {
        if (this.fGDBProcess instanceof Spawner) {
            if (inferior.isRunning()) {
                Spawner gdbSpawner = (Spawner)this.fGDBProcess;
                gdbSpawner.interrupt();
                this.waitForInterrupt(inferior);
            }
            if (inferior.isRunning() && inferior.getInferiorPID() > 0) {
                this.interruptInferior(inferior);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForInterrupt(MIInferior inferior) {
        MIInferior mIInferior = inferior;
        synchronized (mIInferior) {
            long maxSec = this.commandTimeout / 1000L + 1L;
            int i = 0;
            while (inferior.isRunning() && (long)i < maxSec) {
                try {
                    inferior.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
            return inferior.isRunning();
        }
    }

    protected void interruptInferior(MIInferior inferior) {
        if (this.fGDBProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fGDBProcess;
            gdbSpawner.raise(inferior.getInferiorPID(), gdbSpawner.INT);
            this.waitForInterrupt(inferior);
        }
    }

    public int exitValue() {
        return this.fGDBProcess.exitValue();
    }

    public int waitFor() throws InterruptedException {
        return this.fGDBProcess.waitFor();
    }

    public void destroy() {
        this.fGDBProcess.destroy();
    }

    public InputStream getErrorStream() {
        return this.fGDBProcess.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.fGDBProcess.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.fGDBProcess.getOutputStream();
    }
}

