/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.dnd.NavigatorPluginDropAction;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorDnDService;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.PluginTransfer;

public final class CommonDropAdapter
extends PluginDropAdapter {
    private static final Transfer[] SUPPORTED_DROP_TRANSFERS = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), PluginTransfer.getInstance()};
    private final INavigatorContentService contentService;
    private final INavigatorDnDService dndService;

    public CommonDropAdapter(INavigatorContentService aContentService, StructuredViewer aStructuredViewer) {
        super(aStructuredViewer);
        this.contentService = aContentService;
        this.dndService = this.contentService.getDnDService();
        this.setFeedbackEnabled(false);
    }

    public Transfer[] getSupportedDropTransfers() {
        return SUPPORTED_DROP_TRANSFERS;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 0) {
            return;
        }
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.dragEnter: " + event);
        }
        int i = 0;
        while (i < event.dataTypes.length) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDropAdapter.dragEnter: local selection: " + event.currentDataType);
                }
                super.dragEnter(event);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < event.dataTypes.length) {
            if (FileTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                event.detail = 1;
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDropAdapter.dragEnter: file: " + event.currentDataType);
                }
                super.dragEnter(event);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < event.dataTypes.length) {
            if (PluginTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDropAdapter.dragEnter: plugin: " + event.currentDataType);
                }
                super.dragEnter(event);
                return;
            }
            ++i;
        }
        event.detail = 0;
    }

    public void dragLeave(DropTargetEvent event) {
        super.dragLeave(event);
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            event.data = NavigatorPluginDropAction.createTransferData(this.contentService);
        }
    }

    public boolean performDrop(Object data) {
        DropTargetEvent event = this.getCurrentEvent();
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.drop (begin): " + event);
        }
        Object target = this.getCurrentTarget() != null ? this.getCurrentTarget() : this.getViewer().getInput();
        this.validateDrop(target, this.getCurrentOperation(), event.currentDataType);
        if (PluginTransfer.getInstance().isSupportedType(event.currentDataType)) {
            super.drop(event);
            return true;
        }
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.drop target: " + target + " op: " + this.getCurrentOperation());
        }
        CommonDropAdapterAssistant[] assistants = this.dndService.findCommonDropAdapterAssistants(target, this.getCurrentTransfer());
        IStatus valid = null;
        int i = 0;
        while (i < assistants.length) {
            try {
                assistants[i].setCurrentEvent(event);
                valid = assistants[i].validateDrop(target, this.getCurrentOperation(), this.getCurrentTransfer());
                if (valid != null && valid.isOK()) {
                    if (Policy.DEBUG_DND) {
                        System.out.println("CommonDropAdapter.drop assistant selected: " + assistants[i] + " op: " + event.detail);
                    }
                    assistants[i].handleDrop(this, event, target);
                    return true;
                }
            }
            catch (Throwable t) {
                NavigatorPlugin.logError(0, t.getMessage(), t);
            }
            ++i;
        }
        return false;
    }

    public boolean validateDrop(Object aDropTarget, int theDropOperation, TransferData theTransferData) {
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.validateDrop (begin) operation: " + theDropOperation + " target: " + aDropTarget + " transferType: " + theTransferData.type);
        }
        boolean result = false;
        IStatus valid = null;
        if (super.validateDrop(aDropTarget, theDropOperation, theTransferData)) {
            result = true;
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDropAdapter.validateDrop valid for plugin transfer");
            }
        } else {
            Object target;
            Object object = target = aDropTarget != null ? aDropTarget : this.getViewer().getInput();
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDropAdapter.validateDrop target: " + target);
                System.out.println("CommonDropAdapter.validateDrop local selection: " + LocalSelectionTransfer.getTransfer().getSelection());
            }
            CommonDropAdapterAssistant[] assistants = this.dndService.findCommonDropAdapterAssistants(target, theTransferData);
            int i = 0;
            while (i < assistants.length) {
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDropAdapter.validateDrop checking assistant: \"" + assistants[i]);
                }
                try {
                    assistants[i].setCurrentEvent(this.getCurrentEvent());
                    valid = assistants[i].validateDrop(target, theDropOperation, theTransferData);
                }
                catch (Throwable t) {
                    NavigatorPlugin.logError(0, t.getMessage(), t);
                }
                if (valid != null && valid.isOK()) {
                    result = true;
                    if (!Policy.DEBUG_DND) break;
                    System.out.println("CommonDropAdapter.validateDrop VALID");
                    break;
                }
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDropAdapter.validateDrop NOT valid: " + (valid != null ? String.valueOf(valid.getSeverity()) + ": " + valid.getMessage() : ""));
                }
                ++i;
            }
        }
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.validateDrop (returning " + (valid != null ? String.valueOf(valid.getSeverity()) + ": " + valid.getMessage() : "" + result) + ")");
        }
        this.setScrollExpandEnabled(true);
        return result;
    }

    public Rectangle getBounds(Item item) {
        return super.getBounds(item);
    }

    public int getCurrentLocation() {
        return super.getCurrentLocation();
    }

    public int getCurrentOperation() {
        return super.getCurrentOperation();
    }

    public void overrideOperation(int operation) {
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDropAdapter.overrideOperation: " + operation);
        }
        super.overrideOperation(operation);
    }

    public Object getCurrentTarget() {
        return super.getCurrentTarget();
    }

    public TransferData getCurrentTransfer() {
        return super.getCurrentTransfer();
    }
}

