/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.internal.templates;

import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.sf.core.ui.internal.templates.AVR32CommonProjectWizard;
import com.atmel.avr32.sf.core.ui.internal.templates.AVR32MainWizardPage;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.ui.AVR32PluginImages;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ManagedCProjectWizard
extends AVR32CommonProjectWizard {
    IProject fProject = null;
    String fMCU = null;

    public ManagedCProjectWizard() {
        super("New AVR32 C Project", UIMessages.getString((String)"NewModelProjectWizard.5"));
        this.setDefaultPageImageDescriptor(AVR32PluginImages.WIZBAN_AVR32);
    }

    public String[] getNatures() {
        return new String[]{"com.atmel.avr32.core.nature", "org.eclipse.cdt.core.cnature"};
    }

    protected IProject continueCreation(IProject prj) {
        try {
            CProjectNature.addNature((IProject)prj, (String)"com.atmel.avr32.core.nature", (IProgressMonitor)new NullProgressMonitor());
            if (this.fMainPage instanceof AVR32MainWizardPage) {
                String mcu = ((AVR32MainWizardPage)this.fMainPage).getSelectedMCU();
                ManagedbuildPlugin.setProjectMCU((IProject)prj, (String)mcu);
                this.fMCU = mcu;
                this.fProject = prj;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return prj;
    }

    protected boolean setCreated() throws CoreException {
        IManagedBuildInfo mbi = ManagedBuildManager.getBuildInfo((IResource)this.fProject);
        this.updateConfiguration(mbi.getDefaultConfiguration());
        return super.setCreated();
    }

    private void updateConfiguration(IConfiguration sourceCfg) {
        ITool[] tools;
        ITool[] iToolArray = tools = sourceCfg.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            IOption[] options;
            ITool tool = iToolArray[n2];
            IOption[] iOptionArray = options = tool.getOptions();
            int n3 = options.length;
            int n4 = 0;
            while (n4 < n3) {
                IOption option = iOptionArray[n4];
                if (option.getId().startsWith("avr32") && option.getId().indexOf(".option.mcu") > -1) {
                    try {
                        String partOptions = PartRegistry.getToolchainOption((String)this.fMCU);
                        option.setValue(partOptions);
                    }
                    catch (BuildException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }
}

