/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.internal.framework;

import com.atmel.avr32.sf.core.IFrameworkDataWorkingCopy;
import com.atmel.avr32.sf.core.Messages;
import com.atmel.avr32.sf.core.WizardExecutor;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WizardUIExecutor
extends WizardExecutor {
    public WizardUIExecutor(IConfigurationElement root, IFrameworkDataWorkingCopy data) {
        super(root, data);
    }

    protected boolean canDelete(IResource resource) {
        Question q = new Question(Messages.WizardExecutor_DeleteFileTitle, MessageFormat.format(Messages.WizardExecutor_DeleteFileMessage, resource.getName()));
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)q);
        return q.result != 1;
    }

    protected int canOverwrite(IResource resource) {
        Question q = new Question(Messages.WizardExecutor_OverwriteTitle, MessageFormat.format(Messages.WizardExecutor_OverwriteMessage, resource.getName()));
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)q);
        return q.result;
    }

    private class Question
    implements Runnable {
        String message;
        int result;
        String title;

        public Question(String title, String message) {
            this.title = title;
            this.message = message;
        }

        @Override
        public void run() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (shell == null) {
                shell = new Shell(PlatformUI.getWorkbench().getDisplay());
            }
            MessageDialog dialog = new MessageDialog(shell, this.title, null, this.message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_TO_ALL_LABEL}, 3);
            dialog.setBlockOnOpen(true);
            this.result = dialog.open();
        }
    }
}

