/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.internal.framework;

import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.sf.core.SFCorePlugin;
import com.atmel.avr32.sf.core.ui.internal.framework.Messages;
import com.atmel.avr32.sf.core.ui.internal.framework.WizardAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.osgi.framework.Bundle;

public class WizardMenuCreator
extends CompoundContributionItem {
    private static final String FRAMEWORK = "framework";
    private static final String PARTLIST_COMMENT = "#";
    private static final String PARTS = "partlist";
    private static final String PROJECT_TYPE = "projectType";
    private static final String ID = "id";
    private static final String NAME = "name";

    public WizardMenuCreator() {
    }

    public boolean isDynamic() {
        return true;
    }

    public WizardMenuCreator(String id) {
        super(id);
    }

    public String[] getSupportedParts(IConfigurationElement framework) {
        ArrayList<String> templist = new ArrayList<String>();
        Assert.isNotNull((Object)framework, (String)"The configuration element must not be null");
        String pluginID = framework.getContributor().getName();
        Path path = new Path(framework.getAttribute(PARTS));
        try {
            String line;
            InputStream st = FileLocator.openStream((Bundle)Platform.getBundle((String)pluginID), (IPath)path, (boolean)false);
            BufferedReader br = new BufferedReader(new InputStreamReader(st));
            while ((line = br.readLine()) != null) {
                if (line.startsWith(PARTLIST_COMMENT) || line.length() <= 0) continue;
                templist.add(line.trim());
            }
            br.close();
            st.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collections.sort(templist, Collator.getInstance());
        return templist.toArray(new String[templist.size()]);
    }

    private boolean matchMCU(IConfigurationElement wizard, IProject project) {
        String projectMCU = ManagedbuildPlugin.getProjectMCU((IProject)project);
        String[] list = SFCorePlugin.getDefault().getFramework(wizard.getAttribute(FRAMEWORK)).getSupportedParts();
        if (list.length == 0) {
            return true;
        }
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.equals(projectMCU)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<ActionContributionItem> actions = new ArrayList<ActionContributionItem>();
        IProject project = null;
        IResource resource = DebugUITools.getSelectedResource();
        if (resource != null) {
            project = resource.getProject();
        }
        if (project != null) {
            IConfigurationElement[] wizards;
            String projectType = ManagedBuildManager.getProjectType((String)ManagedbuildPlugin.getProjectTypeId((IProject)project)).getBaseId();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("com.atmel.avr32.sf.core.wizard");
            IConfigurationElement[] iConfigurationElementArray = wizards = extensionPoint.getConfigurationElements();
            int n = wizards.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement wizard = iConfigurationElementArray[n2];
                try {
                    if (wizard.getAttribute(PROJECT_TYPE) != null && wizard.getAttribute(PROJECT_TYPE).equals(projectType) && this.matchMCU(wizard, project)) {
                        WizardAction action = new WizardAction(wizard);
                        action.setText(wizard.getAttribute(NAME));
                        action.setId(wizard.getAttribute(ID));
                        actions.add(new ActionContributionItem((IAction)action));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        if (actions.size() == 0) {
            ActionContributionItem empty = new ActionContributionItem((IAction)new Action(Messages.WizardMenuCreator_Unavailable){

                public boolean isEnabled() {
                    return false;
                }
            });
            actions.add(empty);
        }
        return actions.toArray(new IContributionItem[actions.size()]);
    }
}

