/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.internal.framework;

import com.atmel.avr32.sf.core.IFrameworkConfigurationParser;
import com.atmel.avr32.sf.core.IFrameworkData;
import com.atmel.avr32.sf.core.OperationFilterScanner;
import com.atmel.avr32.sf.core.SFCorePlugin;
import com.atmel.avr32.sf.core.ui.internal.framework.Messages;
import java.text.MessageFormat;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SummaryPage
extends WizardPage
implements IFrameworkConfigurationParser {
    private IFrameworkData data;
    private IConfigurationElement root;
    private OperationFilterScanner scanner;
    private Tree tree;

    public SummaryPage(IFrameworkData data, IConfigurationElement root) {
        super(Messages.SummaryPage_Title);
        this.data = data;
        this.root = root;
        this.setTitle(Messages.SummaryPage_Title);
        this.setDescription(Messages.SummaryPage_Description);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.tree.removeAll();
            String label = null;
            TreeItem parent = null;
            try {
                for (IConfigurationElement element : this.scanner.getFilteredCommands(1)) {
                    IConfigurationElement p = null;
                    IConfigurationElement option = (IConfigurationElement)((IConfigurationElement)element.getParent()).getParent();
                    if (option != null && option.getName().equals("option")) {
                        p = option;
                    } else {
                        option = (IConfigurationElement)element.getParent();
                        if (option != null && option.getName().equals("macro")) {
                            p = option;
                        }
                    }
                    if (p != null) {
                        String nl = p.getAttribute("label");
                        if (nl == null) {
                            throw new CoreException((IStatus)new Status(4, "com.atmel.avr32.sf.core.ui", MessageFormat.format("Macro {0} is missing the label attribute.", p.getAttribute("id"))));
                        }
                        if (nl != null && !nl.equals(label)) {
                            parent = new TreeItem(this.tree, 0);
                            label = nl;
                            parent.setText(label);
                        }
                    }
                    if (parent == null) continue;
                    TreeItem item = new TreeItem(parent, 0);
                    item.setText(SFCorePlugin.describe((IConfigurationElement)element));
                }
            }
            catch (InvalidRegistryObjectException e) {
                this.setErrorMessage(e.getMessage());
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
            }
            catch (BuildException e) {
                this.setErrorMessage(e.getMessage());
            }
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.setControl((Control)container);
        this.tree = new Tree(container, 2048);
        this.tree.setLinesVisible(false);
        this.tree.setHeaderVisible(false);
        this.scanner = new OperationFilterScanner(this.data, this.root);
    }
}

