/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.internal.framework;

import com.atmel.avr32.sf.core.IFrameworkConfigurationParser;
import com.atmel.avr32.sf.core.IFrameworkData;
import com.atmel.avr32.sf.core.ui.SFCoreUIPlugin;
import com.atmel.avr32.sf.core.ui.internal.framework.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class FrameworkWizardPage
extends WizardPage
implements ModifyListener,
SelectionListener,
IFrameworkConfigurationParser {
    private static final String EMPTY_STRING = "";
    IConfigurationElement root;
    private String pageHelpId;
    private IProject project;
    private IFrameworkData data;
    static HashMap<String, Widget> controls;
    private ArrayList<String> invalidOptions;

    public void setVisible(boolean visible) {
        if (visible) {
            this.setPageComplete(this.validateInvalidOptions() && this.validateDependencies());
        }
        super.setVisible(visible);
    }

    public boolean isPageComplete() {
        if (this.project == null) {
            return false;
        }
        return super.isPageComplete();
    }

    private void addDescriptionLabel(Composite parent, IConfigurationElement element) {
        Label link = new Label(parent, 64);
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        link.setLayoutData((Object)gd);
        link.setText(element.getValue());
    }

    private void helpPressed(String context) {
        if (this.getShell() != null) {
            Control c = this.getShell().getDisplay().getFocusControl();
            while (c != null) {
                if (c.isListening(28)) {
                    Event e = new Event();
                    e.text = context;
                    c.notifyListeners(28, e);
                    break;
                }
                c = c.getParent();
            }
        }
    }

    private void addChecklist(Composite parent, IConfigurationElement element) {
        Table table = new Table(parent, 2080);
        if (element.getAttribute("enabled") != null) {
            table.setEnabled(Boolean.parseBoolean(element.getAttribute("enabled")));
        }
        GridData gd = new GridData(4, 4, true, true);
        if (this.populateWidget(parent, (Control)table, element)) {
            gd.horizontalSpan = 1;
            final Link descriptionLabel = new Link(parent, 64);
            descriptionLabel.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(FrameworkWizardPage.this.getControl(), event.text);
                    FrameworkWizardPage.this.helpPressed(event.text);
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(FrameworkWizardPage.this.getControl(), FrameworkWizardPage.this.pageHelpId);
                }
            });
            GridData labelGd = new GridData(4, 4, true, true);
            labelGd.minimumWidth = 200;
            descriptionLabel.setLayoutData((Object)labelGd);
            table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IConfigurationElement c = (IConfigurationElement)((TableItem)e.item).getData("configuration");
                    if (c.getChildren("description").length > 0) {
                        descriptionLabel.setText(c.getChildren("description")[0].getValue());
                    }
                }
            });
        } else {
            gd.horizontalSpan = 2;
        }
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    IConfigurationElement c = (IConfigurationElement)((TableItem)e.item).getData("configuration");
                    FrameworkWizardPage.this.invalidOptions.remove(c.getAttribute("id"));
                    FrameworkWizardPage.this.data.setValue(c.getAttribute("id"), Boolean.toString(((TableItem)e.item).getChecked()));
                    if (c instanceof IConfigurationElement) {
                        FrameworkWizardPage.this.handleUIOperations(c);
                    }
                }
            }
        });
        gd.minimumWidth = 200;
        gd.widthHint = table.computeSize((int)200, (int)-1).x;
        gd.heightHint = 200;
        table.setLayoutData((Object)gd);
    }

    private void setControlValue(Control control, IConfigurationElement element) {
        String value = this.data.getValue(element.getAttribute("id"));
        if (value == null) {
            if (element.getAttribute("default") == null) {
                this.invalidOptions.add(element.getAttribute("id"));
                return;
            }
            value = element.getAttribute("default");
            this.data.setValue(element.getAttribute("id"), value);
        }
        if (control instanceof Button) {
            ((Button)control).setSelection(Boolean.parseBoolean(value));
        }
        if (control instanceof Text) {
            ((Text)control).setText(value);
        }
        if (control instanceof Spinner) {
            try {
                ((Spinner)control).setSelection(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(MessageFormat.format(Messages.FrameworkWizardPage_BadSpinnerDefault, value));
            }
        }
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            int x = 0;
            while (x < combo.getItemCount()) {
                if (combo.getItem(x).equals(value)) {
                    combo.select(x);
                    break;
                }
                ++x;
            }
        }
        if (control instanceof Scale) {
            try {
                ((Scale)control).setSelection(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(MessageFormat.format(Messages.FrameworkWizardPage_BadScaleDefault, value));
            }
        }
    }

    private Control addOption(Composite parent, IConfigurationElement element) {
        Types type = Types.valueOf(element.getAttribute("type"));
        String labelText = element.getAttribute("label");
        String id = element.getAttribute("id");
        GridData fill = new GridData(4, 1, true, false);
        GridData two = new GridData(4, 1, false, false);
        two.horizontalSpan = 2;
        switch (type) {
            case check: {
                Button check = new Button(parent, 32);
                check.setData("id", (Object)id);
                check.setLayoutData((Object)two);
                check.setText(labelText);
                this.populateWidget(parent, (Control)check, element);
                this.setControlValue((Control)check, element);
                check.addSelectionListener((SelectionListener)this);
                return check;
            }
            case text: {
                new Label(parent, 0).setText(labelText);
                Text text = new Text(parent, 2048);
                text.setData("id", (Object)id);
                text.setLayoutData((Object)fill);
                this.populateWidget(parent, (Control)text, element);
                this.setControlValue((Control)text, element);
                text.addModifyListener((ModifyListener)this);
                return text;
            }
            case spinner: {
                new Label(parent, 0).setText(labelText);
                Spinner spinner = new Spinner(parent, 2048);
                spinner.setData("id", (Object)id);
                spinner.setLayoutData((Object)fill);
                this.populateWidget(parent, (Control)spinner, element);
                this.setControlValue((Control)spinner, element);
                spinner.addModifyListener((ModifyListener)this);
                return spinner;
            }
            case combo: {
                new Label(parent, 0).setText(labelText);
                Combo combo = new Combo(parent, 8);
                combo.setData("id", (Object)id);
                combo.setLayoutData((Object)fill);
                this.populateWidget(parent, (Control)combo, element);
                this.setControlValue((Control)combo, element);
                combo.addSelectionListener((SelectionListener)this);
                return combo;
            }
            case scale: {
                new Label(parent, 0).setText(labelText);
                Scale scale = new Scale(parent, 8);
                scale.setData("id", (Object)id);
                scale.setLayoutData((Object)fill);
                this.populateWidget(parent, (Control)scale, element);
                this.setControlValue((Control)scale, element);
                scale.addSelectionListener((SelectionListener)this);
                return scale;
            }
        }
        return null;
    }

    private Control addGroup(Composite parent, IConfigurationElement element) {
        Group group = new Group(parent, 32);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        if (element.getAttribute("label") != null) {
            group.setText(element.getAttribute("label"));
        }
        this.populate((Composite)group, element);
        return group;
    }

    private boolean addChecklistOption(Table table, IConfigurationElement element) {
        TableItem item = new TableItem(table, 32);
        item.setText(element.getAttribute("label"));
        String value = this.data.getValue(element.getAttribute("id"));
        if (value == null) {
            if (element.getAttribute("default") != null) {
                value = element.getAttribute("default");
            } else {
                this.setMessage(MessageFormat.format(Messages.FrameworkWizardPage_MissingValueError, element.getAttribute("label")), 2);
                this.invalidOptions.add(element.getAttribute("id"));
            }
            if (value != null) {
                this.data.setValue(element.getAttribute("id"), value);
            }
        } else {
            item.setChecked(Boolean.valueOf(value).booleanValue());
        }
        item.setData("id", (Object)element.getAttribute("id"));
        item.setData("configuration", (Object)element);
        controls.put(element.getAttribute("id"), (Widget)item);
        if (element.getAttribute("enabled") != null) {
            item.setGrayed(Boolean.parseBoolean(element.getAttribute("enabled")));
        }
        return element.getChildren("description").length > 0;
    }

    private void addComboOptions(Combo combo, IConfigurationElement element) {
        IConfigurationElement[] enums;
        IConfigurationElement[] iConfigurationElementArray = enums = element.getChildren("enum");
        int n = enums.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (e.getAttribute("value") != null) {
                combo.add(e.getAttribute("value"));
            }
            ++n2;
        }
    }

    protected FrameworkWizardPage(IProject project, IFrameworkData data, IConfigurationElement root) {
        super(root.getAttribute("title"));
        this.root = root;
        this.project = project;
        this.data = data;
        this.setTitle(root.getAttribute("title"));
        this.setDescription(root.getAttribute("description"));
        this.invalidOptions = new ArrayList();
        if (controls == null) {
            controls = new HashMap();
        }
        if (project == null) {
            this.setErrorMessage(Messages.FrameworkWizardPage_NoProject);
        }
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        control.setLayout((Layout)layout);
        this.populate(control, this.root);
        control.pack(true);
        this.setControl((Control)control);
        this.pageHelpId = this.root.getAttribute("helpId");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, this.pageHelpId);
    }

    private void populate(Composite control, IConfigurationElement element) {
        IConfigurationElement[] children;
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            Elements e = Elements.valueOf(child.getName());
            Control c = null;
            switch (e) {
                case description: {
                    this.addDescriptionLabel(control, child);
                    break;
                }
                case checklist: {
                    this.addChecklist(control, child);
                    break;
                }
                case group: {
                    c = this.addGroup(control, child);
                    break;
                }
                case option: {
                    c = this.addOption(control, child);
                    break;
                }
            }
            if (c != null) {
                controls.put(child.getAttribute("id"), (Widget)c);
                c.setData("id", (Object)child.getAttribute("id"));
                c.setData("configuration", (Object)child);
                if (child.getAttribute("enabled") != null) {
                    c.setEnabled(Boolean.parseBoolean(child.getAttribute("enabled")));
                }
            }
            ++n2;
        }
    }

    private boolean validateInvalidOptions() {
        if (this.invalidOptions.size() > 0) {
            if (this.getMessageType() != 3) {
                this.setMessage(MessageFormat.format(Messages.FrameworkWizardPage_MissingValueError, this.getOptionLabel(this.invalidOptions.get(0))), 2);
            }
            return false;
        }
        this.setMessage(null);
        return true;
    }

    private boolean populateWidget(Composite composite, Control control, IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren();
        int descriptions = 0;
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            Elements e = Elements.valueOf(child.getName());
            switch (e) {
                case description: {
                    this.addDescriptionLabel(composite, child);
                    ++descriptions;
                    break;
                }
                case option: {
                    if (!(control instanceof Table) || !this.addChecklistOption((Table)control, child)) break;
                    ++descriptions;
                    break;
                }
                case enumeration: {
                    if (!(control instanceof Combo)) break;
                    this.addComboOptions((Combo)control, child);
                    break;
                }
            }
            ++n2;
        }
        return descriptions > 0;
    }

    public void modifyText(ModifyEvent e) {
        Object element;
        String id = (String)e.widget.getData("id");
        this.invalidOptions.remove(id);
        if (e.widget instanceof Text) {
            this.data.setValue(id, ((Text)e.widget).getText());
        }
        if ((element = e.widget.getData("configuration")) instanceof IConfigurationElement) {
            this.handleUIOperations((IConfigurationElement)element);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void handleOperation(IConfigurationElement element) {
        IConfigurationElement[] children;
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String name = child.getName();
            if (name.equals("value") || name.equals("enable")) {
                String id = child.getAttribute("id");
                Assert.isNotNull((Object)id, (String)("The \"" + name + "\" operation must specify an id attribute."));
                Widget c = controls.get(id);
                Assert.isNotNull((Object)c, (String)("The identifier \"" + id + "\" does not map to a control"));
                if (child.getName().equals("enable")) {
                    if (c instanceof Control) {
                        ((Control)c).setEnabled(Boolean.parseBoolean(child.getAttribute("value")));
                    }
                    if (c instanceof TableItem) {
                        ((TableItem)c).setGrayed(Boolean.parseBoolean(child.getAttribute("value")));
                    }
                }
                if (name.equals("value")) {
                    String value = child.getAttribute("value");
                    if (c instanceof Text) {
                        if (value == null || value.length() == 0) {
                            ((Text)c).setText(EMPTY_STRING);
                            this.invalidOptions.add(id);
                        } else {
                            ((Text)c).setText(value);
                        }
                    }
                    if (c instanceof Button && value != null && value.length() > 0) {
                        ((Button)c).setSelection(Boolean.parseBoolean(value));
                    }
                    if (c instanceof TableItem && value != null && value.length() > 0) {
                        ((TableItem)c).setChecked(Boolean.parseBoolean(value));
                    }
                    this.data.setValue(id, value);
                    this.invalidOptions.remove(id);
                }
            }
            ++n2;
        }
    }

    private void handleUIOperations(IConfigurationElement element) {
        IConfigurationElement[] children;
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            if (child.getName().equals("operation")) {
                String key = element.getAttribute("id");
                String value = this.data.getValue(key);
                if (child.getAttribute("value") == null || value.equals(child.getAttribute("value"))) {
                    this.handleOperation(child);
                }
            }
            ++n2;
        }
        this.setPageComplete(this.validateInvalidOptions() && this.validateDependencies());
    }

    public void widgetSelected(SelectionEvent e) {
        Object element;
        String id = (String)e.widget.getData("id");
        this.invalidOptions.remove(id);
        if (e.widget instanceof Combo) {
            this.data.setValue(id, ((Combo)e.widget).getText());
        }
        if (e.widget instanceof Scale) {
            this.data.setValue(id, Integer.toString(((Scale)e.widget).getSelection()));
        }
        if (e.widget instanceof Spinner) {
            this.data.setValue(id, Integer.toString(((Spinner)e.widget).getSelection()));
        }
        if (e.widget instanceof Button) {
            this.data.setValue(id, Boolean.toString(((Button)e.widget).getSelection()));
        }
        if ((element = e.widget.getData("configuration")) instanceof IConfigurationElement) {
            this.handleUIOperations((IConfigurationElement)element);
        }
    }

    private boolean validateDependencies() {
        IStatus status = SFCoreUIPlugin.validateDependencies(this.data);
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean canFlipToNextPage() {
        return this.getNextPage() != null;
    }

    private String getOptionLabel(String id) {
        for (IConfigurationElement option : SFCoreUIPlugin.getAllOptions()) {
            if (!option.getAttribute("id").equals(id)) continue;
            return option.getAttribute("label");
        }
        return null;
    }

    private static enum Elements {
        description,
        checklist,
        group,
        option,
        enumeration,
        operation;

    }

    private static enum Types {
        text,
        spinner,
        check,
        combo,
        scale;

    }
}

