/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.internal.framework;

import com.atmel.avr32.debug.ui.AVR32DebugUIPlugin;
import com.atmel.avr32.sf.core.IFrameworkData;
import com.atmel.avr32.sf.core.IFrameworkDataWorkingCopy;
import com.atmel.avr32.sf.core.SFCorePlugin;
import com.atmel.avr32.sf.core.ui.SFCoreUIPlugin;
import com.atmel.avr32.sf.core.ui.internal.framework.FrameworkWizardPage;
import com.atmel.avr32.sf.core.ui.internal.framework.Messages;
import com.atmel.avr32.sf.core.ui.internal.framework.SummaryPage;
import com.atmel.avr32.sf.core.ui.internal.framework.WizardUIExecutor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class FrameworkWizard
extends Wizard {
    private static final String WIZARD_BANNER = "icons/wizban/wizard-banner.gif";
    private static final String TITLE = "title";
    private static final String BANNER = "banner";
    private static final String PAGE = "page";
    private IConfigurationElement extensionRoot;
    private ArrayList<FrameworkWizardPage> pages;
    private IFrameworkDataWorkingCopy data;
    private IProject project;

    public FrameworkWizard(IConfigurationElement extension) {
        ImageDescriptor image;
        this.extensionRoot = extension;
        this.setNeedsProgressMonitor(true);
        if (extension.getAttribute(BANNER) != null) {
            image = SFCoreUIPlugin.imageDescriptorFromPlugin((String)extension.getDeclaringExtension().getContributor().getName(), (String)extension.getAttribute(BANNER));
            this.setDefaultPageImageDescriptor(image);
        } else {
            image = SFCoreUIPlugin.imageDescriptorFromPlugin((String)"com.atmel.avr32.sf.core.ui", (String)WIZARD_BANNER);
            this.setDefaultPageImageDescriptor(image);
        }
        IResource resource = DebugUITools.getSelectedResource();
        if (resource != null) {
            this.project = resource.getProject();
        }
        if (this.project != null) {
            this.setWindowTitle(MessageFormat.format(Messages.FrameworkWizard_WindowTitle, extension.getAttribute(TITLE), this.project.getName()));
            this.data = SFCorePlugin.getDataWorkingCopy((IProject)this.project);
        }
    }

    public void addPages() {
        IConfigurationElement[] pageDeclarations;
        this.pages = new ArrayList();
        IConfigurationElement[] iConfigurationElementArray = pageDeclarations = this.extensionRoot.getChildren(PAGE);
        int n = pageDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            FrameworkWizardPage page = new FrameworkWizardPage(this.project, (IFrameworkData)this.data, configurationElement);
            this.pages.add(page);
            this.addPage((IWizardPage)page);
            ++n2;
        }
        this.addPage((IWizardPage)new SummaryPage((IFrameworkData)this.data, this.extensionRoot));
    }

    private boolean invokeRunnable(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    private IRunnableWithProgress getRunnable() {
        return new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                WizardUIExecutor we = new WizardUIExecutor(FrameworkWizard.this.extensionRoot, FrameworkWizard.this.data);
                IStatus status = we.execute(monitor);
                if (!status.isOK()) {
                    AVR32DebugUIPlugin.messageDialog((IStatus)status);
                }
            }
        });
    }

    public boolean performFinish() {
        return this.invokeRunnable(this.getRunnable());
    }
}

