/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.internal.examples;

import com.atmel.avr32.sf.core.ui.Messages;
import com.atmel.avr32.sf.core.ui.SFCoreUIPlugin;
import com.atmel.avr32.sf.core.ui.internal.examples.EntryPage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.osgi.framework.Bundle;

public class ExamplesWizard
extends Wizard
implements INewWizard {
    private static final String ATTR_NAME = "name";
    private EntryPage wizardPage;
    private WizardNewProjectCreationPage resourcePage;
    private static final String OPEN = "open";
    IProject project;
    IPath location;
    String name;

    public ExamplesWizard() {
        IDialogSettings favoriteSettings;
        if (this.getDialogSettings() == null) {
            this.setDialogSettings((IDialogSettings)new DialogSettings("com.atmel.avr32.sf.core.ui"));
        }
        if ((favoriteSettings = this.getDialogSettings().getSection("SelectionPage")) == null) {
            favoriteSettings = this.getDialogSettings().addNewSection("SelectionPage");
        }
        this.setDialogSettings(favoriteSettings);
    }

    WizardNewProjectCreationPage getResourcePage() {
        return this.resourcePage;
    }

    private void openReadMe(Bundle bundle, IConfigurationElement element) throws PartInitException, MalformedURLException {
        if (element.getAttribute(OPEN) != null) {
            try {
                File f = File.createTempFile("readme", ".html");
                InputStream is = FileLocator.openStream((Bundle)bundle, (IPath)new Path(element.getAttribute(OPEN)), (boolean)false);
                FileOutputStream fw = new FileOutputStream(f);
                int data = -1;
                while ((data = is.read()) != -1) {
                    fw.write(data);
                }
                is.close();
                fw.close();
                int flags = PlatformUI.getWorkbench().getBrowserSupport().isInternalWebBrowserAvailable() ? 32 : 128;
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser(flags, "com.atmel.avr32.sf.core.ui", this.project.getName(), this.project.getName()).openURL(new URL("file://" + f.getAbsolutePath()));
                f.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private IProject createProject(IProgressMonitor monitor) throws CoreException {
        if (this.location != null && Platform.getLocation().equals((Object)this.location)) {
            this.location = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(this.name);
        description.setLocation(this.location);
        this.project.create(description, (IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
        return this.project;
    }

    private IRunnableWithProgress getRunnable() {
        return new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IConfigurationElement element = ExamplesWizard.this.wizardPage.getWizardDeclaration();
                Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
                try {
                    try {
                        ExamplesWizard.this.createProject(monitor);
                        SFCoreUIPlugin.getDefault().installExampleProject(element, ExamplesWizard.this.project, monitor);
                        ExamplesWizard.this.openReadMe(bundle, element);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    public void addPages() {
        this.wizardPage = new EntryPage(this, "wizardSelectionPage");
        this.addPage((IWizardPage)this.wizardPage);
        this.resourcePage = new WizardNewProjectCreationPage("project");
        this.addPage((IWizardPage)this.resourcePage);
        this.resourcePage.setTitle("Create example project");
        this.resourcePage.setDescription("A name must be specified for the project");
        ImageDescriptor image = SFCoreUIPlugin.imageDescriptorFromPlugin((String)"com.atmel.avr32.sf.core.ui", (String)"icons/wizban/framework-wizard.png");
        this.setDefaultPageImageDescriptor(image);
    }

    protected IPath getLocationPath() throws UnsupportedOperationException {
        if (this.resourcePage == null) {
            throw new UnsupportedOperationException();
        }
        return this.resourcePage.getLocationPath();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(Messages.ExampleWizard_WindowTitle);
    }

    public boolean performFinish() {
        try {
            if (this.resourcePage.getProjectName().length() == 0) {
                this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
                this.location = this.project.getLocation();
                this.name = this.project.getName();
            } else {
                this.location = this.resourcePage.getLocationPath();
                this.project = this.resourcePage.getProjectHandle();
                this.name = this.resourcePage.getProjectName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IConfigurationElement element = this.wizardPage.getWizardDeclaration();
        if (element == null) {
            return false;
        }
        return this.invokeRunnable(this.getRunnable());
    }

    private String getProjectName() {
        String name = this.wizardPage.getWizardDeclaration().getAttribute(ATTR_NAME).trim();
        return name;
    }

    private boolean invokeRunnable(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean canFinish() {
        return this.wizardPage.getWizardDeclaration() != null;
    }
}

