/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.internal.examples;

import com.atmel.avr32.sf.core.ui.internal.examples.ExamplesWizard;
import com.atmel.avr32.target.PartRegistry;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

class EntryPage
extends WizardPage {
    private static final String ATTR_DEVICE = "device";
    private static final String ATTR_NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String HELP_ID = "helpId";
    boolean hasPages = true;
    ExamplesWizard hostWizard;
    String searchString = "";
    private Text text;
    IConfigurationElement wizard;

    protected EntryPage(ExamplesWizard examplesWizard, String pageName) {
        super(pageName);
        this.hostWizard = examplesWizard;
        this.setTitle("Select an example");
    }

    public void createControl(Composite parent) {
        this.setDescription("Select an example project from the list.");
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(c, 0);
        l.setText("Search:");
        this.text = new Text(c, 18820);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text.setText("");
        this.text.setFocus();
        final TreeViewer tv = new TreeViewer(c, 2048);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        tv.getControl().setLayoutData((Object)gd);
        tv.setContentProvider((IContentProvider)new ContentProvider());
        tv.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        tv.setInput((Object)"");
        tv.addFilter((ViewerFilter)new Filter());
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (o instanceof IConfigurationElement) {
                        EntryPage.this.wizard = (IConfigurationElement)o;
                        EntryPage.this.setDescription(EntryPage.this.wizard.getAttribute(EntryPage.DESCRIPTION));
                        if (EntryPage.this.wizard.getAttribute(EntryPage.HELP_ID) != null) {
                            PlatformUI.getWorkbench().getHelpSystem().setHelp(EntryPage.this.getControl(), EntryPage.this.wizard.getAttribute(EntryPage.HELP_ID));
                        } else {
                            PlatformUI.getWorkbench().getHelpSystem().setHelp(EntryPage.this.getControl(), null);
                        }
                        EntryPage.this.setPageComplete(true);
                        EntryPage.this.hostWizard.getResourcePage().setInitialProjectName(EntryPage.this.wizard.getAttribute(EntryPage.ATTR_NAME));
                    } else {
                        EntryPage.this.wizard = null;
                        EntryPage.this.setPageComplete(false);
                    }
                }
            }
        });
        tv.getControl().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntryPage.this.searchString = EntryPage.this.text.getText().toLowerCase();
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        tv.refresh();
                        tv.expandAll();
                    }
                });
            }
        });
        this.setControl((Control)c);
    }

    private IConfigurationElement[] getWizard(String device) {
        IConfigurationElement[] wizards;
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.atmel.avr32.sf.core.ui.exampleProject");
        IConfigurationElement[] iConfigurationElementArray = wizards = extensionPoint.getConfigurationElements();
        int n = wizards.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement wizard = iConfigurationElementArray[n2];
            String d = wizard.getAttribute(ATTR_DEVICE);
            if (d != null && d.equals(device)) {
                list.add(wizard);
            }
            ++n2;
        }
        return list.toArray(new IConfigurationElement[list.size()]);
    }

    public IConfigurationElement getWizardDeclaration() {
        return this.wizard;
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return EntryPage.this.getWizard((String)parentElement);
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<String> devices = new ArrayList<String>();
            for (String string : PartRegistry.getPartNames()) {
                if (!this.hasChildren(string)) continue;
                devices.add(string);
            }
            return devices.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof String) {
                return EntryPage.this.getWizard((String)element).length > 0;
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class Filter
    extends ViewerFilter {
        private static final String ATTR_DEVICE = "device";

        Filter() {
        }

        private boolean matches(String device, String title) {
            IConfigurationElement[] wizards;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("com.atmel.avr32.sf.core.ui.exampleProject");
            IConfigurationElement[] iConfigurationElementArray = wizards = extensionPoint.getConfigurationElements();
            int n = wizards.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement wizard = iConfigurationElementArray[n2];
                String d = wizard.getAttribute("device");
                if (d != null && d.equals(device) && wizard.getAttribute(EntryPage.ATTR_NAME).toLowerCase().contains(title)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (EntryPage.this.searchString == null || EntryPage.this.searchString.length() == 0) {
                return true;
            }
            if (element instanceof IConfigurationElement) {
                return ((IConfigurationElement)element).getAttribute(EntryPage.ATTR_NAME).toLowerCase().contains(EntryPage.this.searchString);
            }
            return this.matches((String)element, EntryPage.this.searchString);
        }
    }

    class LabelProvider
    extends StyledCellLabelProvider {
        private final StyledString.Styler STYLER = StyledString.createColorRegistryStyler((String)"ERROR_COLOR", null);

        LabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object obj = cell.getElement();
            String label = "";
            label = obj instanceof IConfigurationElement ? ((IConfigurationElement)obj).getAttribute(EntryPage.ATTR_NAME) : obj.toString();
            StyledString styledString = new StyledString();
            if (EntryPage.this.searchString != null && EntryPage.this.searchString.length() > 0 && label.toLowerCase().indexOf(EntryPage.this.searchString) > -1) {
                int p = label.toLowerCase().indexOf(EntryPage.this.searchString);
                styledString.append(label.substring(0, p));
                styledString.append(label.substring(p, p + EntryPage.this.searchString.length()), this.STYLER);
                styledString.append(label.substring(p + EntryPage.this.searchString.length()));
            } else {
                styledString.append(label);
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            super.update(cell);
        }
    }
}

