/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.internal.decorators;

import com.atmel.avr32.sf.core.IFrameworkData;
import com.atmel.avr32.sf.core.IFrameworkDataChangedListener;
import com.atmel.avr32.sf.core.SFCorePlugin;
import com.atmel.avr32.sf.core.ui.SFCoreUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class FrameworkFile
implements ILightweightLabelDecorator,
IFrameworkDataChangedListener {
    public static final String TOP_RIGHT = "TOP_RIGHT";
    public static final String TOP_LEFT = "TOP_LEFT";
    public static final String BOTTOM_RIGHT = "BOTTOM_RIGHT";
    public static final String BOTTOM_LEFT = "BOTTOM_LEFT";
    public static final String UNDERLAY = "UNDERLAY";
    private String iconPath = "icons/ovr16/sf.gif";
    private String modifiedIconPath = "icons/ovr16/sf-modified.gif";
    private ImageDescriptor descriptor;
    private ImageDescriptor descriptorModified;
    private ListenerList fListeners;

    public void decorate(Object element, IDecoration decoration) {
        IResource resource = (IResource)element;
        if (!(resource instanceof IFile)) {
            return;
        }
        IFrameworkData data = SFCorePlugin.getData((IProject)resource.getProject());
        if (data != null && data.isFrameworkFile(resource)) {
            if (data.getFileDescriptor(resource).isChanged()) {
                if (this.descriptorModified == null) {
                    this.descriptorModified = SFCoreUIPlugin.imageDescriptorFromPlugin((String)"com.atmel.avr32.sf.core.ui", (String)this.modifiedIconPath);
                }
                decoration.addOverlay(this.descriptorModified, 0);
            } else {
                if (this.descriptor == null) {
                    this.descriptor = SFCoreUIPlugin.imageDescriptorFromPlugin((String)"com.atmel.avr32.sf.core.ui", (String)this.iconPath);
                }
                decoration.addOverlay(this.descriptor, 0);
            }
        }
    }

    public FrameworkFile() {
        SFCorePlugin.getDefault().addListener((IFrameworkDataChangedListener)this);
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    public void frameworkDataChanged(IResource resource) {
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)resource);
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
            ++i;
        }
    }
}

