/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.internal.compare;

import com.atmel.avr32.sf.core.IFrameworkData;
import com.atmel.avr32.sf.core.IFrameworkFileDescriptor;
import com.atmel.avr32.sf.core.SFCorePlugin;
import com.atmel.avr32.sf.core.SoftwareFramework;
import com.atmel.avr32.sf.core.ui.internal.compare.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class CompareEditorInput
extends org.eclipse.compare.CompareEditorInput {
    private Object fRoot;
    private IResource fResource;
    private IStructureComparator fLeft;
    private IStructureComparator fRight;
    private DiffTreeViewer fDiffViewer;

    public CompareEditorInput(CompareConfiguration configuration) {
        super(configuration);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Differencer d = new Differencer(){

            protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                return new MyDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
            }
        };
        this.fRoot = d.findDifferences(false, monitor, null, null, (Object)this.fLeft, (Object)this.fRight);
        monitor.done();
        return this.fRoot;
    }

    boolean setSelection(ISelection s) {
        this.fResource = DebugUITools.getSelectedResource();
        this.fLeft = new ResourceNode(this.fResource);
        this.fRight = new FrameworkFileNode(this.fResource);
        return true;
    }

    public boolean isEnabled(ISelection s) {
        IResource resource = DebugUITools.getSelectedResource();
        if (resource == null || !(resource instanceof IFile)) {
            return false;
        }
        return SFCorePlugin.getData((IProject)resource.getProject()).isFrameworkFile(resource);
    }

    private String getReferenceImplementationString(IResource resource) {
        IFrameworkFileDescriptor fd;
        StringBuilder sb = new StringBuilder();
        IFrameworkData data = SFCorePlugin.getData((IProject)resource.getProject());
        if (data != null && (fd = data.getFileDescriptor(resource)) != null) {
            SoftwareFramework sf = SFCorePlugin.getDefault().getFramework(fd.getFrameworkId());
            sb.append(MessageFormat.format(Messages.CompareEditorInput_ReferenceLabel, sf.getName(), sf.getVersion()));
        }
        return sb.toString();
    }

    private String getWorkspaceFileLabel(IResource resource) {
        IFrameworkFileDescriptor fd;
        StringBuilder sb = new StringBuilder();
        IFrameworkData data = SFCorePlugin.getData((IProject)resource.getProject());
        if (data != null && (fd = data.getFileDescriptor(resource)) != null) {
            SoftwareFramework sf = SFCorePlugin.getDefault().getFramework(fd.getFrameworkId());
            sb.append(MessageFormat.format(Messages.CompareEditorInput_WorkspaceLabel, sf.getName(), fd.getVersion()));
        }
        return sb.toString();
    }

    void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (this.fResource != null) {
            cc.setLeftLabel(this.getWorkspaceFileLabel(this.fResource));
            cc.setLeftEditable(true);
            cc.setRightLabel(this.getReferenceImplementationString(this.fResource));
            cc.setRightEditable(false);
        }
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        if (this.isDirty()) {
            super.saveChanges(pm);
            byte[] bytes = ((ResourceNode)this.fLeft).getContent();
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                IFile file = (IFile)this.fResource;
                if (file.exists()) {
                    file.setContents((InputStream)is, false, true, pm);
                } else {
                    file.create((InputStream)is, false, pm);
                }
                this.flushViewers(pm);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.fDiffViewer != null) {
                this.fDiffViewer.refresh();
            }
            this.setDirty(false);
        }
        pm.done();
    }

    public Viewer createDiffViewer(Composite parent) {
        this.fDiffViewer = new DiffTreeViewer(parent, this.getCompareConfiguration());
        return this.fDiffViewer;
    }

    static class FrameworkFileNode
    extends BufferedContent
    implements IStructureComparator,
    ITypedElement {
        IResource resource;

        FrameworkFileNode(IResource resource) {
            this.resource = resource;
        }

        protected InputStream createStream() throws CoreException {
            try {
                return SFCorePlugin.getDefault().getReferenceImplementationStream(this.resource);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "com.atmel.avr32.sf.core.ui", Messages.CompareEditorInput_StreamError, (Throwable)e));
            }
        }

        public Object[] getChildren() {
            return new Object[0];
        }

        public String getName() {
            return this.resource.getName();
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }
    }

    class MyDiffNode
    extends DiffNode {
        private boolean fDirty;
        private ITypedElement fLastId;
        private String fLastName;

        public MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
            this.fDirty = false;
        }

        public void fireChange() {
            super.fireChange();
            CompareEditorInput.this.setDirty(true);
            this.fDirty = true;
            if (CompareEditorInput.this.fDiffViewer != null) {
                CompareEditorInput.this.fDiffViewer.refresh((Object)this);
            }
        }

        void clearDirty() {
            this.fDirty = false;
        }

        public String getName() {
            if (this.fLastName == null) {
                this.fLastName = super.getName();
            }
            if (this.fDirty) {
                return String.valueOf('<') + this.fLastName + '>';
            }
            return this.fLastName;
        }

        public ITypedElement getId() {
            ITypedElement id = super.getId();
            if (id == null) {
                return this.fLastId;
            }
            this.fLastId = id;
            return id;
        }
    }
}

