/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui;

import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.sf.core.IFrameworkData;
import com.atmel.avr32.sf.core.IFrameworkDataWorkingCopy;
import com.atmel.avr32.sf.core.SFCorePlugin;
import com.atmel.avr32.sf.core.ui.internal.framework.Messages;
import com.atmel.avr32.sf.core.ui.internal.framework.WizardUIExecutor;
import com.atmel.avr32.util.Tools;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.SharedDefaults;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SFCoreUIPlugin
extends AbstractUIPlugin {
    private static final String DEPENDS_ON = "dependsOn";
    public static final String EXAMPLE_EXTENSION_ID = "com.atmel.avr32.sf.core.ui.exampleProject";
    public static final String FRAMEWORK_EXTENSION_ID = "com.atmel.avr32.sf.core.framework";
    private static final String ID = "id";
    private static final String LABEL = "label";
    private static final String MESSAGE = "message";
    private static final String OPERATION = "operation";
    private static final String OPTION = "option";
    private static SFCoreUIPlugin plugin;
    public static final String PLUGIN_ID = "com.atmel.avr32.sf.core.ui";
    private static final String VALUE = "value";

    private static void findOptions(IConfigurationElement root, ArrayList<IConfigurationElement> options) {
        IConfigurationElement[] iConfigurationElementArray = root.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (configurationElement.getName().equals(OPTION)) {
                options.add(configurationElement);
            }
            SFCoreUIPlugin.findOptions(configurationElement, options);
            ++n2;
        }
    }

    public static ArrayList<IConfigurationElement> getAllOptions() {
        IConfigurationElement[] extensions;
        ArrayList<IConfigurationElement> options = new ArrayList<IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor("com.atmel.avr32.sf.core.wizard");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement wizard = iConfigurationElementArray[n2];
            SFCoreUIPlugin.findOptions(wizard, options);
            ++n2;
        }
        return options;
    }

    public static SFCoreUIPlugin getDefault() {
        if (plugin == null) {
            plugin = new SFCoreUIPlugin();
        }
        return plugin;
    }

    private static String getOptionLabel(String id) {
        for (IConfigurationElement option : SFCoreUIPlugin.getAllOptions()) {
            if (!option.getAttribute(ID).equals(id)) continue;
            return option.getAttribute(LABEL);
        }
        return null;
    }

    public static IStatus validateDependencies(IFrameworkData data) {
        ArrayList<IConfigurationElement> options = SFCoreUIPlugin.getAllOptions();
        for (IConfigurationElement option : options) {
            String optionValue = data.getValue(option.getAttribute(ID));
            IConfigurationElement[] iConfigurationElementArray = option.getChildren(OPERATION);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement operation = iConfigurationElementArray[n2];
                if (operation.getAttribute(VALUE) == null || operation.getAttribute(VALUE).equals(optionValue)) {
                    IConfigurationElement[] iConfigurationElementArray2 = operation.getChildren(DEPENDS_ON);
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement dependency = iConfigurationElementArray2[n4];
                        String id = dependency.getAttribute(ID);
                        String value = data.getValue(id);
                        String message = dependency.getAttribute(MESSAGE);
                        if (message == null) {
                            message = Messages.FrameworkWizardPage_OptionValueError;
                        }
                        if (value == null || !value.equals(dependency.getAttribute(VALUE))) {
                            return new Status(4, PLUGIN_ID, MessageFormat.format(message, option.getAttribute(LABEL), SFCoreUIPlugin.getOptionLabel(id), dependency.getAttribute(VALUE)));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    public SFCoreUIPlugin() {
        plugin = this;
    }

    private void setPersistentValues() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(FRAMEWORK_EXTENSION_ID);
        IConfigurationElement[] frameworks = extensionPoint.getConfigurationElements();
        SharedDefaults defaults = SharedDefaults.getInstance();
        IConfigurationElement[] iConfigurationElementArray = frameworks;
        int n = frameworks.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement framework = iConfigurationElementArray[n2];
            String id = framework.getAttribute(ID);
            String name = framework.getAttribute("name");
            String source = framework.getAttribute("source");
            URL url = FileLocator.find((Bundle)Platform.getBundle((String)framework.getContributor().getName()), (IPath)new Path(source), null);
            try {
                String path = FileLocator.resolve((URL)url).getFile();
                defaults.addToBackEndStorage(String.valueOf(id) + ".name", name);
                defaults.addToBackEndStorage(String.valueOf(id) + ".source", path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setPersistentValues();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void installExampleProject(IConfigurationElement element, IProject project, IProgressMonitor monitor) throws IOException, CoreException {
        Assert.isTrue((boolean)element.getName().equals("wizard"));
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        String source = element.getAttribute("import");
        HashMap<String, String> sharedValues = new HashMap<String, String>();
        if (source == null) {
            String device = element.getAttribute("device");
            String type = element.getAttribute("projectType");
            try {
                ManagedbuildPlugin.createProject((String)project.getName(), (String)device, (String)type, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (BuildException e1) {
                e1.printStackTrace();
            }
            IConfigurationElement[] items = element.getChildren();
            monitor.beginTask("Installing", items.length);
            IConfigurationElement[] iConfigurationElementArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateCore[] templateCoreArray;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                if (iConfigurationElement.getName().equals("applyTemplate")) {
                    TemplateCore[] list;
                    TemplateCore t = null;
                    String id = iConfigurationElement.getAttribute(ID);
                    templateCoreArray = list = TemplateEngine.getDefault().getTemplates();
                    int n3 = list.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TemplateCore templateCore = templateCoreArray[n4];
                        if (templateCore.getTemplateInfo().getTemplateId().equals(id)) {
                            t = templateCore;
                        }
                        ++n4;
                    }
                    if (t == null) throw new CoreException((IStatus)new Status(4, "com.atmel.avr32.sf.core", "Missing template \"" + id + "\"."));
                    try {
                        IStatus[] s;
                        Map valueStore = t.getValueStore();
                        valueStore.put("projectName", project.getName());
                        valueStore.putAll(sharedValues);
                        IConfigurationElement[] es = iConfigurationElement.getChildren("property");
                        String share = iConfigurationElement.getAttribute("shareProperties");
                        IConfigurationElement[] iConfigurationElementArray2 = es;
                        int n5 = es.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement property = iConfigurationElementArray2[n6];
                            valueStore.put(property.getAttribute(ID), property.getAttribute(VALUE));
                            if (share != null && Boolean.parseBoolean(share)) {
                                sharedValues.put(property.getAttribute(ID), property.getAttribute(VALUE));
                            }
                            ++n6;
                        }
                        IStatus[] iStatusArray = s = t.executeTemplateProcesses((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                        int n7 = s.length;
                        n5 = 0;
                        while (n5 < n7) {
                            IStatus iStatus = iStatusArray[n5];
                            if (!iStatus.isOK()) {
                                StatusManager.getManager().handle(iStatus);
                            }
                            ++n5;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (iConfigurationElement.getName().equals("applyWizard")) {
                    IConfigurationElement w = SFCorePlugin.getDefault().getWizardDescription(iConfigurationElement.getAttribute(ID));
                    IFrameworkDataWorkingCopy data = SFCorePlugin.getDataWorkingCopy((IProject)project);
                    IConfigurationElement[] options = iConfigurationElement.getChildren(OPTION);
                    templateCoreArray = options;
                    int n8 = options.length;
                    int es = 0;
                    while (es < n8) {
                        TemplateCore o = templateCoreArray[es];
                        data.setValue(o.getAttribute(ID), o.getAttribute(VALUE));
                        ++es;
                    }
                    WizardUIExecutor we = new WizardUIExecutor(w, data);
                    IStatus status = we.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (!status.isOK()) {
                        throw new CoreException(status);
                    }
                }
                monitor.worked(1);
                ++n2;
            }
            return;
        }
        monitor.beginTask("Installing", 100);
        URL url = FileLocator.toFileURL((URL)bundle.getEntry(source));
        File f = new File(url.getPath());
        try {
            Tools.unzip((IProject)project, (File)f, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
            project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            ManagedbuildPlugin.upgradeToolchain((IProject)project);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

