/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.actions;

import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.provisional.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.viewers.ISelectionProvider;

public abstract class ExistingIUInProfileAction
extends ProfileModificationAction {
    private String lastValidatedProfileId;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExistingIUInProfileAction(String label, Policy policy, ISelectionProvider selectionProvider, String profileId) {
        super(policy, label, selectionProvider, profileId);
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        Object parent = null;
        this.lastValidatedProfileId = null;
        IProfile profile = this.getProfile(false);
        if (selectionArray.length > 0) {
            int i = 0;
            while (i < selectionArray.length) {
                if (selectionArray[i] instanceof InstalledIUElement) {
                    InstalledIUElement element = (InstalledIUElement)selectionArray[i];
                    if (profile == null) {
                        IQueryable queryable = element.getQueryable();
                        if (queryable instanceof IProfile) {
                            profile = (IProfile)queryable;
                            this.lastValidatedProfileId = profile.getProfileId();
                        } else {
                            return false;
                        }
                    }
                    if (parent == null) {
                        parent = element.getParent(element);
                    } else if (parent != element.getParent(element)) {
                        this.lastValidatedProfileId = null;
                        return false;
                    }
                    if (!this.isSelectable(element.getIU(), profile)) {
                        return false;
                    }
                } else {
                    IInstallableUnit iu;
                    Object object = selectionArray[i];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iu = (IInstallableUnit)ProvUI.getAdapter(object, clazz)) == null || !this.isSelectable(iu)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected boolean isSelectable(IIUElement element) {
        if (!super.isSelectable(element)) {
            return false;
        }
        Object parent = element.getParent(element);
        if (parent != null) {
            IProfile profile;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((profile = (IProfile)ProvUI.getAdapter(parent, clazz)) != null) {
                return this.isSelectable(element.getIU(), profile);
            }
        }
        return false;
    }

    protected boolean isSelectable(IInstallableUnit iu) {
        if (!super.isSelectable(iu)) {
            return false;
        }
        IProfile profile = this.getProfile(false);
        if (profile != null) {
            return this.isSelectable(iu, profile);
        }
        return false;
    }

    private boolean isSelectable(IInstallableUnit iu, IProfile profile) {
        int lock = this.getLock(profile, iu);
        if ((lock & this.getLockConstant()) == this.getLockConstant()) {
            return false;
        }
        String propName = this.getPolicy().getQueryContext().getVisibleInstalledIUProperty();
        return propName == null || this.getProfileProperty(profile, iu, propName) != null;
    }

    protected String getProfileId(boolean chooseProfile) {
        if (this.profileId == null && this.lastValidatedProfileId != null) {
            return this.lastValidatedProfileId;
        }
        return super.getProfileId(chooseProfile);
    }

    protected abstract int getLockConstant();
}

