/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelDirectTCPIP
extends Channel {
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    String host;
    int port;
    String originator_IP_address = "127.0.0.1";
    int originator_port = 0;

    ChannelDirectTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    void init() {
        try {
            this.io = new IO();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void connect() throws JSchException {
        block10: {
            try {
                Session _session = this.getSession();
                if (!_session.isConnected()) {
                    throw new JSchException("session is down");
                }
                Buffer buf = new Buffer(150);
                Packet packet = new Packet(buf);
                packet.reset();
                buf.putByte((byte)90);
                buf.putString("direct-tcpip".getBytes());
                buf.putInt(this.id);
                buf.putInt(this.lwsize);
                buf.putInt(this.lmpsize);
                buf.putString(this.host.getBytes());
                buf.putInt(this.port);
                buf.putString(this.originator_IP_address.getBytes());
                buf.putInt(this.originator_port);
                _session.write(packet);
                int retry = 1000;
                try {
                    while (this.getRecipient() == -1 && _session.isConnected() && retry > 0 && !this.eof_remote) {
                        Thread.sleep(50L);
                        --retry;
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                if (!_session.isConnected()) {
                    throw new JSchException("session is down");
                }
                if (retry == 0 || this.eof_remote) {
                    throw new JSchException("channel is not opened.");
                }
                this.connected = true;
                if (this.io.in != null) {
                    this.thread = new Thread(this);
                    this.thread.setName("DirectTCPIP thread " + _session.getHost());
                    if (_session.daemon_thread) {
                        this.thread.setDaemon(_session.daemon_thread);
                    }
                    this.thread.start();
                }
            }
            catch (Exception e) {
                this.io.close();
                this.io = null;
                Channel.del(this);
                if (!(e instanceof JSchException)) break block10;
                throw (JSchException)e;
            }
        }
    }

    public void run() {
        Buffer buf = new Buffer(this.rmpsize);
        Packet packet = new Packet(buf);
        int i = 0;
        try {
            Session _session = this.getSession();
            while (this.isConnected() && this.thread != null && this.io != null && this.io.in != null) {
                i = this.io.in.read(buf.buffer, 14, buf.buffer.length - 14 - 32 - 20);
                if (i <= 0) {
                    this.eof();
                } else if (!this.close) {
                    packet.reset();
                    buf.putByte((byte)94);
                    buf.putInt(this.recipient);
                    buf.putInt(i);
                    buf.skip(i);
                    _session.write(packet, this, i);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.disconnect();
    }

    public void setInputStream(InputStream in) {
        this.io.setInputStream(in);
    }

    public void setOutputStream(OutputStream out) {
        this.io.setOutputStream(out);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setOrgIPAddress(String foo) {
        this.originator_IP_address = foo;
    }

    public void setOrgPort(int foo) {
        this.originator_port = foo;
    }

    static {
        LOCAL_WINDOW_SIZE_MAX = 131072;
        LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    }
}

