/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.dialogs.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExPatternEntryDialog
extends StatusDialog {
    private StringButtonDialogField fExclusionPatternDialog;
    private StatusInfo fExclusionPatternStatus;
    private IContainer fCurrSourceFolder;
    private String fExclusionPattern;
    private List<String> fExistingPatterns;

    public ExPatternEntryDialog(Shell parent, String patternToEdit, List<String> existingPatterns, IProject proj, IPath path) {
        super(parent);
        this.fExistingPatterns = existingPatterns;
        if (patternToEdit == null) {
            this.setTitle(CPathEntryMessages.ExclusionPatternEntryDialog_add_title);
        } else {
            this.setTitle(CPathEntryMessages.ExclusionPatternEntryDialog_edit_title);
            this.fExistingPatterns.remove(patternToEdit);
        }
        IWorkspaceRoot root = proj.getWorkspace().getRoot();
        IResource res = root.findMember(path);
        if (res instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)res;
        }
        this.fExclusionPatternStatus = new StatusInfo();
        String label = NLS.bind((String)CPathEntryMessages.ExclusionPatternEntryDialog_pattern_label, (Object)path.makeRelative().toString());
        ExPatternAdapter adapter = new ExPatternAdapter();
        this.fExclusionPatternDialog = new StringButtonDialogField(adapter);
        this.fExclusionPatternDialog.setLabelText(label);
        this.fExclusionPatternDialog.setButtonLabel(CPathEntryMessages.ExclusionPatternEntryDialog_pattern_button);
        this.fExclusionPatternDialog.setDialogFieldListener(adapter);
        this.fExclusionPatternDialog.enableButton(this.fCurrSourceFolder != null);
        if (patternToEdit == null) {
            this.fExclusionPatternDialog.setText("");
        } else {
            this.fExclusionPatternDialog.setText(patternToEdit.toString());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int widthHint = this.convertWidthInCharsToPixels(60);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        Label description = new Label(inner, 64);
        description.setText(CPathEntryMessages.ExclusionPatternEntryDialog_description);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        description.setLayoutData((Object)gd);
        this.fExclusionPatternDialog.doFillIntoGrid(inner, 3);
        LayoutUtil.setWidthHint((Control)this.fExclusionPatternDialog.getLabelControl(null), widthHint);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternDialog.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fExclusionPatternDialog.getTextControl(null), widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fExclusionPatternDialog.getTextControl(null));
        this.fExclusionPatternDialog.postSetFocusOnDialogField(parent.getDisplay());
        ExPatternEntryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doChangeControlPressed() {
        IPath pattern = this.chooseExclusionPattern();
        if (pattern != null) {
            this.fExclusionPatternDialog.setText(pattern.toString());
        }
    }

    protected void doStatusLineUpdate() {
        this.checkIfPatternValid();
        this.updateStatus(this.fExclusionPatternStatus);
    }

    protected void checkIfPatternValid() {
        String pattern = this.fExclusionPatternDialog.getText().trim();
        if (pattern.length() == 0) {
            this.fExclusionPatternStatus.setError(CPathEntryMessages.ExclusionPatternEntryDialog_error_empty);
            return;
        }
        Path path = new Path(pattern);
        if (path.isAbsolute() || path.getDevice() != null) {
            this.fExclusionPatternStatus.setError(CPathEntryMessages.ExclusionPatternEntryDialog_error_notrelative);
            return;
        }
        if (this.fExistingPatterns.contains(pattern)) {
            this.fExclusionPatternStatus.setError(CPathEntryMessages.ExclusionPatternEntryDialog_error_exists);
            return;
        }
        this.fExclusionPattern = pattern;
        this.fExclusionPatternStatus.setOK();
    }

    public String getExclusionPattern() {
        return this.fExclusionPattern;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    private IPath chooseExclusionPattern() {
        Class[] acceptedClasses = new Class[]{IFolder.class, IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Path initialPath = new Path(this.fExclusionPatternDialog.getText());
        IResource initialElement = null;
        IContainer curr = this.fCurrSourceFolder;
        int nSegments = initialPath.segmentCount();
        int i = 0;
        while (i < nSegments) {
            IResource elem = curr.findMember(initialPath.segment(i));
            if (elem != null) {
                initialElement = elem;
            }
            if (!(elem instanceof IContainer)) break;
            curr = (IContainer)elem;
            ++i;
        }
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(CPathEntryMessages.ExclusionPatternEntryDialog_ChooseExclusionPattern_title);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(CPathEntryMessages.ExclusionPatternEntryDialog_ChooseExclusionPattern_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fCurrSourceFolder);
        dialog.setInitialSelection((Object)initialElement);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            IPath path = res.getFullPath().removeFirstSegments(this.fCurrSourceFolder.getFullPath().segmentCount()).makeRelative();
            if (res instanceof IContainer) {
                return path.addTrailingSeparator();
            }
            return path;
        }
        return null;
    }

    private class ExPatternAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private ExPatternAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            ExPatternEntryDialog.this.doStatusLineUpdate();
        }

        public void changeControlPressed(DialogField field) {
            ExPatternEntryDialog.this.doChangeControlPressed();
        }
    }
}

