/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiConfigDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ErrorParsTab
extends AbstractCPropertyTab {
    private HashMap<String, String> mapParsers = new HashMap();
    private Table table;
    private CheckboxTableViewer tv;
    private ICConfigurationDescription cfgd;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new FillLayout());
        this.table = new Table(this.usercomp, 2084);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorParsTab.this.updateButtons();
            }
        });
        this.tv = new CheckboxTableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                ErrorParsTab.this.saveChecked();
            }
        });
        String[] stringArray = new String[5];
        stringArray[0] = MOVEUP_STR;
        stringArray[1] = MOVEDOWN_STR;
        stringArray[3] = UIMessages.getString("ErrorParsTab.0");
        stringArray[4] = UIMessages.getString("ErrorParsTab.1");
        this.initButtons(stringArray);
        this.initMapParsers();
    }

    protected void initMapParsers() {
        this.mapParsers.clear();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "ErrorParser");
        if (point != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = point.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                if (ext.getConfigurationElements().length > 0) {
                    this.mapParsers.put(ext.getUniqueIdentifier(), ext.getLabel());
                }
                ++n2;
            }
        }
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.moveItem(true);
                break;
            }
            case 1: {
                this.moveItem(false);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.tv.setAllChecked(true);
                this.saveChecked();
                break;
            }
            case 4: {
                this.tv.setAllChecked(false);
                this.saveChecked();
                break;
            }
        }
    }

    private void moveItem(boolean up) {
        int n = this.table.getSelectionIndex();
        if (n < 0 || up && n == 0 || !up && n + 1 == this.table.getItemCount()) {
            return;
        }
        TableData d = (TableData)this.tv.getElementAt(n);
        boolean checked = this.tv.getChecked((Object)d);
        this.tv.remove((Object)d);
        n = up ? n - 1 : n + 1;
        this.tv.insert((Object)d, n);
        this.tv.setChecked((Object)d, checked);
        this.table.setSelection(n);
        this.saveChecked();
    }

    public void updateData(ICResourceDescription _cfgd) {
        this.cfgd = _cfgd.getConfiguration();
        if (this.mapParsers == null) {
            return;
        }
        String[] ss = null;
        if (this.page.isMultiCfg()) {
            String[][] ids = ((ICMultiConfigDescription)this.cfgd).getErrorParserIDs();
            ss = CDTPrefUtil.getStrListForDisplay(ids);
        } else {
            ss = this.cfgd.getBuildSetting().getErrorParserIDs();
        }
        ArrayList<TableData> data = new ArrayList<TableData>(this.mapParsers.size());
        ArrayList<TableData> checked = new ArrayList<TableData>(ss.length);
        HashMap<String, String> cloneMap = new HashMap<String, String>(this.mapParsers);
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String s = cloneMap.get(element);
            if (s != null) {
                TableData d = new TableData(element, s);
                data.add(d);
                checked.add(d);
                cloneMap.remove(element);
            }
            ++n2;
        }
        for (String s : cloneMap.keySet()) {
            data.add(new TableData(s, cloneMap.get(s)));
        }
        this.tv.setInput((Object)data.toArray());
        this.tv.setCheckedElements(checked.toArray());
        this.updateButtons();
    }

    public void updateButtons() {
        int cnt = this.table.getItemCount();
        int pos = this.table.getSelectionIndex();
        this.buttonSetEnabled(0, pos > 0);
        this.buttonSetEnabled(1, pos != -1 && pos < cnt - 1);
        this.buttonSetEnabled(3, cnt > 0);
        this.buttonSetEnabled(4, cnt > 0);
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        ICConfigurationDescription sd = src.getConfiguration();
        ICConfigurationDescription dd = dst.getConfiguration();
        String[] s = null;
        if (sd instanceof ICMultiConfigDescription) {
            String[][] ss = ((ICMultiConfigDescription)sd).getErrorParserIDs();
            s = CDTPrefUtil.getStrListForDisplay(ss);
        } else {
            s = sd.getBuildSetting().getErrorParserIDs();
        }
        if (dd instanceof ICMultiConfigDescription) {
            ((ICMultiConfigDescription)dd).setErrorParserIDs(s);
        } else {
            dd.getBuildSetting().setErrorParserIDs(s);
        }
    }

    private void saveChecked() {
        Object[] objs = this.tv.getCheckedElements();
        ArrayList<String> lst = new ArrayList<String>();
        if (objs != null) {
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object ob = objectArray[n2];
                lst.add(((TableData)ob).key);
                ++n2;
            }
        }
        String[] s = lst.toArray(new String[lst.size()]);
        if (this.cfgd instanceof ICMultiConfigDescription) {
            ((ICMultiConfigDescription)this.cfgd).setErrorParserIDs(s);
        } else {
            this.cfgd.getBuildSetting().setErrorParserIDs(s);
        }
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    protected void performDefaults() {
        if (this.cfgd instanceof ICMultiConfigDescription) {
            ((ICMultiConfigDescription)this.cfgd).setErrorParserIDs(null);
        } else {
            this.cfgd.getBuildSetting().setErrorParserIDs(null);
        }
        this.updateData(this.getResDesc());
    }

    class TableData {
        String key;
        String value;

        public TableData(String _key, String _value) {
            this.key = _key;
            this.value = _value;
        }

        public String toString() {
            return this.value;
        }
    }
}

