/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.model.ILanguageDescriptor;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.model.util.CDTListComparator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICMultiFolderDescription;
import org.eclipse.cdt.core.settings.model.ICMultiItemsHolder;
import org.eclipse.cdt.core.settings.model.ICMultiResourceDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.MultiLanguageSetting;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLangsListTab
extends AbstractCPropertyTab {
    protected Table table;
    protected TableViewer tv;
    protected Tree langTree;
    protected TreeColumn langCol;
    protected Button showBIButton;
    protected boolean toAllCfgs = false;
    protected boolean toAllLang = false;
    protected Label lb1;
    protected Label lb2;
    protected TableColumn columnToFit = null;
    protected ICLanguageSetting lang;
    protected LinkedList<ICLanguageSettingEntry> shownEntries;
    protected ArrayList<ICSettingEntry> exported;
    protected SashForm sashForm;
    protected ICLanguageSetting[] ls;
    private boolean fHadSomeModification;
    protected static final String[] BUTTONS;
    protected static final String[] BUTTSYM;
    private static final Comparator<Object> comp;
    private static final Image IMG_FS;
    private static final Image IMG_WS;
    private static final Image IMG_MK;
    private static final int[] DEFAULT_SASH_WEIGHTS;

    static {
        String[] stringArray = new String[7];
        stringArray[0] = ADD_STR;
        stringArray[1] = EDIT_STR;
        stringArray[2] = DEL_STR;
        stringArray[3] = UIMessages.getString("AbstractLangsListTab.2");
        stringArray[5] = MOVEUP_STR;
        stringArray[6] = MOVEDOWN_STR;
        BUTTONS = stringArray;
        BUTTSYM = new String[]{ADD_STR, EDIT_STR, DEL_STR, UIMessages.getString("AbstractLangsListTab.2")};
        comp = CDTListComparator.getInstance();
        IMG_FS = CPluginImages.get("org.eclipse.cdt.ui.filesyst.gif");
        IMG_WS = CPluginImages.get("org.eclipse.cdt.ui.workspace.gif");
        IMG_MK = CPluginImages.get("org.eclipse.cdt.ui.define_obj.gif");
        DEFAULT_SASH_WEIGHTS = new int[]{10, 30};
    }

    @Override
    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(2, true));
        this.sashForm = new SashForm(this.usercomp, 0);
        this.sashForm.setOrientation(256);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.sashForm.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        this.sashForm.setLayout((Layout)layout);
        this.addTree((Composite)this.sashForm).setLayoutData((Object)new GridData(1040));
        this.table = new Table((Composite)this.sashForm, 68098);
        gd = new GridData(1808);
        gd.widthHint = 150;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(this.isHeaderVisible());
        this.table.setLinesVisible(true);
        this.sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
        this.sashForm.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Point currentSize;
                if (event.detail == 1) {
                    return;
                }
                int shift = event.x - AbstractLangsListTab.this.sashForm.getBounds().x;
                GridData data = (GridData)AbstractLangsListTab.this.langTree.getLayoutData();
                if (data.widthHint + shift < 20) {
                    return;
                }
                Point computedSize = AbstractLangsListTab.this.usercomp.getShell().computeSize(-1, -1);
                boolean customSize = !computedSize.equals((Object)(currentSize = AbstractLangsListTab.this.usercomp.getShell().getSize()));
                data.widthHint = data.widthHint;
                AbstractLangsListTab.this.sashForm.layout(true);
                computedSize = AbstractLangsListTab.this.usercomp.getShell().computeSize(-1, -1);
                if (customSize) {
                    computedSize.x = Math.max(computedSize.x, currentSize.x);
                }
                computedSize.y = Math.max(computedSize.y, currentSize.y);
                if (computedSize.equals((Object)currentSize)) {
                    return;
                }
            }
        });
        this.tv = new TableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new RichLabelProvider());
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractLangsListTab.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (AbstractLangsListTab.this.buttonIsEnabled(1) && AbstractLangsListTab.this.table.getSelectionIndex() != -1) {
                    AbstractLangsListTab.this.buttonPressed(1);
                }
            }
        });
        this.table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                AbstractLangsListTab.this.setColumnToFit();
            }

            public void controlResized(ControlEvent e) {
                AbstractLangsListTab.this.setColumnToFit();
            }
        });
        this.setupLabel(this.usercomp, "", 1, 0);
        this.lb1 = new Label(this.usercomp, 0x1000800);
        this.lb1.setLayoutData((Object)new GridData(768));
        this.lb1.setToolTipText(UIMessages.getString("EnvironmentTab.15"));
        this.lb1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CDTPrefUtil.spinDMode();
                AbstractLangsListTab.this.update();
            }
        });
        this.showBIButton = this.setupCheck(this.usercomp, UIMessages.getString("AbstractLangsListTab.0"), 1, 768);
        this.showBIButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractLangsListTab.this.update();
            }
        });
        this.lb2 = new Label(this.usercomp, 0x1000800);
        this.lb2.setLayoutData((Object)new GridData(768));
        this.lb2.setToolTipText(UIMessages.getString("EnvironmentTab.23"));
        this.lb2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CDTPrefUtil.spinWMode();
                AbstractLangsListTab.this.updateLbs(null, AbstractLangsListTab.this.lb2);
            }
        });
        this.additionalTableSet();
        this.initButtons(this.getKind() == 4 ? BUTTSYM : BUTTONS);
        this.updateData(this.getResDesc());
    }

    @Override
    protected void updateButtons() {
        int index = this.table.getSelectionIndex();
        int[] ids = this.table.getSelectionIndices();
        boolean canAdd = this.langTree.getItemCount() > 0;
        boolean canExport = index != -1;
        boolean canEdit = canExport && ids.length == 1;
        boolean canDelete = canExport;
        ICLanguageSettingEntry ent = null;
        if (canExport) {
            ent = (ICLanguageSettingEntry)this.table.getItem(index).getData();
            if (ent.isReadOnly()) {
                canEdit = false;
            }
            if (ent.isReadOnly()) {
                canDelete = false;
            }
            if (this.exported.contains(ent)) {
                this.buttonSetText(3, UIMessages.getString("AbstractLangsListTab.4"));
            } else {
                this.buttonSetText(3, UIMessages.getString("AbstractLangsListTab.2"));
            }
        } else {
            this.buttonSetText(3, UIMessages.getString("AbstractLangsListTab.2"));
        }
        boolean canMoveUp = false;
        boolean canMoveDown = false;
        if (ent != null) {
            canMoveUp = canEdit && index > 0 && !ent.isBuiltIn();
            boolean bl = canMoveDown = canEdit && index < this.table.getItemCount() - 1 && !ent.isBuiltIn();
        }
        if (canMoveDown && this.showBIButton.getSelection() && (ent = (ICLanguageSettingEntry)this.table.getItem(index + 1).getData()).isBuiltIn()) {
            canMoveDown = false;
        }
        this.buttonSetEnabled(0, canAdd);
        this.buttonSetEnabled(1, canEdit);
        this.buttonSetEnabled(2, canDelete);
        this.buttonSetEnabled(3, canExport && !this.page.isMultiCfg());
        this.buttonSetEnabled(5, canMoveUp && !this.page.isMultiCfg());
        this.buttonSetEnabled(6, canMoveDown && !this.page.isMultiCfg());
    }

    private Tree addTree(Composite comp) {
        this.langTree = new Tree(comp, 2308);
        this.langTree.setLayoutData((Object)new GridData(1040));
        this.langTree.setHeaderVisible(true);
        this.langTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICLanguageSetting ls;
                TreeItem[] items = AbstractLangsListTab.this.langTree.getSelection();
                if (items.length > 0 && (ls = (ICLanguageSetting)items[0].getData()) != null) {
                    AbstractLangsListTab.this.lang = ls;
                    AbstractLangsListTab.this.update();
                }
            }
        });
        this.langTree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int x = AbstractLangsListTab.this.langTree.getBounds().width - 5;
                if (AbstractLangsListTab.this.langCol.getWidth() != x) {
                    AbstractLangsListTab.this.langCol.setWidth(x);
                }
            }
        });
        this.langCol = new TreeColumn(this.langTree, 0);
        this.langCol.setText(UIMessages.getString("AbstractLangsListTab.1"));
        this.langCol.setWidth(200);
        this.langCol.setResizable(false);
        this.langTree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UIMessages.getString("AbstractLangsListTab.1");
            }
        });
        return this.langTree;
    }

    public abstract int getKind();

    public abstract ICLanguageSettingEntry doAdd();

    public abstract ICLanguageSettingEntry doEdit(ICLanguageSettingEntry var1);

    public void additionalTableSet() {
    }

    public void update() {
        this.update(0);
    }

    public void update(int shift) {
        if (this.lang != null) {
            int x = this.table.getSelectionIndex();
            x = x == -1 ? 0 : (x += shift);
            this.shownEntries = this.getIncs();
            this.tv.setInput((Object)this.shownEntries.toArray(new Object[this.shownEntries.size()]));
            if (this.table.getItemCount() > x) {
                this.table.setSelection(x);
            } else if (this.table.getItemCount() > 0) {
                this.table.setSelection(0);
            }
        }
        this.updateLbs(this.lb1, this.lb2);
        this.updateButtons();
    }

    protected LinkedList<ICLanguageSettingEntry> getIncs() {
        LinkedList<ICLanguageSettingEntry> l = new LinkedList<ICLanguageSettingEntry>();
        List<ICLanguageSettingEntry> lst = this.getSettingEntriesList(this.getKind());
        if (lst != null) {
            for (ICLanguageSettingEntry ent : lst) {
                if (ent.isBuiltIn()) continue;
                l.add(ent);
            }
            if (this.showBIButton.getSelection()) {
                for (ICLanguageSettingEntry ent : lst) {
                    if (!ent.isBuiltIn()) continue;
                    l.add(ent);
                }
            }
        }
        return l;
    }

    @Override
    public void updateData(ICResourceDescription cfg) {
        if (cfg == null || !this.canBeVisible()) {
            return;
        }
        this.updateExport();
        this.langTree.removeAll();
        TreeItem firstItem = null;
        this.ls = this.getLangSetting(cfg);
        if (this.ls != null) {
            Arrays.sort(this.ls, CDTListComparator.getInstance());
            int i = 0;
            while (i < this.ls.length) {
                if ((this.ls[i].getSupportedEntryKinds() & this.getKind()) != 0) {
                    TreeItem t = new TreeItem(this.langTree, 0);
                    String s = this.ls[i].getLanguageId();
                    if (s != null && !s.equals("")) {
                        ILanguageDescriptor ld = LanguageManager.getInstance().getLanguageDescriptor(s);
                        s = ld == null ? null : ld.getName();
                    }
                    if (s == null || s.equals("")) {
                        s = this.ls[i].getName();
                    }
                    t.setText(0, s);
                    t.setData((Object)this.ls[i]);
                    if (firstItem == null) {
                        firstItem = t;
                        this.lang = this.ls[i];
                    }
                }
                ++i;
            }
            if (firstItem != null && this.table != null) {
                this.langTree.setSelection(firstItem);
            }
        }
        this.update();
    }

    private void updateExport() {
        this.exported = new ArrayList();
        ICExternalSetting[] vals = this.getResDesc().getConfiguration().getExternalSettings();
        if (vals != null && vals.length != 0) {
            ICExternalSetting[] iCExternalSettingArray = vals;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                ICExternalSetting v = iCExternalSettingArray[n2];
                ICSettingEntry[] ents = v.getEntries(this.getKind());
                if (ents != null && ents.length != 0) {
                    ICSettingEntry[] iCSettingEntryArray = ents;
                    int n3 = ents.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICSettingEntry en = iCSettingEntryArray[n4];
                        this.exported.add(en);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void performAdd(ICLanguageSettingEntry ent) {
        if (ent != null) {
            this.fHadSomeModification = true;
            if ((this.toAllCfgs || this.toAllLang) && !(this.getResDesc() instanceof ICMultiResourceDescription)) {
                this.addToAll(ent);
            } else if (this.isWModifyMode() && this.lang instanceof MultiLanguageSetting) {
                this.performMulti(ent, null);
            } else {
                this.changeIt(ent, null);
            }
            this.update();
        }
    }

    private void changeIt(ICLanguageSettingEntry add, ICLanguageSettingEntry[] del) {
        List<ICLanguageSettingEntry> ls = this.getSettingEntriesList(this.getKind());
        if (del != null) {
            ICLanguageSettingEntry[] iCLanguageSettingEntryArray = del;
            int n = del.length;
            int n2 = 0;
            while (n2 < n) {
                ICLanguageSettingEntry d = iCLanguageSettingEntryArray[n2];
                for (ICLanguageSettingEntry e : ls) {
                    if (!d.getName().equals(e.getName())) continue;
                    ls.remove(e);
                    break;
                }
                ++n2;
            }
        }
        if (add != null) {
            ls.add(add);
        }
        this.setSettingEntries(this.getKind(), ls, this.toAllLang);
    }

    private void performMulti(ICLanguageSettingEntry ent, ICLanguageSettingEntry del) {
        MultiLanguageSetting ms = (MultiLanguageSetting)this.lang;
        ICLanguageSetting[] ls = (ICLanguageSetting[])ms.getItems();
        ICLanguageSettingEntry[][] es = ms.getSettingEntriesM(this.getKind());
        int i = 0;
        while (i < ls.length) {
            ArrayList<ICLanguageSettingEntry> entries = new ArrayList<ICLanguageSettingEntry>(Arrays.asList(es[i]));
            if (del != null) {
                for (ICLanguageSettingEntry e : entries) {
                    if (!e.getName().equals(del.getName())) continue;
                    entries.remove(e);
                    break;
                }
            }
            if (ent != null) {
                entries.add(ent);
            }
            ls[i].setSettingEntries(this.getKind(), entries);
            ++i;
        }
    }

    private void performEdit(int n) {
        if (n == -1) {
            return;
        }
        ICLanguageSettingEntry old = (ICLanguageSettingEntry)this.table.getItem(n).getData();
        if (old.isReadOnly()) {
            return;
        }
        ICLanguageSettingEntry ent = this.doEdit(old);
        this.toAllLang = false;
        if (ent != null) {
            this.fHadSomeModification = true;
            if (this.isWModifyMode() && this.lang instanceof MultiLanguageSetting) {
                this.performMulti(ent, old);
            } else {
                ICLanguageSettingEntry[] del = null;
                if (!ent.getName().equals(old.getName())) {
                    del = new ICLanguageSettingEntry[]{old};
                }
                this.changeIt(ent, del);
            }
            this.update();
        }
    }

    private void performDelete(int n) {
        if (n == -1) {
            return;
        }
        this.fHadSomeModification = true;
        int[] ids = this.table.getSelectionIndices();
        if (this.isWModifyMode() && this.lang instanceof MultiLanguageSetting) {
            int x = ids.length - 1;
            while (x >= 0) {
                ICLanguageSettingEntry old = (ICLanguageSettingEntry)this.table.getItem(ids[x]).getData();
                this.performMulti(null, old);
                --x;
            }
        } else {
            ICLanguageSettingEntry[] del = new ICLanguageSettingEntry[ids.length];
            int x = ids.length - 1;
            while (x >= 0) {
                ICLanguageSettingEntry old;
                del[x] = old = (ICLanguageSettingEntry)this.table.getItem(ids[x]).getData();
                --x;
            }
            this.changeIt(null, del);
        }
        this.update();
    }

    @Override
    public void buttonPressed(int i) {
        int n = this.table.getSelectionIndex();
        int[] ids = this.table.getSelectionIndices();
        switch (i) {
            case 0: {
                this.toAllCfgs = false;
                this.toAllLang = false;
                this.performAdd(this.doAdd());
                break;
            }
            case 1: {
                this.performEdit(n);
                break;
            }
            case 2: {
                this.performDelete(n);
                break;
            }
            case 3: {
                if (n == -1) {
                    return;
                }
                int x = ids.length - 1;
                while (x >= 0) {
                    ICLanguageSettingEntry old = (ICLanguageSettingEntry)this.table.getItem(ids[x]).getData();
                    if (this.exported.contains(old)) {
                        this.deleteExportSetting((ICSettingEntry)old);
                    } else {
                        this.page.getResDesc().getConfiguration().createExternalSetting(new String[]{this.lang.getId()}, null, null, (ICSettingEntry[])new ICLanguageSettingEntry[]{old});
                    }
                    --x;
                }
                this.updateExport();
                this.update();
                break;
            }
            case 5: 
            case 6: {
                ICLanguageSettingEntry old = (ICLanguageSettingEntry)this.table.getItem(n).getData();
                int x = this.shownEntries.indexOf(old);
                if (x < 0) break;
                if (i == 6) {
                    ++x;
                }
                old = this.shownEntries.get(x);
                ICLanguageSettingEntry old2 = this.shownEntries.get(x - 1);
                this.shownEntries.remove(x);
                this.shownEntries.remove(x - 1);
                this.shownEntries.add(x - 1, old);
                this.shownEntries.add(x, old2);
                this.setSettingEntries(this.getKind(), this.shownEntries, false);
                this.update(i == 5 ? -1 : 1);
                break;
            }
        }
        this.table.setFocus();
    }

    private void deleteExportSetting(ICSettingEntry ent) {
        ICConfigurationDescription cfg = this.getResDesc().getConfiguration();
        ICExternalSetting[] vals = cfg.getExternalSettings();
        if (vals != null && vals.length != 0) {
            int i = 0;
            while (i < vals.length) {
                ICSettingEntry[] ents = vals[i].getEntries(this.getKind());
                if (ents != null && ents.length != 0) {
                    int j = 0;
                    while (j < ents.length) {
                        if (ents[j].equalsByName(ent)) {
                            ICSettingEntry[] arr = new ICSettingEntry[ents.length - 1];
                            int index = 0;
                            int k = 0;
                            while (k < ents.length) {
                                if (k != j) {
                                    arr[index++] = ents[k];
                                }
                                ++k;
                            }
                            cfg.removeExternalSetting(vals[i]);
                            cfg.createExternalSetting(vals[i].getCompatibleLanguageIds(), vals[i].getCompatibleContentTypeIds(), vals[i].getCompatibleExtensions(), arr);
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void addToAll(ICLanguageSettingEntry ent) {
        ICConfigurationDescription[] cfgs = this.page.getCfgsEditable();
        ICResourceDescription cur_cfg = this.page.getResDesc();
        String id = this.lang.getName();
        int i = 0;
        while (i < cfgs.length) {
            ICResourceDescription rcfg = this.page.getResDesc(cfgs[i]);
            if (rcfg != null && (this.toAllCfgs || cur_cfg.equals(rcfg))) {
                ICLanguageSetting[] iCLanguageSettingArray = this.getLangSetting(rcfg);
                int n = iCLanguageSettingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICLanguageSetting l = iCLanguageSettingArray[n2];
                    if (id == l.getName() || this.toAllLang) {
                        List lst = l.getSettingEntriesList(this.getKind());
                        lst.add(ent);
                        l.setSettingEntries(this.getKind(), lst);
                    }
                    ++n2;
                }
            }
            ++i;
        }
    }

    @Override
    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        block7: {
            block6: {
                this.fHadSomeModification = false;
                if (!this.page.isMultiCfg()) break block6;
                ICLanguageSetting[] sr = this.ls;
                if (!(dst instanceof ICMultiItemsHolder)) break block7;
                Object[] objectArray = ((ICMultiItemsHolder)dst).getItems();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object ob = objectArray[n2];
                    if (ob instanceof ICResourceDescription) {
                        ICLanguageSetting[] ds = this.getLangSetting((ICResourceDescription)ob);
                        if (ds == null || sr.length != ds.length) {
                            return;
                        }
                        int i = 0;
                        while (i < sr.length) {
                            ICLanguageSettingEntry[] ents = null;
                            ents = sr[i].getSettingEntries(this.getKind());
                            ds[i].setSettingEntries(this.getKind(), ents);
                            ++i;
                        }
                    }
                    ++n2;
                }
                break block7;
            }
            ICLanguageSetting[] sr = this.getLangSetting(src);
            ICLanguageSetting[] ds = this.getLangSetting(dst);
            if (sr == null || ds == null || sr.length != ds.length) {
                return;
            }
            int i = 0;
            while (i < sr.length) {
                ICLanguageSettingEntry[] ents = null;
                ents = sr[i].getSettingEntries(this.getKind());
                ds[i].setSettingEntries(this.getKind(), ents);
                ++i;
            }
        }
    }

    @Override
    protected void performDefaults() {
        this.fHadSomeModification = true;
        TreeItem[] tis = this.langTree.getItems();
        int i = 0;
        while (i < tis.length) {
            Object ob = tis[i].getData();
            if (ob != null && ob instanceof ICLanguageSetting) {
                ((ICLanguageSetting)ob).setSettingEntries(this.getKind(), null);
            }
            ++i;
        }
        this.updateData(this.getResDesc());
    }

    public ICLanguageSetting[] getLangSetting(ICResourceDescription rcDes) {
        switch (rcDes.getType()) {
            case 1: 
            case 2: 
            case 4: {
                ICFolderDescription foDes = (ICFolderDescription)rcDes;
                if (foDes instanceof ICMultiFolderDescription) {
                    return this.getLS((ICMultiFolderDescription)foDes);
                }
                return foDes.getLanguageSettings();
            }
            case 8: {
                ICLanguageSetting[] iCLanguageSettingArray;
                ICFileDescription fiDes = (ICFileDescription)rcDes;
                ICLanguageSetting ls = fiDes.getLanguageSetting();
                if (ls != null) {
                    ICLanguageSetting[] iCLanguageSettingArray2 = new ICLanguageSetting[1];
                    iCLanguageSettingArray = iCLanguageSettingArray2;
                    iCLanguageSettingArray2[0] = ls;
                } else {
                    iCLanguageSettingArray = null;
                }
                return iCLanguageSettingArray;
            }
        }
        return null;
    }

    private ICLanguageSetting[] getLS(ICMultiFolderDescription foDes) {
        Object[][] ls = foDes.getLanguageSettingsM(comp);
        ICLanguageSetting[] fs = this.conv2LS(CDTPrefUtil.getListForDisplay(ls, comp));
        ICLanguageSetting[] lsets = new ICLanguageSetting[fs.length];
        int i = 0;
        while (i < fs.length) {
            ArrayList<Object> list = new ArrayList<Object>(ls.length);
            int j = 0;
            while (j < ls.length) {
                int x = Arrays.binarySearch(ls[j], fs[i], comp);
                if (x >= 0) {
                    list.add(ls[j][x]);
                }
                ++j;
            }
            if (list.size() == 1) {
                lsets[i] = (ICLanguageSetting)list.get(0);
            } else if (list.size() > 1) {
                lsets[i] = new MultiLanguageSetting(list, foDes.getConfiguration());
            }
            ++i;
        }
        return lsets;
    }

    @Override
    public boolean canBeVisible() {
        if (this.getResDesc() == null) {
            return true;
        }
        ICLanguageSetting[] ls = this.getLangSetting(this.getResDesc());
        if (ls == null) {
            return false;
        }
        int i = 0;
        while (i < ls.length) {
            if ((ls[i].getSupportedEntryKinds() & this.getKind()) != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setSettingEntries(int kind, List<ICLanguageSettingEntry> incs, boolean toAll) {
        if (this.page.isMultiCfg()) {
            ((ICMultiResourceDescription)this.getResDesc()).setSettingEntries(this.lang, kind, incs, toAll);
        } else {
            this.lang.setSettingEntries(kind, incs);
        }
    }

    private List<ICLanguageSettingEntry> getSettingEntriesList(int kind) {
        if (this.page.isMultiCfg() && this.lang instanceof MultiLanguageSetting) {
            Object[][] lses = ((MultiLanguageSetting)this.lang).getSettingEntriesM(kind);
            Object[] res = CDTPrefUtil.getListForDisplay(lses, comp);
            ICLanguageSettingEntry[] out = new ICLanguageSettingEntry[res.length];
            System.arraycopy(res, 0, out, 0, res.length);
            return Arrays.asList(out);
        }
        return this.lang.getSettingEntriesList(kind);
    }

    private ICLanguageSetting[] conv2LS(Object[] ob) {
        ICLanguageSetting[] se = new ICLanguageSetting[ob.length];
        System.arraycopy(ob, 0, se, 0, ob.length);
        return se;
    }

    protected boolean isHeaderVisible() {
        return true;
    }

    protected void setColumnToFit() {
        if (this.columnToFit != null) {
            this.columnToFit.setWidth(this.table.getBounds().width - 4);
        }
    }

    protected final boolean hadSomeModification() {
        return this.fHadSomeModification;
    }

    private class RichLabelProvider
    extends LabelProvider
    implements IFontProvider,
    ITableLabelProvider {
        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex > 0) {
                return null;
            }
            if (!(element instanceof ICLanguageSettingEntry)) {
                return null;
            }
            ICLanguageSettingEntry le = (ICLanguageSettingEntry)element;
            if (le.getKind() == 4) {
                return IMG_MK;
            }
            if ((le.getFlags() & 8) != 0) {
                return IMG_WS;
            }
            return IMG_FS;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof ICLanguageSettingEntry)) {
                return columnIndex == 0 ? element.toString() : "";
            }
            ICLanguageSettingEntry le = (ICLanguageSettingEntry)element;
            if (columnIndex == 0) {
                String s = le.getName();
                if (AbstractLangsListTab.this.exported.contains(le)) {
                    s = String.valueOf(s) + UIMessages.getString("AbstractLangsListTab.3");
                }
                return s;
            }
            if (le.getKind() == 4) {
                switch (columnIndex) {
                    case 1: {
                        return le.getValue();
                    }
                }
            }
            return "";
        }

        public Font getFont(Object element) {
            if (!(element instanceof ICLanguageSettingEntry)) {
                return null;
            }
            ICLanguageSettingEntry le = (ICLanguageSettingEntry)element;
            if (le.isBuiltIn()) {
                return null;
            }
            if (le.isReadOnly()) {
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
            }
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        }
    }
}

