/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.ChangeConfigAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class ChangeBuildConfigActionBase {
    protected HashSet<IProject> fProjects = new HashSet();

    protected void fillMenu(Menu menu) {
        MenuItem[] items;
        if (menu == null) {
            return;
        }
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item2 = menuItemArray[n2];
            item2.dispose();
            ++n2;
        }
        ArrayList<String> configNames = new ArrayList<String>();
        Iterator<IProject> projIter = this.fProjects.iterator();
        String sCurrentConfig = null;
        boolean bCurrentConfig = true;
        while (projIter.hasNext()) {
            ICConfigurationDescription[] cfgDescs = this.getCfgs(projIter.next());
            String sActiveConfig = null;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescs;
            int n3 = cfgDescs.length;
            int n4 = 0;
            while (n4 < n3) {
                ICConfigurationDescription cfgDesc = iCConfigurationDescriptionArray[n4];
                String s = cfgDesc.getName();
                if (!configNames.contains(s)) {
                    configNames.add(s);
                }
                if (cfgDesc.isActive()) {
                    sActiveConfig = s;
                }
                ++n4;
            }
            if (!bCurrentConfig) continue;
            if (sCurrentConfig == null) {
                sCurrentConfig = sActiveConfig;
                continue;
            }
            if (sCurrentConfig.equals(sActiveConfig)) continue;
            bCurrentConfig = false;
        }
        Iterator confIter = configNames.iterator();
        int accel = 0;
        while (confIter.hasNext()) {
            String sName = (String)confIter.next();
            String sDesc = null;
            projIter = this.fProjects.iterator();
            boolean commonName = true;
            boolean commonDesc = true;
            boolean firstProj = true;
            while (projIter.hasNext()) {
                ICConfigurationDescription[] cfgDescs = this.getCfgs(projIter.next());
                int i = 0;
                while (i < cfgDescs.length) {
                    if (cfgDescs[i].getName().equals(sName)) {
                        String sNewDesc = cfgDescs[i].getDescription();
                        if (sNewDesc != null && sNewDesc.length() == 0) {
                            sNewDesc = null;
                        }
                        if (!commonDesc) break;
                        if (firstProj) {
                            sDesc = sNewDesc;
                            firstProj = false;
                            break;
                        }
                        if ((sNewDesc != null || sDesc == null) && (sNewDesc == null || sNewDesc.equals(sDesc))) break;
                        commonDesc = false;
                        break;
                    }
                    ++i;
                }
                if (i != cfgDescs.length) continue;
                commonName = false;
                break;
            }
            if (!commonName) continue;
            StringBuffer builder = new StringBuffer(sName);
            if (commonDesc) {
                if (sDesc != null) {
                    builder.append(" (");
                    builder.append(sDesc);
                    builder.append(")");
                }
            } else {
                builder.append(" (...)");
            }
            IAction action = this.makeAction(sName, builder, accel);
            if (bCurrentConfig && sCurrentConfig != null && sCurrentConfig.equals(sName)) {
                action.setChecked(true);
            }
            ActionContributionItem item = new ActionContributionItem(action);
            item.fill(menu, -1);
            ++accel;
        }
    }

    protected IAction makeAction(String sName, StringBuffer builder, int accel) {
        return new ChangeConfigAction(this.fProjects, sName, builder.toString(), accel + 1);
    }

    protected void onSelectionChanged(IAction action, ISelection selection) {
        this.fProjects.clear();
        boolean badObject = false;
        if (selection != null) {
            IEditorPart epart;
            IResource resource;
            IWorkbenchPart part;
            IWorkbenchPage page;
            IWorkbenchWindow window;
            if (selection instanceof IStructuredSelection) {
                Object o;
                IWorkbenchPart part2;
                IWorkbenchPage page2;
                if (selection.isEmpty() && (page2 = CUIPlugin.getActivePage()) != null && (part2 = page2.getActivePart()) != null && (o = part2.getAdapter(IResource.class)) != null && o instanceof IResource) {
                    this.fProjects.add(((IResource)o).getProject());
                }
                for (Object selItem : (IStructuredSelection)selection) {
                    Object adapter;
                    IProject project = null;
                    if (selItem instanceof ICElement) {
                        ICProject cproject = ((ICElement)selItem).getCProject();
                        if (cproject != null) {
                            project = cproject.getProject();
                        }
                    } else if (selItem instanceof IResource) {
                        project = ((IResource)selItem).getProject();
                    } else if (selItem instanceof IncludeRefContainer) {
                        ICProject fCProject = ((IncludeRefContainer)((Object)selItem)).getCProject();
                        if (fCProject != null) {
                            project = fCProject.getProject();
                        }
                    } else if (selItem instanceof IncludeReferenceProxy) {
                        ICProject fCProject;
                        IncludeRefContainer irc = ((IncludeReferenceProxy)((Object)selItem)).getIncludeRefContainer();
                        if (irc != null && (fCProject = irc.getCProject()) != null) {
                            project = fCProject.getProject();
                        }
                    } else if (selItem instanceof IAdaptable && (adapter = ((IAdaptable)selItem).getAdapter(IProject.class)) != null && adapter instanceof IProject) {
                        project = (IProject)adapter;
                    }
                    if (project != null) {
                        if (!CoreModel.getDefault().isNewStyleProject(project)) {
                            project = null;
                        } else {
                            ICConfigurationDescription[] tmp = this.getCfgs(project);
                            if (tmp == null || tmp.length == 0) {
                                project = null;
                            }
                        }
                    }
                    if (project != null) {
                        this.fProjects.add(project);
                        continue;
                    }
                    badObject = true;
                    break;
                }
            } else if (selection instanceof ITextSelection && (window = CUIPlugin.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) instanceof IEditorPart && (resource = (IResource)(epart = (IEditorPart)part).getEditorInput().getAdapter(IResource.class)) != null) {
                IProject project = resource.getProject();
                boolean bl = badObject = project == null || !CoreModel.getDefault().isNewStyleProject(project);
                if (!badObject) {
                    this.fProjects.add(project);
                }
            }
        }
        boolean enable = false;
        if (!badObject && !this.fProjects.isEmpty()) {
            ICConfigurationDescription[] firstConfigs;
            Iterator<IProject> iter = this.fProjects.iterator();
            ICConfigurationDescription[] iCConfigurationDescriptionArray = firstConfigs = this.getCfgs(iter.next());
            int n = firstConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription firstConfig = iCConfigurationDescriptionArray[n2];
                boolean common = true;
                Iterator<IProject> iter2 = this.fProjects.iterator();
                while (iter2.hasNext()) {
                    ICConfigurationDescription[] currentConfigs = this.getCfgs(iter2.next());
                    int j = 0;
                    while (j < currentConfigs.length) {
                        if (firstConfig.getName().equals(currentConfigs[j].getName())) break;
                        ++j;
                    }
                    if (j != currentConfigs.length) continue;
                    common = false;
                    break;
                }
                if (common) {
                    enable = true;
                    break;
                }
                ++n2;
            }
        }
        action.setEnabled(enable);
    }

    private ICConfigurationDescription[] getCfgs(IProject prj) {
        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(prj, false);
        if (prjd == null) {
            return null;
        }
        ICConfigurationDescription[] tmp = prjd.getConfigurations();
        if (tmp == null) {
            return null;
        }
        return prjd.getConfigurations();
    }
}

