/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import java.util.Comparator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementSorter
extends ViewerSorter {
    protected static final int CMODEL = 0;
    protected static final int PROJECTS = 10;
    protected static final int BINARYCONTAINER = 12;
    protected static final int ARCHIVECONTAINER = 13;
    protected static final int INCLUDEREFCONTAINER = 14;
    protected static final int LIBRARYREFCONTAINER = 15;
    protected static final int SOURCEROOTS = 16;
    protected static final int CCONTAINERS = 17;
    protected static final int LIBRARYREFERENCES = 18;
    protected static final int INCLUDEREFERENCES = 19;
    protected static final int TRANSLATIONUNIT_HEADERS = 20;
    protected static final int TRANSLATIONUNIT_SOURCE = 21;
    protected static final int TRANSLATIONUNITS = 22;
    protected static final int BINARIES = 23;
    protected static final int ARCHIVES = 24;
    protected static final int INCLUDES = 28;
    protected static final int MACROS = 29;
    protected static final int USINGS = 30;
    protected static final int NAMESPACES = 32;
    protected static final int NAMESPACES_RESERVED = 33;
    protected static final int NAMESPACES_SYSTEM = 34;
    protected static final int TYPES = 35;
    protected static final int VARIABLEDECLARATIONS = 36;
    protected static final int FUNCTIONDECLARATIONS = 37;
    protected static final int VARIABLES = 38;
    protected static final int VARIABLES_RESERVED = 39;
    protected static final int VARIABLES_SYSTEM = 40;
    protected static final int FUNCTIONS = 41;
    protected static final int FUNCTIONS_RESERVED = 42;
    protected static final int FUNCTIONS_SYSTEM = 43;
    protected static final int METHODDECLARATIONS = 44;
    protected static final int CELEMENTS = 100;
    protected static final int CELEMENTS_RESERVED = 101;
    protected static final int CELEMENTS_SYSTEM = 102;
    protected static final int RESOURCEFOLDERS = 200;
    protected static final int RESOURCES = 201;
    protected static final int STORAGE = 202;
    protected static final int OTHERS = 500;
    private static final int NORMAL = 0;
    private static final int RESERVED = 1;
    private static final int SYSTEM = 2;
    private static final int STATIC_MEMBER = 0;
    private static final int CONSTRUCTOR = 1;
    private static final int DESTRUCTOR = 2;
    private static final int MEMBER = 3;
    private boolean fSeparateHeaderAndSource;

    public CElementSorter() {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        this.fSeparateHeaderAndSource = store.getBoolean("org.eclipse.cdt.ui.cview.separateheaderandsource");
    }

    public int category(Object element) {
        if (element instanceof ICElement) {
            ICElement cElement = (ICElement)element;
            switch (cElement.getElementType()) {
                case 10: {
                    return 0;
                }
                case 11: {
                    return 10;
                }
                case 12: {
                    if (element instanceof ISourceRoot) {
                        return 16;
                    }
                    return 17;
                }
                case 30: {
                    if (element instanceof IBinaryContainer) {
                        return 12;
                    }
                    if (element instanceof IArchiveContainer) {
                        return 13;
                    }
                    if (element instanceof ILibraryReference) {
                        return 18;
                    }
                    if (element instanceof IIncludeReference) {
                        return 19;
                    }
                    return 17;
                }
                case 60: {
                    if (this.fSeparateHeaderAndSource) {
                        if (CoreModel.isValidHeaderUnitName((IProject)cElement.getCProject().getProject(), (String)cElement.getElementName())) {
                            return 20;
                        }
                        if (CoreModel.isValidSourceUnitName((IProject)cElement.getCProject().getProject(), (String)cElement.getElementName())) {
                            return 21;
                        }
                    }
                    return 22;
                }
                case 75: {
                    return 28;
                }
                case 79: {
                    return 29;
                }
                case 61: {
                    return 32 + this.getNameKind(cElement.getElementName());
                }
                case 62: {
                    return 30;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 80: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: {
                    return 35;
                }
                case 73: 
                case 88: {
                    return 37;
                }
                case 71: 
                case 90: {
                    return 44;
                }
                case 77: {
                    return 36;
                }
                case 72: 
                case 76: 
                case 92: {
                    return 38 + this.getNameKind(cElement.getElementName());
                }
                case 70: 
                case 74: 
                case 89: 
                case 91: {
                    return 41 + this.getNameKind(cElement.getElementName());
                }
                case 18: {
                    return 24;
                }
                case 14: {
                    return 23;
                }
            }
            return 100 + this.getNameKind(cElement.getElementName());
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            switch (resource.getType()) {
                case 4: {
                    return 10;
                }
                case 2: {
                    return 200;
                }
            }
            return 201;
        }
        if (element instanceof IStorage) {
            return 202;
        }
        if (element instanceof CElementGrouping) {
            int type = ((CElementGrouping)((Object)element)).getType();
            switch (type) {
                case 1: {
                    return 28;
                }
                case 256: {
                    return 35;
                }
                case 16: {
                    return 32;
                }
                case 4096: {
                    return 15;
                }
                case 65536: {
                    return 14;
                }
            }
        }
        return 500;
    }

    private int getNameKind(String name) {
        int length = name.length();
        if (length > 0 && name.charAt(0) == '_') {
            if (length > 1 && name.charAt(1) == '_') {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        String name2;
        int idx;
        String name1;
        String ns1;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        Comparator comparator = this.getComparator();
        if (cat1 == 10) {
            IWorkbenchAdapter a1 = (IWorkbenchAdapter)((IAdaptable)e1).getAdapter(IWorkbenchAdapter.class);
            IWorkbenchAdapter a2 = (IWorkbenchAdapter)((IAdaptable)e2).getAdapter(IWorkbenchAdapter.class);
            return comparator.compare(a1.getLabel(e1), a2.getLabel(e2));
        }
        if (cat1 == 16) {
            int p2;
            int p1;
            ISourceRoot root1 = this.getSourceRoot(e1);
            ISourceRoot root2 = this.getSourceRoot(e2);
            if (root1 == null) {
                if (root2 == null) {
                    return 0;
                }
                return 1;
            }
            if (root2 == null) {
                return -1;
            }
            if (!root1.getPath().equals((Object)root2.getPath()) && (p1 = this.getPathEntryIndex(root1)) != (p2 = this.getPathEntryIndex(root2))) {
                return p1 - p2;
            }
        }
        if (cat1 == 201 || cat1 == 200 || cat1 == 202 || cat1 == 500) {
            return this.compareWithLabelProvider(viewer, e1, e2);
        }
        String ns2 = ns1 = "";
        if (e1 instanceof ICElement) {
            name1 = ((ICElement)e1).getElementName();
            idx = name1.lastIndexOf("::");
            if (idx >= 0) {
                ns1 = name1.substring(0, idx);
                name1 = name1.substring(idx + 2);
            }
            if (name1.length() > 0 && name1.charAt(0) == '~') {
                name1 = name1.substring(1);
            }
        } else {
            name1 = e1.toString();
        }
        if (e2 instanceof ICElement) {
            name2 = ((ICElement)e2).getElementName();
            idx = name2.lastIndexOf("::");
            if (idx >= 0) {
                ns2 = name2.substring(0, idx);
                name2 = name2.substring(idx + 2);
            }
            if (name2.length() > 0 && name2.charAt(0) == '~') {
                name2 = name2.substring(1);
            }
        } else {
            name2 = e2.toString();
        }
        if ((result = comparator.compare(ns1, ns2)) != 0) {
            return result;
        }
        if (e1 instanceof IMethodDeclaration && e2 instanceof IMethodDeclaration) {
            result = this.getMethodKind((IMethodDeclaration)e1) - this.getMethodKind((IMethodDeclaration)e2);
        } else if (e1 instanceof IMember && e2 instanceof IMember) {
            result = this.getMemberKind((IMember)e1) - this.getMemberKind((IMember)e2);
        }
        if (result != 0) {
            return result;
        }
        result = comparator.compare(name1, name2);
        if (result != 0) {
            return result;
        }
        return result;
    }

    private int getMethodKind(IMethodDeclaration method) {
        block6: {
            block5: {
                try {
                    if (!method.isStatic()) break block5;
                    return 0;
                }
                catch (CModelException cModelException) {}
            }
            if (!method.isConstructor()) break block6;
            return 1;
        }
        if (method.isDestructor()) {
            return 2;
        }
        return 3;
    }

    private int getMemberKind(IMember member) {
        try {
            if (member.isStatic()) {
                return 0;
            }
        }
        catch (CModelException cModelException) {}
        return 3;
    }

    private ISourceRoot getSourceRoot(Object element) {
        ICElement celement = (ICElement)element;
        while (!(celement instanceof ISourceRoot) && celement != null) {
            celement = celement.getParent();
        }
        return (ISourceRoot)celement;
    }

    private int compareWithLabelProvider(Viewer viewer, Object e1, Object e2) {
        IBaseLabelProvider prov;
        if (viewer instanceof ContentViewer && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            ILabelProvider lprov = (ILabelProvider)prov;
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            if (name1 != null && name2 != null) {
                Comparator comparator = this.getComparator();
                return comparator.compare(name1, name2);
            }
        }
        return 0;
    }

    private int getPathEntryIndex(ISourceRoot root) {
        try {
            IPath rootPath = root.getPath();
            ISourceRoot[] roots = root.getCProject().getSourceRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getPath().equals((Object)rootPath)) {
                    return i;
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return Integer.MAX_VALUE;
    }
}

