/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class CElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int TEMPLATE = 1;
    public static final int CONSTANT = 2;
    public static final int VOLATILE = 4;
    public static final int STATIC = 8;
    @Deprecated
    public static final int RUNNABLE = 16;
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    @Deprecated
    public static final int OVERRIDES = 128;
    @Deprecated
    public static final int IMPLEMENTS = 256;
    public static final int RELATES_TO = 512;
    public static final int RELATES_TO_MULTIPLE = 1024;
    public static final int REFERENCED_BY = 2048;
    public static final int RECURSIVE_RELATION = 4096;
    public static final int SYSTEM_INCLUDE = 8192;
    public static final int DEFINES = 16384;
    public static final int INACTIVE = 32768;
    public static final int READ_ACCESS = 65536;
    public static final int WRITE_ACCESS = 131072;
    public static final int EXTERNAL_FILE = 262144;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public CElementImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.fFlags = adornments;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!CElementImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        CElementImageDescriptor other = (CElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.fBaseImage.getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
        this.drawTopLeft();
    }

    private void drawTopRight() {
        int x = this.getSize().x;
        ImageData data = null;
        if ((this.fFlags & 4) != 0) {
            data = CPluginImages.DESC_OVR_VOLATILE.getImageData();
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.fFlags & 2) != 0) {
            data = CPluginImages.DESC_OVR_CONSTANT.getImageData();
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.fFlags & 8) != 0) {
            data = CPluginImages.DESC_OVR_STATIC.getImageData();
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.fFlags & 1) != 0) {
            data = CPluginImages.DESC_OVR_TEMPLATE.getImageData();
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.fFlags & 0x2000) != 0) {
            data = CPluginImages.DESC_OVR_SYSTEM_INCLUDE.getImageData();
            this.drawImage(data, x -= data.width, 0);
        }
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        int x = size.x;
        ImageData data = null;
        if ((this.fFlags & 0x1000) != 0) {
            data = CPluginImages.DESC_OVR_REC_RELATESTO.getImageData();
            this.drawImage(data, x -= data.width, size.y - data.height);
        } else if ((this.fFlags & 0x200) != 0) {
            data = CPluginImages.DESC_OVR_RELATESTO.getImageData();
            this.drawImage(data, x -= data.width, size.y - data.height);
        } else if ((this.fFlags & 0x400) != 0) {
            data = CPluginImages.DESC_OVR_RELATESTOMULTIPLE.getImageData();
            this.drawImage(data, x -= data.width, size.y - data.height);
        } else if ((this.fFlags & 0x800) != 0) {
            data = CPluginImages.DESC_OVR_REFERENCEDBY.getImageData();
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
    }

    private void drawTopLeft() {
        boolean isWriteAccess;
        ImageData data = null;
        if ((this.fFlags & 0x4000) != 0) {
            data = CPluginImages.DESC_OVR_DEFINES.getImageData();
            this.drawImage(data, 0, 0);
        }
        if ((this.fFlags & 0x8000) != 0) {
            data = CPluginImages.DESC_OVR_INACTIVE.getImageData();
            this.drawImage(data, 0, 0);
        }
        boolean isReadAccess = (this.fFlags & 0x10000) != 0;
        boolean bl = isWriteAccess = (this.fFlags & 0x20000) != 0;
        if (isReadAccess) {
            data = isWriteAccess ? CPluginImages.DESC_OVR_READ_WRITE_ACCESS.getImageData() : CPluginImages.DESC_OVR_READ_ACCESS.getImageData();
            this.drawImage(data, 0, 0);
        } else if (isWriteAccess) {
            data = CPluginImages.DESC_OVR_WRITE_ACCESS.getImageData();
            this.drawImage(data, 0, 0);
        }
        if ((this.fFlags & 0x40000) != 0) {
            data = CPluginImages.DESC_OVR_EXTERNAL_FILE.getImageData();
            this.drawImage(data, 0, 0);
        }
    }

    private void drawBottomLeft() {
        Point size = this.getSize();
        int x = 0;
        ImageData data = null;
        if ((this.fFlags & 0x40) != 0) {
            data = CPluginImages.DESC_OVR_ERROR.getImageData();
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
        if ((this.fFlags & 0x20) != 0) {
            data = CPluginImages.DESC_OVR_WARNING.getImageData();
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
    }
}

