/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTreeViewer
extends ProblemTreeViewer {
    private ExpansionJob fExpansionJob = null;
    private SelectionJob fSelectionJob = null;

    public RemoteTreeViewer(Composite parent) {
        super(parent);
        this.addDisposeListener();
        this.fExpansionJob = new ExpansionJob();
        this.fSelectionJob = new SelectionJob();
    }

    public RemoteTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener();
        this.fExpansionJob = new ExpansionJob();
        this.fSelectionJob = new SelectionJob();
    }

    public RemoteTreeViewer(Tree tree) {
        super(tree);
        this.addDisposeListener();
        this.fExpansionJob = new ExpansionJob();
        this.fSelectionJob = new SelectionJob();
    }

    private void addDisposeListener() {
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RemoteTreeViewer.this.cancelJobs();
            }
        });
    }

    protected void runDeferredUpdates() {
        if (this.fExpansionJob != null) {
            this.fExpansionJob.schedule();
        }
        if (this.fSelectionJob != null) {
            this.fSelectionJob.schedule();
        }
    }

    protected void validateDeferredUpdates(Object element) {
        if (element != null) {
            if (this.fExpansionJob != null) {
                this.fExpansionJob.validate(element);
            }
            if (this.fSelectionJob != null) {
                this.fSelectionJob.validate(element);
            }
        }
    }

    public synchronized void add(Object parentElement, Object childElement) {
        super.add(parentElement, childElement);
        this.runDeferredUpdates();
    }

    public synchronized void add(Object parentElement, Object[] childElements) {
        super.add(parentElement, childElements);
        this.runDeferredUpdates();
    }

    public synchronized void remove(Object element) {
        this.validateDeferredUpdates(element);
        super.remove(element);
    }

    public synchronized void remove(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.validateDeferredUpdates(elements[i]);
            ++i;
        }
        super.remove(elements);
    }

    public void cancelJobs() {
        this.cancel((Job)this.fSelectionJob);
        this.cancel((Job)this.fExpansionJob);
    }

    public synchronized void deferExpansion(Object element) {
        TreeItem treeItem = (TreeItem)this.findItem(element);
        if (treeItem == null) {
            this.fExpansionJob.setDeferredExpansion(element);
            this.fExpansionJob.schedule();
        } else if (!this.getExpanded((Item)treeItem)) {
            this.fExpansionJob.setDeferredExpansion(element);
            this.fExpansionJob.schedule();
        }
    }

    public synchronized void deferSelection(IStructuredSelection selection) {
        if (this.fSelectionJob == null) {
            this.fSelectionJob = new SelectionJob();
        }
        this.fSelectionJob.setDeferredSelection(selection);
        this.fSelectionJob.schedule();
    }

    public IStructuredSelection getDeferredSelection() {
        if (this.fSelectionJob != null) {
            return this.fSelectionJob.selection;
        }
        return null;
    }

    private void cancel(Job job) {
        if (job != null) {
            job.cancel();
        }
    }

    private void addAllParents(List<Object> list, Object element) {
        Object parent;
        IAdaptable adaptable;
        IWorkbenchAdapter adapter;
        if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)(adaptable = (IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null && (parent = adapter.getParent(element)) != null) {
            list.add(0, parent);
            if (!(parent instanceof ITranslationUnit)) {
                this.addAllParents(list, parent);
            }
        }
    }

    public Object[] filter(Object[] elements) {
        return super.filter(elements);
    }

    public Object[] getCurrentChildren(Object parent) {
        Widget widget = this.findItem(parent);
        if (widget != null) {
            Item[] items = this.getChildren(widget);
            Object[] children = new Object[items.length];
            int i = 0;
            while (i < children.length) {
                Object data = items[i].getData();
                if (data == null) {
                    return null;
                }
                children[i] = data;
                ++i;
            }
            return children;
        }
        return null;
    }

    public synchronized void prune(Object parent, final int offset) {
        Item[] currentChildren;
        Widget widget = this.findItem(parent);
        if (widget != null && offset < (currentChildren = this.getChildren(widget)).length) {
            this.preservingSelection(new Runnable(){

                public void run() {
                    int i = offset;
                    while (i < currentChildren.length) {
                        if (currentChildren[i].getData() != null) {
                            RemoteTreeViewer.this.disassociate(currentChildren[i]);
                        }
                        currentChildren[i].dispose();
                        ++i;
                    }
                }
            });
        }
    }

    public synchronized void replace(final Object parent, final Object[] children, final int offset) {
        this.preservingSelection(new Runnable(){

            public void run() {
                Widget widget = RemoteTreeViewer.this.findItem(parent);
                if (widget == null) {
                    RemoteTreeViewer.this.add(parent, children);
                } else {
                    int pos = offset;
                    Item[] currentChildren = RemoteTreeViewer.this.getChildren(widget);
                    if (pos >= currentChildren.length) {
                        RemoteTreeViewer.this.add(parent, children);
                    } else {
                        int i = 0;
                        while (i < children.length) {
                            Object child = children[i];
                            if (pos < currentChildren.length) {
                                Item item = currentChildren[pos];
                                Object data = item.getData();
                                if (!child.equals(data)) {
                                    RemoteTreeViewer.this.internalRefresh((Widget)item, child, true, true);
                                } else {
                                    RemoteTreeViewer.this.doUpdateItem(item, child);
                                    RemoteTreeViewer.this.updatePlus(item, child);
                                }
                            } else {
                                int numLeft = children.length - i;
                                if (numLeft > 1) {
                                    Object[] others = new Object[numLeft];
                                    System.arraycopy(children, i, others, 0, numLeft);
                                    RemoteTreeViewer.this.add(parent, others);
                                    break;
                                }
                                RemoteTreeViewer.this.add(parent, child);
                                break;
                            }
                            ++pos;
                            ++i;
                        }
                    }
                }
                RemoteTreeViewer.this.runDeferredUpdates();
            }
        });
    }

    class ExpansionJob
    extends UIJob {
        private Object element;
        private List<Object> parents;

        public ExpansionJob() {
            super("Expansion");
            this.parents = new ArrayList<Object>();
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (RemoteTreeViewer.this.getControl().isDisposed() || this.element == null) {
                return Status.OK_STATUS;
            }
            RemoteTreeViewer remoteTreeViewer = RemoteTreeViewer.this;
            synchronized (remoteTreeViewer) {
                Widget item;
                boolean allParentsExpanded = true;
                Iterator<Object> iterator = this.parents.iterator();
                while (iterator.hasNext() && !monitor.isCanceled()) {
                    Object parent = iterator.next();
                    Widget item2 = RemoteTreeViewer.this.findItem(parent);
                    if (item2 != null) {
                        RemoteTreeViewer.this.expandToLevel(parent, 1);
                        continue;
                    }
                    allParentsExpanded = false;
                    break;
                }
                if (allParentsExpanded && (item = RemoteTreeViewer.this.findItem(this.element)) != null) {
                    if (RemoteTreeViewer.this.isExpandable(this.element)) {
                        RemoteTreeViewer.this.expandToLevel(this.element, 1);
                    }
                    this.element = null;
                    this.parents.clear();
                    return Status.OK_STATUS;
                }
                return Status.OK_STATUS;
            }
        }

        public void validate(Object object) {
            if (this.element != null && (this.element.equals(object) || this.parents.contains(object))) {
                this.cancel();
                this.element = null;
            }
        }

        public void setDeferredExpansion(Object toExpand) {
            this.element = toExpand;
            this.parents.clear();
            RemoteTreeViewer.this.addAllParents(this.parents, this.element);
        }
    }

    class SelectionJob
    extends UIJob {
        private IStructuredSelection selection;
        private Object first;
        private List<Object> parents;

        public SelectionJob() {
            super("Selection");
            this.parents = new ArrayList<Object>();
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (RemoteTreeViewer.this.getControl().isDisposed() || this.selection == null) {
                return Status.OK_STATUS;
            }
            RemoteTreeViewer remoteTreeViewer = RemoteTreeViewer.this;
            synchronized (remoteTreeViewer) {
                boolean allParentsExpanded = true;
                Iterator<Object> iterator = this.parents.iterator();
                while (iterator.hasNext() && !monitor.isCanceled()) {
                    Object parent = iterator.next();
                    Widget item = RemoteTreeViewer.this.findItem(parent);
                    if (item != null) {
                        RemoteTreeViewer.this.expandToLevel(parent, 1);
                        continue;
                    }
                    allParentsExpanded = false;
                    break;
                }
                if (allParentsExpanded && RemoteTreeViewer.this.findItem(this.first) != null) {
                    RemoteTreeViewer.this.setSelection((ISelection)this.selection, true);
                    this.selection = null;
                    this.first = null;
                    this.parents.clear();
                    return Status.OK_STATUS;
                }
                return Status.OK_STATUS;
            }
        }

        public void setDeferredSelection(IStructuredSelection sel) {
            this.selection = sel;
            this.first = this.selection.getFirstElement();
            this.parents.clear();
            RemoteTreeViewer.this.addAllParents(this.parents, this.first);
        }

        public void validate(Object object) {
            if (this.first != null && (this.first.equals(object) || this.parents.contains(object))) {
                this.cancel();
                this.selection = null;
            }
        }
    }
}

