/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction.proposals;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.cdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.cdt.internal.corext.util.Resources;
import org.eclipse.cdt.internal.corext.util.Strings;
import org.eclipse.cdt.internal.ui.CUIStatus;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.cdt.internal.ui.text.correction.proposals.ChangeCorrectionProposal;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.viewsupport.LinkedProposalModelPresenter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.refactoring.CTextFileChange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TUCorrectionProposal
extends ChangeCorrectionProposal {
    private ITranslationUnit fTranslationUnit;
    private LinkedProposalModel fLinkedProposalModel;
    private final int surroundLines = 1;

    public TUCorrectionProposal(String name, ITranslationUnit tu, TextChange change, int relevance, Image image) {
        super(name, (Change)change, relevance, image);
        if (tu == null) {
            throw new IllegalArgumentException("Translation unit must not be null");
        }
        this.fTranslationUnit = tu;
        this.fLinkedProposalModel = null;
    }

    protected TUCorrectionProposal(String name, ITranslationUnit tu, int relevance, Image image) {
        this(name, tu, null, relevance, image);
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
    }

    protected LinkedProposalModel getLinkedProposalModel() {
        if (this.fLinkedProposalModel == null) {
            this.fLinkedProposalModel = new LinkedProposalModel();
        }
        return this.fLinkedProposalModel;
    }

    public void setLinkedProposalModel(LinkedProposalModel model) {
        this.fLinkedProposalModel = model;
    }

    public String getAdditionalProposalInfo() {
        StringBuffer buf = new StringBuffer();
        try {
            TextChange change = this.getTextChange();
            change.setKeepPreviewEdits(true);
            IDocument previewContent = change.getPreviewDocument((IProgressMonitor)new NullProgressMonitor());
            TextEdit rootEdit = change.getPreviewEdit(change.getEdit());
            class EditAnnotator
            extends TextEditVisitor {
                private int fWrittenToPos = 0;
                private final /* synthetic */ IDocument val$previewContent;
                private final /* synthetic */ StringBuffer val$buf;

                EditAnnotator(IDocument iDocument, StringBuffer stringBuffer) {
                    this.val$previewContent = iDocument;
                    this.val$buf = stringBuffer;
                }

                public void unchangedUntil(int pos) {
                    if (pos > this.fWrittenToPos) {
                        TUCorrectionProposal.this.appendContent(this.val$previewContent, this.fWrittenToPos, pos, this.val$buf, true);
                        this.fWrittenToPos = pos;
                    }
                }

                public boolean visit(MoveTargetEdit edit) {
                    return true;
                }

                public boolean visit(CopyTargetEdit edit) {
                    return true;
                }

                public boolean visit(InsertEdit edit) {
                    return this.rangeAdded((TextEdit)edit);
                }

                public boolean visit(ReplaceEdit edit) {
                    if (edit.getLength() > 0) {
                        return this.rangeAdded((TextEdit)edit);
                    }
                    return this.rangeRemoved((TextEdit)edit);
                }

                public boolean visit(MoveSourceEdit edit) {
                    return this.rangeRemoved((TextEdit)edit);
                }

                public boolean visit(DeleteEdit edit) {
                    return this.rangeRemoved((TextEdit)edit);
                }

                private boolean rangeRemoved(TextEdit edit) {
                    this.unchangedUntil(edit.getOffset());
                    return false;
                }

                private boolean rangeAdded(TextEdit edit) {
                    this.unchangedUntil(edit.getOffset());
                    this.val$buf.append("<b>");
                    TUCorrectionProposal.this.appendContent(this.val$previewContent, edit.getOffset(), edit.getExclusiveEnd(), this.val$buf, false);
                    this.val$buf.append("</b>");
                    this.fWrittenToPos = edit.getExclusiveEnd();
                    return false;
                }
            }
            EditAnnotator ea = new EditAnnotator(previewContent, buf);
            rootEdit.accept((TextEditVisitor)ea);
            ea.unchangedUntil(previewContent.getLength());
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return buf.toString();
    }

    private void appendContent(IDocument text, int startOffset, int endOffset, StringBuffer buf, boolean surroundLinesOnly) {
        try {
            int startLine = text.getLineOfOffset(startOffset);
            int endLine = text.getLineOfOffset(endOffset);
            boolean dotsAdded = false;
            if (surroundLinesOnly && startOffset == 0) {
                startLine = Math.max(endLine - 1, 0);
                buf.append("...<br>");
                dotsAdded = true;
            }
            int i = startLine;
            while (i <= endLine) {
                if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                    if (!dotsAdded) {
                        buf.append("...<br>");
                        dotsAdded = true;
                    } else if (endOffset == text.getLength()) {
                        return;
                    }
                } else {
                    IRegion lineInfo = text.getLineInformation(i);
                    int start = lineInfo.getOffset();
                    int end = start + lineInfo.getLength();
                    int from = Math.max(start, startOffset);
                    int to = Math.min(end, endOffset);
                    String content = text.get(from, to - from);
                    if (!surroundLinesOnly || from != start || !Strings.containsOnlyWhitespaces(content)) {
                        int k = 0;
                        while (k < content.length()) {
                            char ch = content.charAt(k);
                            if (ch == '<') {
                                buf.append("&lt;");
                            } else if (ch == '>') {
                                buf.append("&gt;");
                            } else {
                                buf.append(ch);
                            }
                            ++k;
                        }
                        if (to == end && to != endOffset) {
                            buf.append("<br>");
                        }
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void apply(IDocument document) {
        try {
            ITranslationUnit unit = this.getTranslationUnit();
            IEditorPart part = null;
            if (unit.getResource().exists()) {
                IWorkbenchPage page;
                boolean canEdit = this.performValidateEdit(unit);
                if (!canEdit) {
                    return;
                }
                part = EditorUtility.isOpenInEditor(unit);
                if (part == null && (part = EditorUtility.openInEditor(unit)) != null) {
                    document = CUIPlugin.getDefault().getDocumentProvider().getDocument(part.getEditorInput());
                }
                if ((page = CUIPlugin.getActivePage()) != null && part != null) {
                    page.bringToTop((IWorkbenchPart)part);
                }
                if (part != null) {
                    part.setFocus();
                }
            }
            this.performChange(part, document);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, CorrectionMessages.TUCorrectionProposal_error_title, CorrectionMessages.TUCorrectionProposal_error_message);
        }
    }

    private boolean performValidateEdit(ITranslationUnit unit) {
        IStatus status = Resources.makeCommittable(unit.getResource(), (Object)CUIPlugin.getActiveWorkbenchShell());
        if (!status.isOK()) {
            String label = CorrectionMessages.TUCorrectionProposal_error_title;
            String message = CorrectionMessages.TUCorrectionProposal_error_message;
            ErrorDialog.openError((Shell)CUIPlugin.getActiveWorkbenchShell(), (String)label, (String)message, (IStatus)status);
            return false;
        }
        return true;
    }

    protected void performChange(IEditorPart part, IDocument document) throws CoreException {
        try {
            super.performChange(part, document);
            if (part == null) {
                return;
            }
            if (this.fLinkedProposalModel != null) {
                LinkedProposalPositionGroup.PositionInformation endPosition;
                if (this.fLinkedProposalModel.hasLinkedPositions() && part instanceof CEditor) {
                    ISourceViewer viewer = ((CEditor)part).getViewer();
                    new LinkedProposalModelPresenter().enterLinkedMode((ITextViewer)viewer, part, this.fLinkedProposalModel);
                } else if (part instanceof ITextEditor && (endPosition = this.fLinkedProposalModel.getEndPosition()) != null) {
                    int pos = endPosition.getOffset() + endPosition.getLength();
                    ((ITextEditor)part).selectAndReveal(pos, 0);
                }
            }
        }
        catch (BadLocationException e) {
            throw new CoreException(CUIStatus.createError(4, e));
        }
    }

    protected TextChange createTextChange() throws CoreException {
        CTextFileChange change;
        Document document;
        ITranslationUnit tu = this.getTranslationUnit();
        String name = this.getName();
        if (!tu.getResource().exists()) {
            String source;
            try {
                source = tu.getSource();
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
                source = new String();
            }
            document = new Document(source);
            document.setInitialLineDelimiter(StubUtility.getLineDelimiterUsed((ICElement)tu));
            change = new DocumentChange(name, (IDocument)document);
        } else {
            CTextFileChange tuChange = new CTextFileChange(name, tu);
            tuChange.setSaveMode(4);
            change = tuChange;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        document = change.getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
        this.addEdits((IDocument)document, (TextEdit)rootEdit);
        return change;
    }

    protected final Change createChange() throws CoreException {
        return this.createTextChange();
    }

    public final TextChange getTextChange() throws CoreException {
        return (TextChange)this.getChange();
    }

    public final ITranslationUnit getTranslationUnit() {
        return this.fTranslationUnit;
    }

    public String getPreviewContent() throws CoreException {
        return this.getTextChange().getPreviewContent((IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        try {
            return this.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }
}

