/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class CFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList<IDocument> fDocuments = new LinkedList();
    private final LinkedList<TypedPosition> fPartitions = new LinkedList();

    public void format() {
        super.format();
        IDocument document = this.fDocuments.removeFirst();
        TypedPosition partition = this.fPartitions.removeFirst();
        if (document != null && partition != null) {
            try {
                Map preferences = this.getPreferences();
                TextEdit edit = CodeFormatterUtil.format(8, document.get(), partition.getOffset(), partition.getLength(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)document), preferences);
                if (edit != null) {
                    edit.apply(document);
                }
            }
            catch (MalformedTreeException exception) {
                CUIPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                CUIPlugin.log(exception);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        Object property = context.getProperty((Object)"formatting.context.partition");
        if (property instanceof TypedPosition) {
            this.fPartitions.addLast((TypedPosition)property);
        }
        if ((property = context.getProperty((Object)"formatting.context.medium")) instanceof IDocument) {
            this.fDocuments.addLast((IDocument)property);
        }
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }
}

