/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.ui.refactoring.utils.NamespaceHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class NameHelper {
    private static final String localVariableRegexp = "[a-z_A-Z]\\w*";

    public static boolean isValidLocalVariableName(String name) {
        boolean valid = Pattern.compile(localVariableRegexp).matcher(name).matches();
        return valid;
    }

    public static boolean isKeyword(String name) {
        CharArrayIntMap keywords = new CharArrayIntMap(0, -1);
        Keywords.addKeywordsC((CharArrayIntMap)keywords);
        Keywords.addKeywordsCpp((CharArrayIntMap)keywords);
        Keywords.addKeywordsPreprocessor((CharArrayIntMap)keywords);
        return keywords.containsKey(name.toCharArray());
    }

    public static ICPPASTQualifiedName createQualifiedNameFor(IASTName declaratorName, IFile declarationFile, int selectionOffset, IFile insertFile, int insertLocation) throws CoreException {
        CPPASTQualifiedName qname = new CPPASTQualifiedName();
        IASTName[] declarationNames = NamespaceHelper.getSurroundingNamespace(declarationFile, selectionOffset).getNames();
        IASTName[] implementationNames = NamespaceHelper.getSurroundingNamespace(insertFile, insertLocation).getNames();
        int i = 0;
        while (i < declarationNames.length) {
            if (i >= implementationNames.length) {
                qname.addName(declarationNames[i]);
            } else if (!String.valueOf(declarationNames[i].toCharArray()).equals(String.valueOf(implementationNames[i].toCharArray()))) {
                qname.addName(declarationNames[i]);
            }
            ++i;
        }
        qname.addName(declaratorName.copy());
        return qname;
    }

    public static String trimFieldName(String fieldName) {
        char[] letters = fieldName.toCharArray();
        int start = 0;
        int end = letters.length - 1;
        try {
            while (!Character.isLetter(letters[start]) && start < end) {
                ++start;
            }
            if (Character.isLowerCase(letters[start])) {
                if (!Character.isLetter(letters[start + 1])) {
                    start += 2;
                } else if (Character.isUpperCase(letters[start + 1])) {
                    ++start;
                }
            }
            while (!Character.isLetter(letters[end]) && !Character.isDigit(letters[end]) && start < end) {
                --end;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return new String(letters, start, end - start + 1);
    }

    public static String makeFirstCharUpper(String name) {
        if (Character.isLowerCase(name.charAt(0))) {
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        }
        return name;
    }

    public static String getTypeName(IASTParameterDeclaration parameter) {
        IASTDeclSpecifier parameterDeclSpecifier = parameter.getDeclSpecifier();
        if (parameterDeclSpecifier instanceof ICPPASTNamedTypeSpecifier) {
            return ((ICPPASTNamedTypeSpecifier)parameterDeclSpecifier).getName().getRawSignature();
        }
        return parameterDeclSpecifier.getRawSignature();
    }
}

