/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import org.eclipse.cdt.internal.ui.refactoring.rename.Messages;
import org.eclipse.core.resources.IFile;

public class CRefactoringMatch {
    public static final int POTENTIAL = 0;
    public static final int AST_REFERENCE = 1;
    public static final int AST_REFERENCE_OTHER = 2;
    public static final int AST_REFEREENCE_CONFLICTING = 3;
    public static final int IN_COMMENT = 4;
    private static String[] LABELS = new String[]{Messages.getString("CRefactoringMatch.label.potentialOccurrence"), Messages.getString("CRefactoringMatch.label.occurrence"), "", Messages.getString("CRefactoringMatch.label.potentialOccurrence"), Messages.getString("CRefactoringMatch.label.comment")};
    private IFile fFile;
    private int fOffset;
    private int fLength;
    private int fLocation;
    private int fAstInformation = 0;

    public int getAstInformation() {
        return this.fAstInformation;
    }

    public CRefactoringMatch(IFile file, int offset, int length, int location) {
        this.fFile = file;
        this.fOffset = offset;
        this.fLength = length;
        this.fLocation = location;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setLocation(int location) {
        this.fLocation = location;
    }

    public int getLocation() {
        return this.fLocation;
    }

    public int getLength() {
        return this.fLength;
    }

    public IFile getFile() {
        return this.fFile;
    }

    public void setASTInformation(int val) {
        switch (this.fAstInformation) {
            case 1: 
            case 2: 
            case 3: {
                if (val == this.fAstInformation) break;
                this.fAstInformation = 3;
                break;
            }
            default: {
                this.fAstInformation = val;
            }
        }
    }

    public String getLabel() {
        if (this.fAstInformation == 1) {
            return LABELS[1];
        }
        if (this.isInComment()) {
            return LABELS[4];
        }
        return LABELS[0];
    }

    public boolean isInComment() {
        return (this.fLocation & 2) != 0;
    }
}

