/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.util.HashMap;
import org.eclipse.cdt.internal.ui.preferences.formatter.TranslationUnitPreview;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.ValidatingLabeledTextField;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodRefactoringWizard;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodToImplementConfig;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterInfo;
import org.eclipse.cdt.internal.ui.refactoring.utils.DelayedJobRunner;
import org.eclipse.cdt.ui.refactoring.CTextFileChange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;

public class ParameterNamesInputPage
extends UserInputWizardPage {
    private MethodToImplementConfig config;
    private TranslationUnitPreview translationUnitPreview;
    private DelayedJobRunner delayedPreviewUpdater;
    private ImplementMethodRefactoringWizard wizard;

    public ParameterNamesInputPage(MethodToImplementConfig config, ImplementMethodRefactoringWizard wizard) {
        super(Messages.ParameterNamesInputPage_Title);
        this.config = config;
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite superComposite = new Composite(parent, 0);
        superComposite.setLayout((Layout)new GridLayout());
        Label label = new Label(superComposite, 0);
        label.setText(Messages.ParameterNamesInputPage_CompleteMissingMails);
        label.setLayoutData((Object)new GridData(768));
        ValidatingLabeledTextField validatingLabeledTextField = new ValidatingLabeledTextField(superComposite);
        validatingLabeledTextField.setLayoutData(new GridData(768));
        for (final ParameterInfo actParameterInfo : this.config.getParaHandler().getParameterInfos()) {
            String type = actParameterInfo.getTypeName();
            String content = actParameterInfo.getParameterName();
            boolean readOnly = !actParameterInfo.hasNewName();
            validatingLabeledTextField.addElement(type, content, readOnly, new ValidatingLabeledTextField.Validator(){

                public void hasErrors() {
                    ParameterNamesInputPage.this.setPageComplete(false);
                }

                public void hasNoErrors() {
                    ParameterNamesInputPage.this.setPageComplete(true);
                }

                public boolean isValidInput(String newName) {
                    actParameterInfo.setParameterName(newName);
                    ParameterNamesInputPage.this.updatePreview();
                    return true;
                }
            });
        }
        this.createPreview(superComposite);
        this.setControl((Control)superComposite);
    }

    private InsertEdit getInsertEdit(CompositeChange compositeChange) {
        Change[] changeArray = compositeChange.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTextFileChange textFileChange;
            MultiTextEdit multiEdit;
            Change actChange = changeArray[n2];
            if (actChange instanceof CompositeChange) {
                return this.getInsertEdit((CompositeChange)actChange);
            }
            if (actChange instanceof CTextFileChange && (multiEdit = (MultiTextEdit)(textFileChange = (CTextFileChange)actChange).getEdit()).getChildrenSize() != 0) {
                return (InsertEdit)multiEdit.getChildren()[0];
            }
            ++n2;
        }
        return null;
    }

    public String createFunctionDefinitionSignature() {
        try {
            ModificationCollector collector = new ModificationCollector();
            ((ImplementMethodRefactoring)this.wizard.getRefactoring()).createDefinition(collector, this.config, (IProgressMonitor)new NullProgressMonitor());
            InsertEdit insertEdit = this.getInsertEdit(collector.createFinalChange());
            return insertEdit.getText().trim();
        }
        catch (OperationCanceledException operationCanceledException) {
            return Messages.PreviewGenerationNotPossible;
        }
        catch (CoreException coreException) {
            return Messages.PreviewGenerationNotPossible;
        }
    }

    private void createPreview(Composite superComposite) {
        this.translationUnitPreview = new TranslationUnitPreview(new HashMap<String, String>(), superComposite);
        this.translationUnitPreview.getControl().setLayoutData((Object)new GridData(768));
        Runnable runnable = new Runnable(){

            public void run() {
                this.setPreviewText(Messages.ImplementMethodRefactoringPage_GeneratingPreview);
                this.setPreviewText(ParameterNamesInputPage.this.createFunctionDefinitionSignature());
            }

            private void setPreviewText(final String text) {
                ParameterNamesInputPage.this.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ParameterNamesInputPage.this.translationUnitPreview.setPreviewText(text);
                    }
                });
            }
        };
        this.delayedPreviewUpdater = new DelayedJobRunner(runnable, 500L);
        this.delayedPreviewUpdater.start();
        superComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ParameterNamesInputPage.this.delayedPreviewUpdater.stop();
            }
        });
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        MethodToImplementConfig nextConfig = ((ImplementMethodRefactoring)this.wizard.getRefactoring()).getRefactoringData().getNextConfigNeedingParameterNames(this.config);
        if (nextConfig != null) {
            return this.wizard.getPageForConfig(nextConfig);
        }
        return this.computeSuccessorPage();
    }

    private void updatePreview() {
        if (this.translationUnitPreview == null) {
            return;
        }
        this.delayedPreviewUpdater.runJob();
    }
}

