/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.InsertLocation;
import org.eclipse.cdt.internal.ui.refactoring.utils.DefinitionFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.FileHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDefinitionInsertLocationFinder {
    private static IASTNode findFunctionDefinitionInParents(IASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof IASTFunctionDefinition) {
            if (node.getParent() instanceof ICPPASTTemplateDeclaration) {
                node = node.getParent();
            }
            return node;
        }
        return MethodDefinitionInsertLocationFinder.findFunctionDefinitionInParents(node.getParent());
    }

    private static IASTNode findFirstSurroundingParentFunctionNode(IASTNode definition) {
        IASTNode functionDefinitionInParents = MethodDefinitionInsertLocationFinder.findFunctionDefinitionInParents(definition);
        if (functionDefinitionInParents == null || functionDefinitionInParents.getNodeLocations().length == 0) {
            return null;
        }
        return functionDefinitionInParents;
    }

    public static InsertLocation find(IASTFileLocation methodDeclarationLocation, IASTNode parent, IFile file) throws CoreException {
        IASTName definition = null;
        IASTDeclaration[] declarations = NodeHelper.getDeclarations(parent);
        InsertLocation result = new InsertLocation();
        for (IASTSimpleDeclaration simpleDeclaration : MethodDefinitionInsertLocationFinder.getAllPreviousIASTSimpleDeclarationsFromClassInReverseOrder(declarations, methodDeclarationLocation)) {
            definition = DefinitionFinder.getDefinition(simpleDeclaration, file);
            if (definition == null) continue;
            result.setNodeToInsertAfter(MethodDefinitionInsertLocationFinder.findFirstSurroundingParentFunctionNode((IASTNode)definition));
            result.setInsertFile(FileHelper.getIFilefromIASTNode((IASTNode)definition));
        }
        for (IASTSimpleDeclaration simpleDeclaration : MethodDefinitionInsertLocationFinder.getAllFollowingIASTSimpleDeclarationsFromClass(declarations, methodDeclarationLocation)) {
            definition = DefinitionFinder.getDefinition(simpleDeclaration, file);
            if (definition == null) continue;
            result.setNodeToInsertBefore(MethodDefinitionInsertLocationFinder.findFirstSurroundingParentFunctionNode((IASTNode)definition));
            result.setInsertFile(FileHelper.getIFilefromIASTNode((IASTNode)definition));
        }
        IPath path = file.getLocation().removeFileExtension().addFileExtension("cpp");
        IFile fileForLocation = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (fileForLocation != null && fileForLocation.exists()) {
            result.setInsertFile(fileForLocation);
        }
        return result;
    }

    private static Collection<IASTSimpleDeclaration> getAllPreviousIASTSimpleDeclarationsFromClassInReverseOrder(IASTDeclaration[] declarations, IASTFileLocation methodPosition) {
        ArrayList<IASTSimpleDeclaration> allIASTSimpleDeclarations = new ArrayList<IASTSimpleDeclaration>();
        IASTDeclaration[] iASTDeclarationArray = declarations;
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (decl.getFileLocation().getStartingLineNumber() >= methodPosition.getStartingLineNumber()) {
                return allIASTSimpleDeclarations;
            }
            if (MethodDefinitionInsertLocationFinder.isMemberFunctionDeclaration(decl)) {
                allIASTSimpleDeclarations.add(0, (IASTSimpleDeclaration)decl);
            }
            ++n2;
        }
        return allIASTSimpleDeclarations;
    }

    private static Collection<IASTSimpleDeclaration> getAllFollowingIASTSimpleDeclarationsFromClass(IASTDeclaration[] declarations, IASTFileLocation methodPosition) {
        ArrayList<IASTSimpleDeclaration> allIASTSimpleDeclarations = new ArrayList<IASTSimpleDeclaration>();
        IASTDeclaration[] iASTDeclarationArray = declarations;
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (MethodDefinitionInsertLocationFinder.isMemberFunctionDeclaration(decl) && decl.getFileLocation().getStartingLineNumber() > methodPosition.getStartingLineNumber()) {
                allIASTSimpleDeclarations.add((IASTSimpleDeclaration)decl);
            }
            ++n2;
        }
        return allIASTSimpleDeclarations;
    }

    private static boolean isMemberFunctionDeclaration(IASTDeclaration decl) {
        return decl instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)decl).getDeclarators().length > 0 && ((IASTSimpleDeclaration)decl).getDeclarators()[0] instanceof IASTFunctionDeclarator;
    }
}

