/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarationStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionCallExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTInitializerExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNodeFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.ui.refactoring.AddDeclarationNodeToClassChange;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.MethodContext;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractedFunctionConstructionHelper;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.NonExtractableStmtFinder;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ReturnStatementFinder;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.TrailNodeEqualityChecker;
import org.eclipse.cdt.internal.ui.refactoring.utils.ASTHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractFunctionRefactoring
extends CRefactoring {
    static final Integer NULL_INTEGER = 0;
    static final char[] ZERO = "0".toCharArray();
    NodeContainer container;
    final ExtractFunctionInformation info;
    final Map<String, Integer> names;
    final Container<Integer> namesCounter;
    final Container<Integer> trailPos;
    private final Container<Integer> returnNumber;
    protected boolean hasNameResolvingForSimilarError = false;
    protected ICProject project;
    HashMap<String, Integer> nameTrail;
    private ExtractedFunctionConstructionHelper extractedFunctionConstructionHelper;
    private INodeFactory factory = CPPNodeFactory.getDefault();

    public ExtractFunctionRefactoring(IFile file, ISelection selection, ExtractFunctionInformation info, ICProject project) {
        super(file, selection, null);
        this.info = info;
        this.project = project;
        this.name = Messages.ExtractFunctionRefactoring_ExtractFunction;
        this.names = new HashMap<String, Integer>();
        this.namesCounter = new Container<Integer>(NULL_INTEGER);
        this.trailPos = new Container<Integer>(NULL_INTEGER);
        this.returnNumber = new Container<Integer>(NULL_INTEGER);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
        this.container = this.findExtractableNodes();
        sm.worked(1);
        if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        this.checkForNonExtractableStatements(this.container, status);
        sm.worked(1);
        if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        this.container.findAllNames();
        this.markWriteAccess();
        sm.worked(1);
        if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        this.container.getAllAfterUsedNames();
        this.info.setAllUsedNames(this.container.getUsedNamesUnique());
        if (this.container.size() < 1) {
            status.addFatalError(Messages.ExtractFunctionRefactoring_NoStmtSelected);
            sm.done();
            return status;
        }
        if (this.container.getAllDeclaredInScope().size() > 1) {
            status.addFatalError(Messages.ExtractFunctionRefactoring_TooManySelected);
        } else if (this.container.getAllDeclaredInScope().size() == 1) {
            this.info.setInScopeDeclaredVariable(this.container.getAllDeclaredInScope().get(0));
        }
        this.extractedFunctionConstructionHelper = ExtractedFunctionConstructionHelper.createFor(this.container.getNodesToWrite());
        boolean isExtractExpression = this.container.getNodesToWrite().get(0) instanceof IASTExpression;
        this.info.setExtractExpression(isExtractExpression);
        this.info.setDeclarator(this.getDeclaration(this.container.getNodesToWrite().get(0)));
        MethodContext context = NodeHelper.findMethodContext(this.container.getNodesToWrite().get(0), this.getIndex());
        this.info.setMethodContext(context);
        if (this.unit != null) {
            IIndex index = CCorePlugin.getIndexManager().getIndex(this.project);
            this.unit.setIndex(index);
        }
        sm.done();
        return status;
    }

    private void markWriteAccess() throws CoreException {
        ArrayList<NodeContainer.NameInformation> paras = this.container.getNames();
        for (NodeContainer.NameInformation name : paras) {
            int flag = CPPVariableReadWriteFlags.getReadWriteFlags((IASTName)name.getName());
            if ((flag & 0x40) == 0) continue;
            name.setWriteAccess(true);
        }
    }

    private void checkForNonExtractableStatements(NodeContainer cont, RefactoringStatus status) {
        NonExtractableStmtFinder vis = new NonExtractableStmtFinder();
        for (IASTNode node : cont.getNodesToWrite()) {
            node.accept((ASTVisitor)vis);
            if (vis.containsContinue()) {
                this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_Error_Continue);
                break;
            }
            if (!vis.containsBreak()) continue;
            this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_Error_Break);
            break;
        }
        ReturnStatementFinder rFinder = new ReturnStatementFinder();
        for (IASTNode node : cont.getNodesToWrite()) {
            node.accept((ASTVisitor)rFinder);
            if (!rFinder.containsReturn()) continue;
            this.initStatus.addFatalError(Messages.ExtractFunctionRefactoring_Error_Return);
            break;
        }
    }

    private ICPPASTFunctionDeclarator getDeclaration(IASTNode node) {
        IASTFunctionDeclarator declarator;
        while (node != null && !(node instanceof IASTFunctionDefinition)) {
            node = node.getParent();
        }
        if (node != null && (declarator = ((IASTFunctionDefinition)node).getDeclarator()) instanceof ICPPASTFunctionDeclarator) {
            return (ICPPASTFunctionDeclarator)declarator;
        }
        return null;
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = super.checkFinalConditions(pm);
        CPPASTName astMethodName = new CPPASTName(this.info.getMethodName().toCharArray());
        MethodContext context = NodeHelper.findMethodContext(this.container.getNodesToWrite().get(0), this.getIndex());
        if (context.getType() == MethodContext.ContextType.METHOD) {
            ICPPASTCompositeTypeSpecifier classDeclaration = (ICPPASTCompositeTypeSpecifier)context.getMethodDeclaration().getParent();
            IASTSimpleDeclaration methodDeclaration = this.getDeclaration((IASTName)astMethodName);
            if (this.isMethodAllreadyDefined(methodDeclaration, classDeclaration)) {
                status.addError(Messages.ExtractFunctionRefactoring_NameInUse);
                return status;
            }
        }
        for (NodeContainer.NameInformation name : this.info.getAllUsedNames()) {
            if (!name.isUserSetIsReturnValue()) continue;
            this.info.setReturnVariable(name);
        }
        return status;
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        CPPASTName astMethodName = new CPPASTName(this.info.getMethodName().toCharArray());
        MethodContext context = NodeHelper.findMethodContext(this.container.getNodesToWrite().get(0), this.getIndex());
        if (context.getType() == MethodContext.ContextType.METHOD) {
            this.createMethodDeclaration((IASTName)astMethodName, context, collector);
        }
        IASTNode firstNode = this.container.getNodesToWrite().get(0);
        Path implPath = new Path(firstNode.getContainingFilename());
        IFile implementationFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)implPath);
        this.createMethodDefinition((IASTName)astMethodName, context, firstNode, implementationFile, collector);
        this.createMethodCalls((IASTName)astMethodName, implementationFile, context, collector);
    }

    private void createMethodCalls(IASTName astMethodName, IFile implementationFile, MethodContext context, ModificationCollector collector) throws CoreException {
        String title = context.getType() == MethodContext.ContextType.METHOD ? Messages.ExtractFunctionRefactoring_CreateMethodCall : Messages.ExtractFunctionRefactoring_CreateFunctionCall;
        IASTNode methodCall = this.getMethodCall(astMethodName);
        IASTNode firstNodeToWrite = this.container.getNodesToWrite().get(0);
        ASTRewrite rewriter = collector.rewriterForTranslationUnit(firstNodeToWrite.getTranslationUnit());
        TextEditGroup editGroup = new TextEditGroup(title);
        if (methodCall instanceof IASTDeclaration) {
            CPPASTDeclarationStatement declarationStatement = new CPPASTDeclarationStatement((IASTDeclaration)methodCall);
            methodCall = declarationStatement;
        }
        this.insertCallintoTree(methodCall, this.container.getNodesToWrite(), rewriter, editGroup);
        for (IASTNode node : this.container.getNodesToWrite()) {
            if (node == firstNodeToWrite) continue;
            rewriter.remove(node, editGroup);
        }
    }

    private void insertCallintoTree(IASTNode methodCall, List<IASTNode> list, ASTRewrite rewriter, TextEditGroup editGroup) {
        IASTNode firstNode = list.get(0);
        if (list.size() > 1 && firstNode.getParent() instanceof IASTBinaryExpression && firstNode.getParent().getParent() instanceof IASTBinaryExpression) {
            IASTBinaryExpression parent = (IASTBinaryExpression)firstNode.getParent();
            IASTExpression leftSubTree = parent.getOperand1();
            int op = parent.getOperator();
            CPPASTBinaryExpression newParentNode = new CPPASTBinaryExpression();
            CPPASTLiteralExpression placeholder = new CPPASTLiteralExpression(0, ZERO);
            IASTBinaryExpression rootBinExp = this.getRootBinExp(parent, list);
            newParentNode.setParent(rootBinExp.getParent());
            newParentNode.setOperand1((IASTExpression)placeholder);
            newParentNode.setOperator(op);
            newParentNode.setOperand2((IASTExpression)methodCall);
            ASTRewrite callRewrite = rewriter.replace((IASTNode)rootBinExp, (IASTNode)newParentNode, editGroup);
            callRewrite.replace((IASTNode)placeholder, (IASTNode)leftSubTree, editGroup);
        } else {
            rewriter.replace(firstNode, methodCall, editGroup);
        }
    }

    private IASTBinaryExpression getRootBinExp(IASTBinaryExpression binExp, List<IASTNode> nodeList) {
        while (binExp.getParent() instanceof IASTBinaryExpression && nodeList.contains(((IASTBinaryExpression)binExp.getParent()).getOperand2())) {
            binExp = (IASTBinaryExpression)binExp.getParent();
        }
        return binExp;
    }

    private void createMethodDefinition(IASTName astMethodName, MethodContext context, IASTNode firstNode, IFile implementationFile, ModificationCollector collector) {
        IASTFunctionDefinition node = NodeHelper.findFunctionDefinitionInAncestors(firstNode);
        if (node != null) {
            String title = context.getType() == MethodContext.ContextType.METHOD ? Messages.ExtractFunctionRefactoring_CreateMethodDef : Messages.ExtractFunctionRefactoring_CreateFunctionDef;
            ASTRewrite rewriter = collector.rewriterForTranslationUnit(node.getTranslationUnit());
            this.addMethod(astMethodName, context, rewriter, (IASTNode)node, new TextEditGroup(title));
        }
    }

    private void createMethodDeclaration(IASTName astMethodName, MethodContext context, ModificationCollector collector) {
        ICPPASTCompositeTypeSpecifier classDeclaration = (ICPPASTCompositeTypeSpecifier)context.getMethodDeclaration().getParent();
        IASTSimpleDeclaration methodDeclaration = this.getDeclaration(collector, astMethodName);
        AddDeclarationNodeToClassChange.createChange(classDeclaration, this.info.getVisibility(), (IASTNode)methodDeclaration, false, collector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMethodAllreadyDefined(IASTSimpleDeclaration methodDeclaration, ICPPASTCompositeTypeSpecifier classDeclaration) {
        TrailNodeEqualityChecker equalityChecker = new TrailNodeEqualityChecker(this.names, this.namesCounter);
        IBinding bind = classDeclaration.getName().resolveBinding();
        IASTStandardFunctionDeclarator declarator = (IASTStandardFunctionDeclarator)methodDeclaration.getDeclarators()[0];
        String name = new String(declarator.getName().toCharArray());
        if (bind instanceof ICPPClassType) {
            ICPPClassType classBind = (ICPPClassType)bind;
            try {
                ICPPMethod[] methods;
                IField[] fields;
                IField[] iFieldArray = fields = classBind.getFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    if (field.getName().equals(name)) {
                        return true;
                    }
                    ++n2;
                }
                ICPPMethod[] iCPPMethodArray = methods = classBind.getAllDeclaredMethods();
                int n3 = methods.length;
                n = 0;
                while (n < n3) {
                    IParameter[] parameters;
                    ICPPMethod method = iCPPMethodArray[n];
                    if (!method.takesVarArgs() && name.equals(method.getName()) && (parameters = method.getParameters()).length == declarator.getParameters().length) {
                        int i = 0;
                        while (i < parameters.length) {
                            IASTName[] origParameterName = this.unit.getDeclarationsInAST((IBinding)parameters[i]);
                            IASTParameterDeclaration origParameter = (IASTParameterDeclaration)origParameterName[0].getParent().getParent();
                            IASTParameterDeclaration newParameter = declarator.getParameters()[i];
                            if (!equalityChecker.isEquals((IASTNode)origParameter.getDeclSpecifier(), (IASTNode)newParameter.getDeclSpecifier()) || !ASTHelper.samePointers(origParameter.getDeclarator().getPointerOperators(), newParameter.getDeclarator().getPointerOperators(), equalityChecker)) break;
                            if (i >= parameters.length - 1) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    ++n;
                }
                return false;
            }
            catch (DOMException e) {
                ILog logger = CUIPlugin.getDefault().getLog();
                Status status = new Status(2, "org.eclipse.cdt.ui", 0, e.getMessage(), (Throwable)e);
                logger.log((IStatus)status);
            }
        }
        return true;
    }

    private void addMethod(IASTName astMethodName, MethodContext context, ASTRewrite rewriter, IASTNode insertpoint, TextEditGroup group) {
        ASTRewrite subRW;
        CPPASTQualifiedName qname = new CPPASTQualifiedName();
        if (context.getType() == MethodContext.ContextType.METHOD) {
            int i = 0;
            while (i < context.getMethodQName().getNames().length - 1) {
                qname.addName((IASTName)new CPPASTName(context.getMethodQName().getNames()[i].toCharArray()));
                ++i;
            }
        }
        qname.addName(astMethodName);
        CPPASTFunctionDefinition func = new CPPASTFunctionDefinition();
        func.setParent((IASTNode)this.unit);
        CPPASTSimpleDeclSpecifier dummyDeclSpecifier = new CPPASTSimpleDeclSpecifier();
        func.setDeclSpecifier((IASTDeclSpecifier)dummyDeclSpecifier);
        dummyDeclSpecifier.setType(1);
        IASTStandardFunctionDeclarator createdFunctionDeclarator = this.extractedFunctionConstructionHelper.createFunctionDeclarator((IASTName)qname, this.info.getDeclarator(), this.info.getReturnVariable(), this.container.getNodesToWrite(), this.info.getAllUsedNames(), this.unit.getParserLanguage());
        func.setDeclarator((IASTFunctionDeclarator)createdFunctionDeclarator);
        CPPASTCompoundStatement compound = new CPPASTCompoundStatement();
        func.setBody((IASTStatement)compound);
        if (insertpoint.getParent() instanceof ICPPASTTemplateDeclaration) {
            CPPASTTemplateDeclaration templateDeclaration = new CPPASTTemplateDeclaration();
            templateDeclaration.setParent((IASTNode)this.unit);
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = ((ICPPASTTemplateDeclaration)insertpoint.getParent()).getTemplateParameters();
            int n = iCPPASTTemplateParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter templateParameter = iCPPASTTemplateParameterArray[n2];
                templateDeclaration.addTemplateParamter(templateParameter.copy());
                ++n2;
            }
            templateDeclaration.setDeclaration((IASTDeclaration)func);
            subRW = rewriter.insertBefore(insertpoint.getParent().getParent(), insertpoint.getParent(), (IASTNode)templateDeclaration, group);
        } else {
            subRW = rewriter.insertBefore(insertpoint.getParent(), insertpoint, (IASTNode)func, group);
        }
        subRW.replace((IASTNode)dummyDeclSpecifier, (IASTNode)this.getReturnType(), group);
        this.extractedFunctionConstructionHelper.constructMethodBody((IASTCompoundStatement)compound, this.container.getNodesToWrite(), subRW, group);
        if (this.info.getReturnVariable() != null) {
            CPPASTReturnStatement returnStmt = new CPPASTReturnStatement();
            if (this.info.getReturnVariable().getDeclaration().getParent() instanceof IASTExpression) {
                IASTExpression returnValue = (IASTExpression)this.info.getReturnVariable().getDeclaration().getParent();
                returnStmt.setReturnValue(returnValue);
            } else {
                CPPASTIdExpression expr = new CPPASTIdExpression();
                if (this.info.getReturnVariable().getUserSetName() == null) {
                    expr.setName(this.newName(this.info.getReturnVariable().getName()));
                } else {
                    expr.setName((IASTName)new CPPASTName(this.info.getReturnVariable().getUserSetName().toCharArray()));
                }
                returnStmt.setReturnValue((IASTExpression)expr);
            }
            subRW.insertBefore((IASTNode)compound, null, (IASTNode)returnStmt, group);
        }
    }

    private IASTName newName(IASTName declaration) {
        return new CPPASTName(declaration.toCharArray());
    }

    private IASTDeclSpecifier getReturnType() {
        IASTNode firstNodeToWrite = this.container.getNodesToWrite().get(0);
        NodeContainer.NameInformation returnVariable = this.info.getReturnVariable();
        return this.extractedFunctionConstructionHelper.determineReturnType(firstNodeToWrite, returnVariable);
    }

    protected IASTNode getMethodCall(IASTName astMethodName, Map<String, Integer> trailNameTable, Map<String, Integer> similarNameTable, NodeContainer myContainer, NodeContainer mySimilarContainer) {
        CPPASTExpressionStatement stmt = new CPPASTExpressionStatement();
        CPPASTFunctionCallExpression callExpression = new CPPASTFunctionCallExpression();
        CPPASTIdExpression idExpression = new CPPASTIdExpression();
        idExpression.setName(astMethodName);
        CPPASTExpressionList paramList = new CPPASTExpressionList();
        Vector<IASTName> declarations = new Vector<IASTName>();
        CPPASTName retName = null;
        boolean theRetName = false;
        for (NodeContainer.NameInformation nameInfo : myContainer.getNames()) {
            Integer trailSeqNumber = trailNameTable.get(nameInfo.getDeclaration().getRawSignature());
            String orgName = null;
            for (Map.Entry<String, Integer> entry : similarNameTable.entrySet()) {
                if (!entry.getValue().equals(trailSeqNumber)) continue;
                orgName = entry.getKey();
                if (this.info.getReturnVariable() == null || !trailSeqNumber.equals(this.returnNumber.getObject())) continue;
                theRetName = true;
            }
            if (orgName == null) continue;
            boolean found = false;
            for (NodeContainer.NameInformation simNameInfo : mySimilarContainer.getNames()) {
                if (!orgName.equals(simNameInfo.getDeclaration().getRawSignature())) continue;
                this.addAParameterIfPossible((IASTExpressionList)paramList, declarations, simNameInfo);
                found = true;
                if (!theRetName) continue;
                theRetName = false;
                retName = new CPPASTName(simNameInfo.getDeclaration().getRawSignature().toCharArray());
            }
            if (found) continue;
            CPPASTIdExpression expression = new CPPASTIdExpression();
            CPPASTName fieldName = new CPPASTName(orgName.toCharArray());
            expression.setName((IASTName)fieldName);
            paramList.addExpression((IASTExpression)expression);
            if (!theRetName) continue;
            theRetName = false;
            retName = fieldName;
        }
        callExpression.setParameterExpression((IASTExpression)paramList);
        callExpression.setFunctionNameExpression((IASTExpression)idExpression);
        if (this.info.getReturnVariable() == null) {
            return this.getReturnAssignment((IASTExpressionStatement)stmt, (IASTExpression)callExpression);
        }
        return this.getReturnAssignment((IASTExpressionStatement)stmt, (IASTFunctionCallExpression)callExpression, (IASTName)retName);
    }

    private IASTNode getMethodCall(IASTName astMethodName) {
        CPPASTExpressionStatement stmt = new CPPASTExpressionStatement();
        CPPASTFunctionCallExpression callExpression = new CPPASTFunctionCallExpression();
        CPPASTIdExpression idExpression = new CPPASTIdExpression();
        idExpression.setName((IASTName)new CPPASTName(astMethodName.toCharArray()));
        IASTExpressionList paramList = this.getCallParameters();
        callExpression.setParameterExpression((IASTExpression)paramList);
        callExpression.setFunctionNameExpression((IASTExpression)idExpression);
        if (this.info.getReturnVariable() == null) {
            return this.getReturnAssignment((IASTExpressionStatement)stmt, (IASTExpression)callExpression);
        }
        IASTName retname = this.newName(this.info.getReturnVariable().getName());
        return this.getReturnAssignment((IASTExpressionStatement)stmt, (IASTFunctionCallExpression)callExpression, retname);
    }

    private IASTNode getReturnAssignment(IASTExpressionStatement stmt, IASTFunctionCallExpression callExpression, IASTName retname) {
        if (this.info.getReturnVariable().equals(this.info.getInScopeDeclaredVariable())) {
            IASTSimpleDeclaration orgDecl = NodeHelper.findSimpleDeclarationInParents((IASTNode)this.info.getReturnVariable().getDeclaration());
            CPPASTSimpleDeclaration decl = new CPPASTSimpleDeclaration();
            decl.setDeclSpecifier(orgDecl.getDeclSpecifier().copy());
            CPPASTDeclarator declarator = new CPPASTDeclarator();
            declarator.setName(retname);
            IASTPointerOperator[] iASTPointerOperatorArray = orgDecl.getDeclarators()[0].getPointerOperators();
            int n = iASTPointerOperatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
                declarator.addPointerOperator(pointer.copy());
                ++n2;
            }
            CPPASTInitializerExpression initializer = new CPPASTInitializerExpression();
            initializer.setExpression((IASTExpression)callExpression);
            declarator.setInitializer((IASTInitializer)initializer);
            decl.addDeclarator((IASTDeclarator)declarator);
            return decl;
        }
        CASTBinaryExpression binaryExpression = new CASTBinaryExpression();
        binaryExpression.setOperator(17);
        CPPASTIdExpression nameExpression = new CPPASTIdExpression();
        nameExpression.setName(retname);
        binaryExpression.setOperand1((IASTExpression)nameExpression);
        binaryExpression.setOperand2((IASTExpression)callExpression);
        return this.getReturnAssignment(stmt, (IASTExpression)binaryExpression);
    }

    private IASTNode getReturnAssignment(IASTExpressionStatement stmt, IASTExpression callExpression) {
        IASTNode node = this.container.getNodesToWrite().get(0);
        return this.extractedFunctionConstructionHelper.createReturnAssignment(node, stmt, callExpression);
    }

    private IASTSimpleDeclaration getDeclaration(IASTName name) {
        CPPASTSimpleDeclaration simpleDecl = new CPPASTSimpleDeclaration();
        IASTStandardFunctionDeclarator declarator = this.extractedFunctionConstructionHelper.createFunctionDeclarator(name, this.info.getDeclarator(), this.info.getReturnVariable(), this.container.getNodesToWrite(), this.info.getAllUsedNames(), this.unit.getParserLanguage());
        simpleDecl.addDeclarator((IASTDeclarator)declarator);
        return simpleDecl;
    }

    private IASTSimpleDeclaration getDeclaration(ModificationCollector collector, IASTName name) {
        IASTDeclSpecifier declSpec = this.getReturnType();
        IASTSimpleDeclaration simpleDecl = this.factory.newSimpleDeclaration(declSpec);
        simpleDecl.setParent((IASTNode)this.unit);
        IASTStandardFunctionDeclarator declarator = this.extractedFunctionConstructionHelper.createFunctionDeclarator(name, this.info.getDeclarator(), this.info.getReturnVariable(), this.container.getNodesToWrite(), this.info.getAllUsedNames(), this.unit.getParserLanguage());
        simpleDecl.addDeclarator((IASTDeclarator)declarator);
        return simpleDecl;
    }

    private NodeContainer findExtractableNodes() {
        final NodeContainer container = new NodeContainer();
        this.unit.accept((ASTVisitor)new CPPASTVisitor(){
            {
                this.shouldVisitStatements = true;
                this.shouldVisitExpressions = true;
            }

            public int visit(IASTStatement stmt) {
                if (SelectionHelper.isSelectedFile(ExtractFunctionRefactoring.this.region, (IASTNode)stmt, ExtractFunctionRefactoring.this.file)) {
                    container.add((IASTNode)stmt);
                    return 1;
                }
                return super.visit(stmt);
            }

            public int visit(IASTExpression expression) {
                if (SelectionHelper.isSelectedFile(ExtractFunctionRefactoring.this.region, (IASTNode)expression, ExtractFunctionRefactoring.this.file)) {
                    container.add((IASTNode)expression);
                    return 1;
                }
                return super.visit(expression);
            }
        });
        return container;
    }

    public IASTExpressionList getCallParameters() {
        CPPASTExpressionList paramList = new CPPASTExpressionList();
        Vector<IASTName> declarations = new Vector<IASTName>();
        for (NodeContainer.NameInformation nameInf : this.container.getNames()) {
            this.addAParameterIfPossible((IASTExpressionList)paramList, declarations, nameInf);
        }
        return paramList;
    }

    private void addAParameterIfPossible(IASTExpressionList paramList, Vector<IASTName> declarations, NodeContainer.NameInformation nameInf) {
        IASTName declaration;
        if (!nameInf.isDeclarationInScope() && !declarations.contains(declaration = nameInf.getDeclaration())) {
            declarations.add(declaration);
            CPPASTIdExpression expression = new CPPASTIdExpression();
            expression.setName(this.newName(declaration));
            paramList.addExpression((IASTExpression)expression);
        }
    }
}

