/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespace;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTypedef;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractedFunctionConstructionHelper;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractExpression
extends ExtractedFunctionConstructionHelper {
    static final char[] ZERO = new char[]{'0'};

    @Override
    public void constructMethodBody(IASTCompoundStatement compound, List<IASTNode> list, ASTRewrite rewrite, TextEditGroup group) {
        CPPASTReturnStatement statement = new CPPASTReturnStatement();
        CPPASTLiteralExpression nullReturnExp = new CPPASTLiteralExpression(0, ZERO);
        statement.setReturnValue((IASTExpression)nullReturnExp);
        ASTRewrite nestedRewrite = rewrite.insertBefore((IASTNode)compound, null, (IASTNode)statement, group);
        nestedRewrite.replace((IASTNode)nullReturnExp, (IASTNode)this.getExpression(list), group);
    }

    private IASTExpression getExpression(List<IASTNode> list) {
        if (list.size() > 1) {
            CPPASTBinaryExpression bExp = new CPPASTBinaryExpression();
            bExp.setParent(list.get(0).getParent());
            bExp.setOperand1((IASTExpression)list.get(0).copy());
            bExp.setOperator(((IASTBinaryExpression)list.get(1).getParent()).getOperator());
            bExp.setOperand2(this.getExpression(list.subList(1, list.size())));
            return bExp;
        }
        return (IASTExpression)list.get(0).copy();
    }

    @Override
    public IASTDeclSpecifier determineReturnType(IASTNode extractedNode, NodeContainer.NameInformation _) {
        IASTDeclSpecifier declSpecifier = null;
        if (extractedNode instanceof ICPPASTBinaryExpression) {
            declSpecifier = this.handleBinaryExpression((ICPPASTBinaryExpression)extractedNode);
        }
        if (extractedNode instanceof ICPPASTNewExpression) {
            declSpecifier = this.handleNewExpression((ICPPASTNewExpression)extractedNode);
        }
        if (extractedNode instanceof IASTFunctionCallExpression) {
            declSpecifier = ExtractExpression.handleFunctionCallExpression((IASTFunctionCallExpression)extractedNode);
        }
        if (extractedNode instanceof IASTLiteralExpression) {
            declSpecifier = this.handleLiteralExpression((IASTLiteralExpression)extractedNode);
        }
        if (declSpecifier == null) {
            IType type;
            if (extractedNode instanceof IASTExpression && (type = ((IASTExpression)extractedNode).getExpressionType()) instanceof IBasicType) {
                try {
                    return ExtractExpression.createSimpleDeclSpecifier(((IBasicType)type).getType());
                }
                catch (DOMException dOMException) {}
            }
            return ExtractExpression.createSimpleDeclSpecifier(1);
        }
        return declSpecifier.copy();
    }

    private IASTDeclSpecifier handleLiteralExpression(IASTLiteralExpression extractedNode) {
        switch (extractedNode.getKind()) {
            case 2: {
                return ExtractExpression.createSimpleDeclSpecifier(2);
            }
            case 1: {
                return ExtractExpression.createSimpleDeclSpecifier(4);
            }
            case 0: {
                return ExtractExpression.createSimpleDeclSpecifier(3);
            }
            case 3: {
                return ExtractExpression.createSimpleDeclSpecifier(7);
            }
            case 5: 
            case 6: {
                return ExtractExpression.createSimpleDeclSpecifier(6);
            }
        }
        return null;
    }

    private IASTDeclSpecifier handleNewExpression(ICPPASTNewExpression expression) {
        return expression.getTypeId().getDeclSpecifier();
    }

    private IASTDeclSpecifier handleBinaryExpression(ICPPASTBinaryExpression node) {
        switch (node.getOperator()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 28: 
            case 29: {
                return ExtractExpression.createSimpleDeclSpecifier(6);
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                return this.getTypeFromBinaryExp(node);
            }
        }
        return null;
    }

    private IASTDeclSpecifier getTypeFromBinaryExp(ICPPASTBinaryExpression node) {
        IASTDeclSpecifier ret;
        if (node.getOperand1() instanceof ICPPASTBinaryExpression) {
            ret = this.getTypeFromBinaryExp((ICPPASTBinaryExpression)((CPPASTBinaryExpression)node.getOperand1()));
            if (ret != null) {
                return ret;
            }
        } else if (node.getOperand1() instanceof CPPASTIdExpression) {
            return this.getBinaryExpressionType(((CPPASTIdExpression)node.getOperand1()).getExpressionType());
        }
        if (node.getOperand2() instanceof ICPPASTBinaryExpression) {
            ret = this.getTypeFromBinaryExp((ICPPASTBinaryExpression)((CPPASTBinaryExpression)node.getOperand2()));
            if (ret != null) {
                return ret;
            }
        } else if (node.getOperand2() instanceof CPPASTIdExpression) {
            return this.getBinaryExpressionType(((CPPASTIdExpression)node.getOperand2()).getExpressionType());
        }
        return null;
    }

    private IASTDeclSpecifier getBinaryExpressionType(IType expressionType) {
        if (expressionType instanceof CPPBasicType) {
            CPPBasicType basicType = (CPPBasicType)expressionType;
            return ExtractExpression.createSimpleDeclSpecifier(basicType.getType());
        }
        if (expressionType instanceof CPPTypedef) {
            return this.getDeclSpecForType((CPPTypedef)expressionType);
        }
        if (expressionType instanceof CPPClassType) {
            return this.getDeclSpecForType((CPPClassType)expressionType);
        }
        return null;
    }

    private CPPASTNamedTypeSpecifier getDeclSpecForType(CPPClassType classType) {
        IASTName name = null;
        try {
            IBinding bind = classType.getOwner();
            if (bind instanceof CPPNamespace) {
                ICPPASTQualifiedName qname = this.getQname((IBinding)classType, bind);
                qname.addName((IASTName)classType.getDefinition().copy());
                name = qname;
            } else {
                name = (IASTName)classType.getDefinition();
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
            name = new CPPASTName(classType.getNameCharArray());
        }
        return new CPPASTNamedTypeSpecifier(name.copy());
    }

    private ICPPASTQualifiedName getQname(IBinding classType, IBinding bind) {
        CPPNamespace namespace = (CPPNamespace)bind;
        char[][] names = namespace.getFullyQualifiedNameCharArray();
        CPPASTQualifiedName qname = new CPPASTQualifiedName();
        char[][] cArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            char[] string = cArray[n2];
            qname.addName((IASTName)new CPPASTName(string));
            ++n2;
        }
        return qname;
    }

    private IASTDeclSpecifier getDeclSpecForType(CPPTypedef typedef) {
        IASTName name = null;
        try {
            IBinding bind = typedef.getOwner();
            if (bind instanceof CPPNamespace) {
                ICPPASTQualifiedName qname = this.getQname((IBinding)typedef, bind);
                qname.addName((IASTName)typedef.getDefinition().copy());
                name = qname;
            } else {
                name = (IASTName)typedef.getDefinition();
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
            name = new CPPASTName(typedef.getNameCharArray());
        }
        return new CPPASTNamedTypeSpecifier(name.copy());
    }

    private static IASTDeclSpecifier createSimpleDeclSpecifier(int type) {
        CPPASTSimpleDeclSpecifier declSpec = new CPPASTSimpleDeclSpecifier();
        declSpec.setType(type);
        return declSpec;
    }

    private static IASTName findCalledFunctionName(IASTFunctionCallExpression callExpression) {
        IASTExpression functionNameExpression = callExpression.getFunctionNameExpression();
        IASTName functionName = null;
        if (functionNameExpression instanceof CPPASTIdExpression) {
            CPPASTIdExpression idExpression = (CPPASTIdExpression)functionNameExpression;
            functionName = idExpression.getName();
        } else if (functionNameExpression instanceof CPPASTFieldReference) {
            CPPASTFieldReference fieldReference = (CPPASTFieldReference)functionNameExpression;
            functionName = fieldReference.getFieldName();
        }
        return functionName;
    }

    private static IASTDeclSpecifier handleFunctionCallExpression(IASTFunctionCallExpression callExpression) {
        IASTName functionName = ExtractExpression.findCalledFunctionName(callExpression);
        if (functionName != null) {
            IBinding binding = functionName.resolveBinding();
            if (binding instanceof CPPFunction) {
                IASTNode parent;
                CPPFunction function = (CPPFunction)binding;
                if (function.getDefinition() != null) {
                    IASTNode parent2 = function.getDefinition().getParent();
                    if (parent2 instanceof CPPASTFunctionDefinition) {
                        CPPASTFunctionDefinition definition = (CPPASTFunctionDefinition)parent2;
                        return definition.getDeclSpecifier();
                    }
                } else if (ExtractExpression.hasDeclaration(function) && (parent = function.getDeclarations()[0].getParent()) instanceof CPPASTSimpleDeclaration) {
                    CPPASTSimpleDeclaration declaration = (CPPASTSimpleDeclaration)parent;
                    return declaration.getDeclSpecifier();
                }
            } else if (binding instanceof CPPTypedef) {
                CPPTypedef typedef = (CPPTypedef)binding;
                return new CPPASTNamedTypeSpecifier((IASTName)new CPPASTName(typedef.getNameCharArray()));
            }
        }
        return null;
    }

    @Override
    protected boolean isReturnTypeAPointer(IASTNode node) {
        IBinding binding;
        if (node instanceof ICPPASTNewExpression) {
            return true;
        }
        if (!(node instanceof IASTFunctionCallExpression)) {
            return false;
        }
        IASTName functionName = ExtractExpression.findCalledFunctionName((IASTFunctionCallExpression)node);
        if (functionName != null && (binding = functionName.resolveBinding()) instanceof CPPFunction) {
            IASTNode parent;
            CPPFunction function = (CPPFunction)binding;
            if (function.getDefinition() != null) {
                IASTNode parent2 = function.getDefinition().getParent();
                if (parent2 instanceof CPPASTFunctionDefinition) {
                    CPPASTFunctionDefinition definition = (CPPASTFunctionDefinition)parent2;
                    return definition.getDeclarator().getPointerOperators().length > 0;
                }
            } else if (ExtractExpression.hasDeclaration(function) && (parent = function.getDeclarations()[0].getParent()) instanceof CPPASTSimpleDeclaration) {
                CPPASTSimpleDeclaration declaration = (CPPASTSimpleDeclaration)parent;
                return declaration.getDeclarators().length > 0 && declaration.getDeclarators()[0].getPointerOperators().length > 0;
            }
        }
        return false;
    }

    private static boolean hasDeclaration(CPPFunction function) {
        return function != null && function.getDeclarations() != null && function.getDeclarations().length > 0;
    }

    @Override
    public IASTNode createReturnAssignment(IASTNode node, IASTExpressionStatement stmt, IASTExpression callExpression) {
        return callExpression;
    }
}

