/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerDefaultPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.IContainerDescriptor;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.ICPathContainerPage;
import org.eclipse.cdt.ui.wizards.IPathEntryContainerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;

public class CPathContainerDescriptor
implements IContainerDescriptor {
    private IConfigurationElement fConfigElement;
    private static final String ATT_EXTENSION = "PathContainerPage";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ICON = "icon";
    private static final String ATT_PAGE_CLASS = "class";
    private Image pageImage;

    public CPathContainerDescriptor(IConfigurationElement configElement) throws CoreException {
        this.fConfigElement = configElement;
        String id = this.fConfigElement.getAttribute(ATT_ID);
        String name = configElement.getAttribute(ATT_NAME);
        String pageClassName = configElement.getAttribute(ATT_PAGE_CLASS);
        if (name == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "Invalid extension (missing name): " + id, null));
        }
        if (pageClassName == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "Invalid extension (missing page class name): " + id, null));
        }
    }

    public IPathEntryContainerPage createPage() throws CoreException {
        Object elem = CoreUtility.createExtension(this.fConfigElement, ATT_PAGE_CLASS);
        if (elem instanceof IPathEntryContainerPage) {
            return (IPathEntryContainerPage)elem;
        }
        IPathEntryContainerPage result = PathEntryContainerPageAdapter.createAdapter(elem);
        if (result != null) {
            return result;
        }
        String id = this.fConfigElement.getAttribute(ATT_ID);
        throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "Invalid extension (page not of type IClasspathContainerPage): " + id, null));
    }

    public String getName() {
        return this.fConfigElement.getAttribute(ATT_NAME);
    }

    public Image getImage() {
        String imageName;
        if (this.pageImage == null && (imageName = this.fConfigElement.getAttribute(ATT_ICON)) != null) {
            Image image;
            IExtension extension = this.fConfigElement.getDeclaringExtension();
            String plugin = extension.getContributor().getName();
            this.pageImage = image = this.getImageFromPlugin(plugin, imageName);
        }
        return this.pageImage;
    }

    public Image getImageFromPlugin(String plugin, String subdirectoryAndFilename) {
        Bundle bundle = Platform.getBundle((String)plugin);
        URL iconURL = bundle.getEntry("/");
        return this.getImageFromURL(iconURL, subdirectoryAndFilename);
    }

    public Image getImageFromURL(URL installURL, String subdirectoryAndFilename) {
        Image image = null;
        try {
            URL newURL = new URL(installURL, subdirectoryAndFilename);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)newURL);
            image = desc.createImage();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (SWTException sWTException) {}
        return image;
    }

    public String getPageClass() {
        return this.fConfigElement.getAttribute(ATT_PAGE_CLASS);
    }

    public boolean canEdit(IPathEntry entry) {
        String id = this.fConfigElement.getAttribute(ATT_ID);
        if (entry.getEntryKind() == 32) {
            String type = entry.getPath().segment(0);
            return id.equals(type);
        }
        return false;
    }

    public static IContainerDescriptor[] getDescriptors() {
        ArrayList<CPathContainerDescriptor> containers = new ArrayList<CPathContainerDescriptor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", ATT_EXTENSION);
        if (extensionPoint != null) {
            CPathContainerDescriptor defaultPage = null;
            String defaultPageName = CPathContainerDefaultPage.class.getName();
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                try {
                    CPathContainerDescriptor curr = new CPathContainerDescriptor(elements[i]);
                    if (defaultPageName.equals(curr.getPageClass())) {
                        defaultPage = curr;
                    } else {
                        containers.add(curr);
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
                ++i;
            }
            if (defaultPageName != null && containers.isEmpty()) {
                containers.add(defaultPage);
            }
        }
        return containers.toArray(new CPathContainerDescriptor[containers.size()]);
    }

    @Deprecated
    public static class PathEntryContainerPageAdapter
    implements IWizardPage,
    IPathEntryContainerPage {
        private final ICPathContainerPage fPage;

        public static IPathEntryContainerPage createAdapter(Object elem) {
            if (elem instanceof ICPathContainerPage) {
                return new PathEntryContainerPageAdapter((ICPathContainerPage)elem);
            }
            return null;
        }

        protected PathEntryContainerPageAdapter(ICPathContainerPage page) {
            this.fPage = page;
        }

        public void initialize(ICProject project, IPathEntry[] currentEntries) {
            this.fPage.initialize(project, currentEntries);
        }

        public boolean finish() {
            return this.fPage.finish();
        }

        public IContainerEntry[] getNewContainers() {
            IPathEntry[] entries = this.fPage.getContainerEntries();
            IContainerEntry[] containers = new IContainerEntry[entries.length];
            System.arraycopy(entries, 0, containers, 0, entries.length);
            return containers;
        }

        public void setSelection(IContainerEntry containerEntry) {
            this.fPage.setSelection((IPathEntry)containerEntry);
        }

        public void createControl(Composite parent) {
            this.fPage.createControl(parent);
        }

        public boolean canFlipToNextPage() {
            return this.fPage.canFlipToNextPage();
        }

        public String getName() {
            return this.fPage.getName();
        }

        public IWizardPage getNextPage() {
            return this.fPage.getNextPage();
        }

        public IWizardPage getPreviousPage() {
            return this.fPage.getPreviousPage();
        }

        public IWizard getWizard() {
            return this.fPage.getWizard();
        }

        public boolean isPageComplete() {
            return this.fPage.isPageComplete();
        }

        public void setPreviousPage(IWizardPage page) {
            this.fPage.setPreviousPage(page);
        }

        public void setWizard(IWizard newWizard) {
            this.fPage.setWizard(newWizard);
        }

        public void dispose() {
            this.fPage.dispose();
        }

        public Control getControl() {
            return this.fPage.getControl();
        }

        public String getDescription() {
            return this.fPage.getDescription();
        }

        public String getErrorMessage() {
            return this.fPage.getErrorMessage();
        }

        public Image getImage() {
            return this.fPage.getImage();
        }

        public String getMessage() {
            return this.fPage.getMessage();
        }

        public String getTitle() {
            return this.fPage.getTitle();
        }

        public void performHelp() {
            this.fPage.performHelp();
        }

        public void setDescription(String description) {
            this.fPage.setDescription(description);
        }

        public void setImageDescriptor(ImageDescriptor image) {
            this.fPage.setImageDescriptor(image);
        }

        public void setTitle(String title) {
            this.fPage.setTitle(title);
        }

        public void setVisible(boolean visible) {
            this.fPage.setVisible(visible);
        }
    }
}

