/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class AddIncludesOperation
implements IWorkspaceRunnable {
    private ITranslationUnit fTranslationUnit;
    private IRequiredInclude[] fIncludes;
    private String[] fUsings;
    private final String fNewLine;
    private IRegion insertedIncludes;

    public AddIncludesOperation(ITranslationUnit tu, IRequiredInclude[] includes, boolean save) {
        this(tu, includes, null, save);
    }

    public AddIncludesOperation(ITranslationUnit tu, IRequiredInclude[] includes, String[] usings, boolean save) {
        this.fIncludes = includes;
        this.fUsings = usings;
        this.fTranslationUnit = tu;
        this.fNewLine = this.getNewLine(tu);
    }

    private String getNewLine(ITranslationUnit tu) {
        try {
            String delim;
            IDocument doc;
            IBuffer buf = tu.getBuffer();
            if (buf instanceof IAdaptable && (doc = (IDocument)((IAdaptable)buf).getAdapter(IDocument.class)) != null && (delim = doc.getLineDelimiter(0)) != null) {
                return delim;
            }
        }
        catch (CModelException cModelException) {
        }
        catch (BadLocationException badLocationException) {}
        return System.getProperty("line.separator", "\n");
    }

    private void insertIncludes(IProgressMonitor monitor) throws CoreException {
        if (this.fIncludes == null || this.fIncludes.length == 0) {
            return;
        }
        if (this.fTranslationUnit != null) {
            ArrayList<IRequiredInclude> toAdd = new ArrayList<IRequiredInclude>();
            monitor.beginTask(CEditorMessages.AddIncludesOperation_description, 2);
            List elements = this.fTranslationUnit.getChildrenOfType(75);
            IRequiredInclude[] iRequiredIncludeArray = this.fIncludes;
            int n = this.fIncludes.length;
            int n2 = 0;
            while (n2 < n) {
                IRequiredInclude include = iRequiredIncludeArray[n2];
                String name = include.getIncludeName();
                boolean found = false;
                for (ICElement element : elements) {
                    if (!name.equals(element.getElementName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    toAdd.add(include);
                }
                ++n2;
            }
            if (!toAdd.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                for (IRequiredInclude include : toAdd) {
                    if (include.isStandard()) {
                        buf.append("#include <" + include.getIncludeName() + ">").append(this.fNewLine);
                        continue;
                    }
                    buf.append("#include \"" + include.getIncludeName() + "\"").append(this.fNewLine);
                }
                int pos = 0;
                if (!elements.isEmpty()) {
                    IInclude lastInclude = (IInclude)elements.get(elements.size() - 1);
                    ISourceRange range = lastInclude.getSourceRange();
                    pos = range.getStartPos() + range.getLength();
                }
                monitor.worked(1);
                this.replace(pos, buf.toString());
                this.insertedIncludes = new Region(pos, buf.length());
                monitor.worked(1);
            }
        }
    }

    private void insertUsings(IProgressMonitor monitor) throws CoreException {
        if (this.fUsings == null || this.fUsings.length == 0) {
            return;
        }
        if (this.fTranslationUnit != null) {
            ArrayList<String> toAdd = new ArrayList<String>(this.fUsings.length);
            monitor.beginTask(CEditorMessages.AddIncludesOperation_description, 2);
            List elements = this.fTranslationUnit.getChildrenOfType(62);
            String[] stringArray = this.fUsings;
            int n = this.fUsings.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                boolean found = false;
                for (ICElement element : elements) {
                    if (!name.equals(element.getElementName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    toAdd.add(name);
                }
                ++n2;
            }
            if (!toAdd.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                for (String using : toAdd) {
                    buf.append("using ").append(using).append(';').append(this.fNewLine);
                }
                int pos = 0;
                if (!elements.isEmpty()) {
                    IUsing lastUsing = (IUsing)elements.get(elements.size() - 1);
                    ISourceRange range = lastUsing.getSourceRange();
                    pos = range.getStartPos() + range.getLength();
                } else {
                    List includes = this.fTranslationUnit.getChildrenOfType(75);
                    if (!includes.isEmpty()) {
                        IInclude lastInclude = (IInclude)includes.get(includes.size() - 1);
                        ISourceRange range = lastInclude.getSourceRange();
                        pos = range.getStartPos() + range.getLength();
                    }
                    if (!includes.isEmpty() || this.insertedIncludes != null) {
                        buf.insert(0, this.fNewLine);
                    }
                }
                if (this.insertedIncludes != null && pos >= this.insertedIncludes.getOffset()) {
                    pos += this.insertedIncludes.getLength();
                }
                monitor.worked(1);
                this.replace(pos, buf.toString());
                monitor.worked(1);
            }
        }
    }

    private void replace(int pos, String s) throws CModelException {
        IBuffer buffer = this.fTranslationUnit.getBuffer();
        if (pos > 0) {
            while (buffer.getChar(pos) != '\n') {
                ++pos;
            }
            if (buffer.getChar(pos) == '\r') {
                ++pos;
            }
            ++pos;
        }
        buffer.replace(pos, 0, s);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.insertIncludes(monitor);
            this.insertUsings(monitor);
        }
        finally {
            monitor.done();
        }
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

