/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.navigator.internal;

import com.atmel.avr32.sf.core.SFCorePlugin;
import com.atmel.avr32.sf.core.SoftwareFramework;
import com.atmel.avr32.sf.core.ui.navigator.internal.FrameworkContainer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SoftwareFrameworkMenu
extends CompoundContributionItem {
    public SoftwareFrameworkMenu() {
    }

    public SoftwareFrameworkMenu(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            Object s = ((IStructuredSelection)selection).getFirstElement();
            MenuManager mgr = new MenuManager("Library Links");
            if (s instanceof FrameworkContainer) {
                SoftwareFramework[] frameworks;
                final FrameworkContainer fwc = (FrameworkContainer)((Object)s);
                SoftwareFramework[] softwareFrameworkArray = frameworks = SFCorePlugin.getDefault().getFrameworks();
                int n = frameworks.length;
                int n2 = 0;
                while (n2 < n) {
                    final SoftwareFramework sf = softwareFrameworkArray[n2];
                    final QualifiedName qname = new QualifiedName("com.atmel.avr32.sf.core.ui.navigator", sf.getId());
                    if (sf.showInNavigator() && sf.isCompatible(fwc.getProject())) {
                        try {
                            String p = fwc.getProject().getPersistentProperty(qname);
                            final boolean set = p != null && Boolean.parseBoolean(p);
                            IWorkbenchPartSite site = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
                            WorkspaceAction action = new WorkspaceAction((IShellProvider)site, sf.getName()){

                                public String getText() {
                                    return sf.getName();
                                }

                                public void run() {
                                    SoftwareFrameworkMenu.this.runOperation(SoftwareFrameworkMenu.this.getOperation(fwc, qname, set));
                                }

                                protected String getOperationMessage() {
                                    return null;
                                }
                            };
                            action.setChecked(set);
                            mgr.add((IAction)action);
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
            }
            return new IContributionItem[]{mgr};
        }
        return new IContributionItem[0];
    }

    private WorkspaceModifyOperation getOperation(final FrameworkContainer fwc, final QualifiedName qname, final boolean set) {
        ISchedulingRule rule = null;
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ArrayList<IProject> actionResources = new ArrayList<IProject>();
        actionResources.add(fwc.getProject());
        final ArrayList<IProject> resources = actionResources;
        Iterator res = resources.iterator();
        while (res.hasNext()) {
            rule = MultiRule.combine(rule, (ISchedulingRule)factory.refreshRule((IResource)res.next()));
        }
        final Display display = Display.getDefault();
        return new WorkspaceModifyOperation(rule){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask("", resources.size() * 1000);
                        fwc.getProject().setPersistentProperty(qname, Boolean.toString(!set));
                        fwc.getProject().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                fwc.getProvider().viewer.refresh();
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private void runOperation(final WorkspaceModifyOperation op) {
        final IStatus[] errorStatus = new IStatus[]{Status.OK_STATUS};
        WorkspaceJob job = new WorkspaceJob("refresh"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    op.run(monitor);
                }
                catch (InvocationTargetException e) {
                    throw new CoreException((IStatus)new Status(4, "com.atmel.avr32.sf.core.ui.navigator", e.getMessage()));
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return errorStatus[0];
            }
        };
        ISchedulingRule rule = op.getRule();
        if (rule != null) {
            job.setRule(rule);
        }
        job.setUser(true);
        job.schedule();
    }
}

