/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.core.ui.navigator.internal;

import com.atmel.avr32.sf.core.IFrameworkData;
import com.atmel.avr32.sf.core.SFCorePlugin;
import com.atmel.avr32.sf.core.SoftwareFramework;
import com.atmel.avr32.sf.core.ui.navigator.NavigatorPlugin;
import com.atmel.avr32.sf.core.ui.navigator.internal.FrameworkContentProvider;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.model.WorkbenchAdapter;

public class FrameworkContainer
extends WorkbenchAdapter {
    private static final IFolder[] EMPTY_LIBRARY = new IFolder[0];
    private IProject project;
    private FrameworkContentProvider provider;

    IProject getProject() {
        return this.project;
    }

    FrameworkContentProvider getProvider() {
        return this.provider;
    }

    public FrameworkContainer(IProject project, FrameworkContentProvider provider) {
        this.project = project;
        this.provider = provider;
    }

    public Object[] getChildren(Object object) {
        return this.getFrameworkLinks();
    }

    private void runOperation(IRunnableWithProgress operation, boolean fork, boolean cancelable) throws InvocationTargetException, InterruptedException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        Assert.isNotNull((Object)window, (String)"The workbench window is gone!");
        Shell parent = window.getShell();
        new ProgressMonitorDialog(parent).run(fork, cancelable, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IContainer[] getFrameworkLinks() {
        IFrameworkData data = SFCorePlugin.getData((IProject)this.project);
        if (data == null) {
            return EMPTY_LIBRARY;
        }
        HashMap<String, Object> ids = new HashMap<String, Object>();
        FrameworkContainer frameworkContainer = this;
        synchronized (frameworkContainer) {
            SoftwareFramework[] softwareFrameworkArray = SFCorePlugin.getDefault().getFrameworks();
            int n = softwareFrameworkArray.length;
            int n2 = 0;
            while (n2 < n) {
                block12: {
                    SoftwareFramework fw = softwareFrameworkArray[n2];
                    if (fw.showInNavigator() && fw.isCompatible(this.project)) {
                        QualifiedName qname = new QualifiedName("com.atmel.avr32.sf.core.ui.navigator", fw.getId());
                        try {
                            String p = this.project.getPersistentProperty(qname);
                            if (p == null || !Boolean.parseBoolean(p)) break block12;
                            try {
                                final URI uri = new URI("framework", null, String.valueOf('/') + fw.getId(), null);
                                IContainer[] existing = this.project.getWorkspace().getRoot().findContainersForLocationURI(uri);
                                if (existing.length == 0) {
                                    final IFolder folder = this.project.getFolder(fw.getName());
                                    if (!folder.exists()) {
                                        WorkspaceModifyOperation wmo = new WorkspaceModifyOperation(){

                                            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                                folder.createLink(uri, 0, monitor);
                                                folder.setHidden(true);
                                                try {
                                                    ResourceAttributes resourceAttributes = folder.getResourceAttributes();
                                                    resourceAttributes.setHidden(true);
                                                    folder.setResourceAttributes(resourceAttributes);
                                                }
                                                catch (Exception exception) {}
                                            }
                                        };
                                        this.runOperation((IRunnableWithProgress)wmo, false, false);
                                    }
                                    ids.put(fw.getId(), folder);
                                    break block12;
                                }
                                ids.put(fw.getId(), existing[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                ++n2;
            }
        }
        return (IContainer[])ids.values().toArray(new IFolder[ids.size()]);
    }

    public String getLabel(Object object) {
        return "Software Libraries";
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return NavigatorPlugin.getDefault().getImageRegistry().getDescriptor("FRAMEWORKS_ICON");
    }
}

