/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.IdGenerator;
import org.eclipse.mylyn.wikitext.core.parser.Locator;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.core.validation.Messages;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.core.validation.ValidationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentLocalReferenceValidationRule
extends ValidationRule {
    protected abstract MarkupLanguage createMarkupLanguage();

    @Override
    public ValidationProblem findProblem(String markup, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ValidationProblem> findProblems(String markup, int offset, int length) {
        MarkupLanguage markupLanguage = this.createMarkupLanguage();
        OutlineParserExtension outlineParser = new OutlineParserExtension(offset, length);
        outlineParser.setMarkupLanguage(markupLanguage);
        outlineParser.parse(markup);
        ArrayList<ValidationProblem> problems = null;
        if (outlineParser.references != null) {
            Set<String> anchorNames = outlineParser.idGenerator.getAnchorNames();
            for (LocalReference reference : outlineParser.references) {
                if (anchorNames.contains(reference.name)) continue;
                if (problems == null) {
                    problems = new ArrayList<ValidationProblem>();
                }
                problems.add(new ValidationProblem(ValidationProblem.Severity.ERROR, MessageFormat.format(Messages.getString("DocumentLocalReferenceValidationRule.0"), reference.name), reference.offset, reference.length));
            }
        }
        if (problems == null) {
            return Collections.emptyList();
        }
        return problems;
    }

    private final class LocalReference {
        String name;
        int offset;
        int length;

        public LocalReference(String name, int offset, int length) {
            this.name = name;
            this.offset = offset;
            this.length = length;
            if (length < 0) {
                throw new IllegalArgumentException();
            }
        }
    }

    private final class OutlineParserExtension
    extends OutlineParser {
        public IdGenerator idGenerator;
        private final int offset;
        private final int length;
        private List<LocalReference> references;

        private OutlineParserExtension(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        protected boolean isBlocksOnly() {
            return false;
        }

        public DocumentBuilder createOutlineUpdater(OutlineItem rootItem) {
            return new OutlineBuilderExtension(rootItem, this.getLabelMaxLength());
        }

        public void processLink(Locator locator, String href) {
            if (locator.getDocumentOffset() < this.offset || locator.getDocumentOffset() >= this.offset + this.length) {
                return;
            }
            if (href.length() > 0 && href.charAt(0) == '#') {
                if (this.references == null) {
                    this.references = new ArrayList<LocalReference>();
                }
                String name = href.substring(1);
                int length = locator.getLineSegmentEndOffset() - locator.getLineCharacterOffset();
                this.references.add(new LocalReference(name, locator.getDocumentOffset(), length));
            }
        }

        private final class OutlineBuilderExtension
        extends OutlineParser.OutlineBuilder {
            private OutlineBuilderExtension(OutlineItem root, int labelMaxLength) {
                super(root, labelMaxLength);
                OutlineParserExtension.this.idGenerator = this.idGenerator;
            }

            public void link(Attributes attributes, String hrefOrHashName, String text) {
                super.link(attributes, hrefOrHashName, text);
                OutlineParserExtension.this.processLink(this.getLocator(), hrefOrHashName);
            }

            public void imageLink(Attributes linkAttributes, Attributes ImageAttributes2, String href, String imageUrl) {
                super.imageLink(linkAttributes, ImageAttributes2, href, imageUrl);
                OutlineParserExtension.this.processLink(this.getLocator(), href);
            }
        }
    }
}

