/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal.wizards;

import com.atmel.avr32.target.ui.internal.wizards.NewFusesCreationPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewFusesFileWizard
extends BasicNewResourceWizard {
    NewFusesCreationPage mainPage;

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.atmel.avr32.target", (String)"icons/wizban/newfuses_wiz.png"));
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New fuse settings");
    }

    public void addPages() {
        this.mainPage = new NewFusesCreationPage("newFilePage1", this.getSelection());
        this.mainPage.setTitle("Fuse settings");
        this.mainPage.setDescription("Create a new fuse settings definition. The file name must end with \".fuses\"");
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        String filename = this.mainPage.getFileName();
        if (!filename.endsWith(".fuses")) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {}
        return true;
    }
}

