/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal.wizards;

import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.ui.internal.wizards.ResourceAndContainerGroup;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class NewFusesCreationPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private ResourceAndContainerGroup resourceGroup;
    private IStructuredSelection currentSelection;
    private IFile newFile;
    private Combo fTargetCPU;
    private String initialFileName;
    private IPath initialContainerFullPath;

    protected NewFusesCreationPage(String pageName) {
        super(pageName);
    }

    protected NewFusesCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.currentSelection = selection;
    }

    private void addMCUSection(Composite composite) {
        Label label2 = new Label(composite, 0);
        label2.setText("Microcontroller");
        label2.setLayoutData((Object)new GridData());
        this.fTargetCPU = new Combo(composite, 2060);
        for (String name : PartRegistry.getPartNames()) {
            this.fTargetCPU.add(name);
        }
        GridData gd = new GridData();
        gd.minimumWidth = 150;
        this.fTargetCPU.setLayoutData((Object)gd);
        this.fTargetCPU.setText(PartRegistry.getDefaultPart());
    }

    protected InputStream getInitialContents() {
        StringBuffer sb = new StringBuffer();
        sb.append("MCU=" + this.fTargetCPU.getText());
        return new StringBufferInputStream(sb.toString());
    }

    public void setFileName(String value) {
        if (this.resourceGroup == null) {
            this.initialFileName = value;
        } else {
            this.resourceGroup.setResource(value);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        this.resourceGroup = new ResourceAndContainerGroup(topLevel, this, "File na&me", "file", false, 250);
        this.resourceGroup.setAllowExistingResources(false);
        this.initialPopulateContainerNameField();
        if (this.initialFileName != null) {
            this.resourceGroup.setResource(this.initialFileName);
        }
        this.addMCUSection(this.resourceGroup.getNameGroup());
        this.resourceGroup.getNameGroup().setFocus();
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    public IPath getContainerFullPath() {
        return this.resourceGroup.getContainerFullPath();
    }

    public String getFileName() {
        if (this.resourceGroup == null) {
            return this.initialFileName;
        }
        return this.resourceGroup.getResource();
    }

    protected IFile createFileHandle(IPath filePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    protected ISchedulingRule createRule(IResource resource) {
        IContainer parent = resource.getParent();
        while (parent != null) {
            if (parent.exists()) {
                return resource.getWorkspace().getRuleFactory().createRule(resource);
            }
            resource = parent;
            parent = parent.getParent();
        }
        return resource.getWorkspace().getRoot();
    }

    protected void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            IPath path = fileHandle.getFullPath();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int numSegments = path.segmentCount();
            if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                int i = numSegments - 2;
                while (i > 0) {
                    IFolder folder = root.getFolder(path.removeLastSegments(i));
                    if (!folder.exists()) {
                        folder.create(false, true, monitor);
                    }
                    --i;
                }
            }
            fileHandle.create(contents, false, monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public IFile createNewFile() {
        if (this.newFile != null) {
            return this.newFile;
        }
        final IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFilePath = containerPath.append(this.resourceGroup.getResource());
        final IFile newFileHandle = this.createFileHandle(newFilePath);
        final InputStream initialContents = this.getInitialContents();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(this.createRule((IResource)newFileHandle)){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(IDEWorkbenchMessages.WizardNewFileCreationPage_progress, 2000);
                    ContainerGenerator generator = new ContainerGenerator(containerPath);
                    generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    NewFusesCreationPage.this.createFile(newFileHandle, initialContents, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                TargetPlugin.errorMessage("Could create new file", ((CoreException)e.getTargetException()).getMessage());
            } else {
                TargetPlugin.errorMessage("Could create new file", e.getTargetException().getMessage());
            }
            e.printStackTrace();
            return null;
        }
        this.newFile = newFileHandle;
        return this.newFile;
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected void initialPopulateContainerNameField() {
        if (this.initialContainerFullPath != null) {
            this.resourceGroup.setContainerFullPath(this.initialContainerFullPath);
        } else {
            Iterator it = this.currentSelection.iterator();
            if (it.hasNext()) {
                Object object = it.next();
                IResource selectedResource = null;
                if (object instanceof IResource) {
                    selectedResource = (IResource)object;
                } else if (object instanceof IAdaptable) {
                    selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
                }
                if (selectedResource != null) {
                    if (selectedResource.getType() == 1) {
                        selectedResource = selectedResource.getParent();
                    }
                    if (selectedResource.isAccessible()) {
                        this.resourceGroup.setContainerFullPath(selectedResource.getFullPath());
                    }
                }
            }
        }
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            valid = false;
        }
        if (valid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }
}

