/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.ILimitingTargetAlgorithmAdapter;
import com.atmel.avr32.target.ITargetAlgorithmAdapter;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.tool.model.Voltage;
import com.atmel.avr32.target.ui.internal.AbstractToolSection;
import com.atmel.avr32.target.ui.internal.Messages;
import com.atmel.avr32.util.math.SIPrefixParser;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class VoltageSection
extends AbstractToolSection {
    private static final String COLON = ":";
    private static final String EMPTY_STRING = "";
    private static final String VOLTS = "V";
    HashMap<String, ITargetAlgorithmAdapter> algorithms;
    private int role;
    HashMap<String, Scale> scales = new HashMap();
    HashMap<String, Text> texts = new HashMap();
    private Voltage[] voltages;

    public VoltageSection(Composite parent, String title, TabbedPropertySheetWidgetFactory toolkit, Control above, int role) {
        super(parent, title, toolkit, above);
        this.algorithms = new HashMap();
        this.voltages = new Voltage[0];
        this.role = role;
    }

    public VoltageSection(Composite parent, String title, TabbedPropertySheetWidgetFactory toolkit, int role) {
        super(parent, title, toolkit);
        this.algorithms = new HashMap();
        this.voltages = new Voltage[0];
        this.role = role;
    }

    @Override
    protected void applyValues() {
        ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(this.getTarget(), this.role == 1);
        if (adapter == null) {
            return;
        }
        adapter.setTarget(this.getTarget());
        IStatus status = adapter.applyVoltages(this.voltages);
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getControl().getShell(), (String)Messages.VoltageSection_Error, (String)Messages.VoltageSection_CouldNotSetVoltage, (IStatus)status);
        }
    }

    @Override
    protected void clearValues() {
        Voltage[] voltageArray = this.voltages;
        int n = this.voltages.length;
        int n2 = 0;
        while (n2 < n) {
            Scale scale;
            Voltage voltage = voltageArray[n2];
            voltage.setValue(0.0f);
            Text text = this.texts.get(voltage.getId());
            if (text != null && !text.isDisposed()) {
                text.setText(String.valueOf(SIPrefixParser.getString((float)0.0f)) + VOLTS);
            }
            if ((scale = this.scales.get(voltage.getId())) != null && !scale.isDisposed()) {
                scale.setSelection(0);
            }
            ++n2;
        }
    }

    @Override
    public void createControls(Composite composite) {
        boolean readOnly = true;
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        GridData ld = new GridData();
        ld.widthHint = 60;
        Voltage[] voltageArray = this.voltages;
        int n = this.voltages.length;
        int n2 = 0;
        while (n2 < n) {
            final Voltage voltage = voltageArray[n2];
            if (voltage.isWritable()) {
                readOnly = false;
            }
            final ITargetAlgorithmAdapter alg = this.getTool().getAlgorithm(voltage.getId());
            this.algorithms.put(voltage.getId(), alg);
            final float factor = 1.0f / voltage.getVoltageStep();
            CLabel label = this.getToolkit().createCLabel(composite, String.valueOf(voltage.getName()) + COLON);
            label.setLayoutData((Object)this.createLabelGridData());
            final Scale scale = new Scale(composite, 0);
            scale.setBackground(this.getToolkit().getColors().getBackground());
            this.updateScaleMaximum(scale, voltage.getMaxVoltage(), factor);
            scale.setMinimum((int)(voltage.getMinVoltage() * factor));
            scale.setIncrement((int)(voltage.getVoltageStep() * factor));
            scale.setPageIncrement((int)(voltage.getVoltageStep() * factor));
            scale.setSelection((int)(voltage.getValue() * factor));
            scale.setLayoutData((Object)gd);
            this.scales.put(voltage.getId(), scale);
            final Text text = this.getToolkit().createText(composite, String.valueOf(SIPrefixParser.getString((float)voltage.getValue())) + VOLTS, 131072);
            this.texts.put(voltage.getId(), text);
            text.setLayoutData((Object)ld);
            if (!voltage.isWritable()) {
                scale.setEnabled(false);
                text.setEnabled(false);
            }
            scale.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    float value = alg.calculateValue((float)scale.getSelection() / factor);
                    text.setText(String.valueOf(SIPrefixParser.getString((float)value)) + VoltageSection.VOLTS);
                    voltage.setValue(value);
                    VoltageSection.this.setStatus(alg.testValue(value));
                    VoltageSection.this.guardVoltages(scale, voltage);
                }
            });
            scale.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    VoltageSection.this.updateVoltagesFromScales();
                }
            });
            text.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent evt) {
                    switch (evt.detail) {
                        case 4: 
                        case 8: 
                        case 16: {
                            float value = SIPrefixParser.getFloat((String)text.getText());
                            value = alg.calculateValue(value);
                            scale.setSelection((int)(value * factor));
                            text.setText(String.valueOf(SIPrefixParser.getString((float)value)) + VoltageSection.VOLTS);
                            voltage.setValue(value);
                            VoltageSection.this.guardVoltages(scale, voltage);
                            VoltageSection.this.setStatus(alg.testValue(value));
                        }
                    }
                }
            });
            ++n2;
        }
        if (this.voltages.length > 0) {
            this.createButtons(composite, readOnly);
        } else {
            Label l = this.getToolkit().createLabel(composite, MessageFormat.format(Messages.VoltageSection_NoVoltageLines, new Object[0]));
            l.setLayoutData((Object)gd);
        }
    }

    private Voltage[] getVoltages() {
        return this.voltages;
    }

    private void guardVoltages(Scale scale, Voltage voltage) {
        block5: {
            block4: {
                if (!voltage.getType().equals("target")) break block4;
                Voltage[] voltageArray = this.getVoltages();
                int n = voltageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Voltage otherVoltage = voltageArray[n2];
                    if (otherVoltage.getType().equals("aref") && otherVoltage.getValue() > voltage.getValue()) {
                        this.updateVisuals(otherVoltage, voltage.getValue());
                    }
                    ++n2;
                }
                break block5;
            }
            if (!voltage.getType().equals("aref")) break block5;
            Voltage[] voltageArray = this.getVoltages();
            int n = voltageArray.length;
            int n3 = 0;
            while (n3 < n) {
                Voltage otherVoltage = voltageArray[n3];
                if (otherVoltage.getType().equals("target") && otherVoltage.getValue() < voltage.getValue()) {
                    this.updateVisuals(otherVoltage, voltage.getValue());
                }
                ++n3;
            }
        }
    }

    @Override
    protected void readValues() {
        IStatus status = null;
        ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(this.getTarget(), this.role == 1);
        if (adapter == null) {
            return;
        }
        adapter.setTarget(this.getTarget());
        status = adapter.readVoltages(this.voltages);
        Voltage[] voltageArray = this.voltages;
        int n = this.voltages.length;
        int n2 = 0;
        while (n2 < n) {
            Voltage voltage = voltageArray[n2];
            Scale scale = this.scales.get(voltage.getId());
            Text text = this.texts.get(voltage.getId());
            float factor = 1.0f / voltage.getVoltageStep();
            float value = voltage.getValue();
            scale.setSelection(status.isOK() ? (int)(value * factor) : 0);
            text.setText(status.isOK() ? String.valueOf(SIPrefixParser.getString((float)value)) + VOLTS : EMPTY_STRING);
            this.updateMaximumVoltage(adapter, voltage, scale);
            ++n2;
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getControl().getShell(), (String)Messages.VoltageSection_Error, (String)Messages.VoltageSection_CouldNotReadVoltage, (IStatus)status);
        }
    }

    @Override
    public void setTool(Tool tool) {
        this.voltages = tool != null ? tool.getVoltages() : new Voltage[0];
        super.setTool(tool);
    }

    private void updateMaximumVoltage(ITargetInterface targetInterface, Voltage voltage, Scale scale) {
        ITargetAlgorithmAdapter algorithm = this.algorithms.get(voltage.getId());
        if (algorithm != null && algorithm instanceof ILimitingTargetAlgorithmAdapter) {
            this.updateScaleMaximum(scale, ((ILimitingTargetAlgorithmAdapter)algorithm).getMaximumValue(voltage.getId(), targetInterface), 1.0f / voltage.getVoltageStep());
        }
    }

    private void updateScaleMaximum(Scale scale, float voltage, float factor) {
        scale.setMaximum((int)(voltage * factor));
    }

    private void updateVisuals(Voltage voltage, float newValue) {
        this.scales.get(voltage.getId()).setSelection((int)(newValue / voltage.getVoltageStep()));
        this.texts.get(voltage.getId()).setText(String.valueOf(SIPrefixParser.getString((float)newValue)) + VOLTS);
    }

    protected void updateVoltagesFromScales() {
        Voltage[] voltageArray = this.getVoltages();
        int n = voltageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Voltage v = voltageArray[n2];
            float value = (float)this.scales.get(v.getId()).getSelection() * v.getVoltageStep();
            ITargetAlgorithmAdapter alg = this.algorithms.get(v.getId());
            v.setValue(alg.calculateValue(value));
            ++n2;
        }
    }
}

