/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetAction;
import com.atmel.avr32.target.ITargetModifiedListener;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.internal.TargetManager;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class ToolbarActionMenu
implements IWorkbenchWindowPulldownDelegate,
ITargetModifiedListener {
    Menu fMenu;
    ITarget currentTarget;

    private void updateMenu() {
        MenuItem[] items;
        MenuItem[] menuItemArray = items = this.fMenu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item.getData() instanceof ActionContributionItem) {
                ITargetAction action = (ITargetAction)((ActionContributionItem)item.getData()).getAction();
                action.setTarget(this.currentTarget);
            }
            ++n2;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.currentTarget != null) {
            this.fMenu = new Menu(parent);
            for (ITargetAction action : TargetPlugin.getDefault().getTargetActions(this.currentTarget)) {
                if (action.isDynamic()) continue;
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(this.fMenu, -1);
            }
            this.updateMenu();
        } else {
            this.fMenu = null;
        }
        return this.fMenu;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.currentTarget = TargetManager.getDefault().getDefaultTarget();
        TargetManager.getDefault().addTargetModifiedListener(this);
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    @Override
    public void targetModified(ITarget target) {
        this.currentTarget = TargetManager.getDefault().getDefaultTarget();
    }
}

